/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.controller;

import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.tenant.entity.CallCostRecord;
import com.saas.tenant.service.CallCostTrackingService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/costs"})
@PreAuthorize(value="hasRole('SYSTEM_ADMIN')")
public class AdminCostController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminCostController.class);
    private final CallCostTrackingService callCostTrackingService;
    private final TenantRepository tenantRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/tenant/{tenantId}"})
    public ResponseEntity<Map<String, Object>> getTenantCosts(@PathVariable String tenantId, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate) {
        log.info("\ud83d\udcca Fetching costs for tenant: {} from {} to {}", new Object[]{tenantId, startDate, endDate});
        Optional tenantOpt = this.tenantRepository.findByTenantId(tenantId);
        if (tenantOpt.isEmpty()) {
            return ResponseEntity.notFound().build();
        }
        String schemaName = ((Tenant)tenantOpt.get()).getSchemaName();
        LocalDateTime start = startDate != null ? startDate.atStartOfDay() : LocalDate.now().withDayOfMonth(1).atStartOfDay();
        LocalDateTime end = endDate != null ? endDate.atTime(23, 59, 59) : LocalDateTime.now();
        TenantContext.setTenantId((String)schemaName);
        try {
            Map report = this.callCostTrackingService.getTenantCostReport(start, end);
            List records = this.callCostTrackingService.getAllCostRecords(start, end);
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("tenantId", tenantId);
            response.put("tenantName", ((Tenant)tenantOpt.get()).getTenantName());
            response.put("schemaName", schemaName);
            response.put("period", Map.of("start", start, "end", end));
            response.put("summary", report);
            response.put("records", records);
            ResponseEntity responseEntity = ResponseEntity.ok(response);
            return responseEntity;
        }
        finally {
            TenantContext.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/summary"})
    public ResponseEntity<Map<String, Object>> getGlobalCostSummary(@RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate) {
        LocalDateTime start = startDate != null ? startDate.atStartOfDay() : LocalDate.now().withDayOfMonth(1).atStartOfDay();
        LocalDateTime end = endDate != null ? endDate.atTime(23, 59, 59) : LocalDateTime.now();
        log.info("\ud83d\udcca Fetching global cost summary from {} to {}", (Object)start, (Object)end);
        List tenants = this.tenantRepository.findAll();
        HashMap<String, Object> globalSummary = new HashMap<String, Object>();
        BigDecimal totalCost = BigDecimal.ZERO;
        Long totalCalls = 0L;
        HashMap<String, BigDecimal> costByProvider = new HashMap<String, BigDecimal>();
        ArrayList tenantSummaries = new ArrayList();
        for (Tenant tenant : tenants) {
            try {
                TenantContext.setTenantId((String)tenant.getSchemaName());
                Map tenantReport = this.callCostTrackingService.getTenantCostReport(start, end);
                BigDecimal tenantCost = tenantReport.getOrDefault("totalCost", BigDecimal.ZERO);
                Long tenantCalls = tenantReport.getOrDefault("totalCalls", 0L);
                Map tenantProviderCosts = tenantReport.getOrDefault("costByProvider", new HashMap());
                totalCost = totalCost.add(tenantCost);
                totalCalls = totalCalls + tenantCalls;
                for (Map.Entry entry : tenantProviderCosts.entrySet()) {
                    costByProvider.merge((String)entry.getKey(), (BigDecimal)entry.getValue(), BigDecimal::add);
                }
                HashMap<String, Object> tenantSummary = new HashMap<String, Object>();
                tenantSummary.put("tenantId", tenant.getTenantId());
                tenantSummary.put("tenantName", tenant.getTenantName());
                tenantSummary.put("totalCost", tenantCost);
                tenantSummary.put("totalCalls", tenantCalls);
                tenantSummary.put("costByProvider", tenantProviderCosts);
                tenantSummaries.add(tenantSummary);
            }
            catch (Exception e) {
                log.error("Error fetching costs for tenant: {}", (Object)tenant.getTenantId(), (Object)e);
            }
            finally {
                TenantContext.clear();
            }
        }
        globalSummary.put("period", Map.of("start", start, "end", end));
        globalSummary.put("totalCost", totalCost);
        globalSummary.put("totalCalls", totalCalls);
        globalSummary.put("costByProvider", costByProvider);
        globalSummary.put("tenantCount", tenants.size());
        globalSummary.put("tenants", tenantSummaries);
        log.info("\ud83d\udcb0 Global summary - Total cost: {} USD, Total calls: {}, Tenants: {}", new Object[]{totalCost, totalCalls, tenants.size()});
        return ResponseEntity.ok(globalSummary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"/provider/{provider}"})
    @PreAuthorize(value="hasRole('SYSTEM_ADMIN')")
    public ResponseEntity<Map<String, Object>> getCostsByProvider(@PathVariable String provider, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate startDate, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate endDate) {
        LocalDateTime start = startDate != null ? startDate.atStartOfDay() : LocalDate.now().withDayOfMonth(1).atStartOfDay();
        LocalDateTime end = endDate != null ? endDate.atTime(23, 59, 59) : LocalDateTime.now();
        log.info("\ud83d\udcca Fetching costs for provider: {} from {} to {}", new Object[]{provider, start, end});
        List tenants = this.tenantRepository.findAll();
        ArrayList<CallCostRecord> allRecords = new ArrayList<CallCostRecord>();
        BigDecimal totalCost = BigDecimal.ZERO;
        for (Tenant tenant : tenants) {
            try {
                TenantContext.setTenantId((String)tenant.getSchemaName());
                List records = this.callCostTrackingService.getCostRecordsByProvider(provider.toUpperCase());
                for (CallCostRecord record : records) {
                    if (record.getCallStartTime() == null || record.getCallStartTime().isBefore(start) || record.getCallStartTime().isAfter(end)) continue;
                    allRecords.add(record);
                    if (record.getCost() == null) continue;
                    totalCost = totalCost.add(record.getCost());
                }
            }
            catch (Exception e) {
                log.error("Error fetching provider costs for tenant: {}", (Object)tenant.getTenantId(), (Object)e);
            }
            finally {
                TenantContext.clear();
            }
        }
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("provider", provider.toUpperCase());
        response.put("period", Map.of("start", start, "end", end));
        response.put("totalCost", totalCost);
        response.put("totalCalls", allRecords.size());
        response.put("records", allRecords);
        return ResponseEntity.ok(response);
    }

    @Generated
    public AdminCostController(CallCostTrackingService callCostTrackingService, TenantRepository tenantRepository) {
        this.callCostTrackingService = callCostTrackingService;
        this.tenantRepository = tenantRepository;
    }
}

