/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.controller;

import com.saas.admin.dto.request.CreateVoipConfigRequest;
import com.saas.admin.dto.request.UpdateVoipConfigRequest;
import com.saas.admin.dto.response.VoipConfigResponse;
import com.saas.admin.entity.TenantVoipConfig;
import com.saas.admin.service.TenantVoipConfigAdminService;
import com.saas.shared.dto.mapper.VoipConfigMapper;
import com.saas.shared.enums.Provider;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tenants/{tenantId}/voip-configs"})
@PreAuthorize(value="hasRole('SYSTEM_ADMIN')")
public class AdminTenantVoipConfigController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AdminTenantVoipConfigController.class);
    private final TenantVoipConfigAdminService voipConfigAdminService;
    private final VoipConfigMapper voipConfigMapper;

    @PostMapping
    public ResponseEntity<VoipConfigResponse> createVoipConfig(@PathVariable String tenantId, @Valid @RequestBody CreateVoipConfigRequest request) {
        log.info("\ud83d\udcde Admin creating VoIP config for tenant: {}, provider: {}", (Object)tenantId, (Object)request.getProvider());
        TenantVoipConfig config = this.voipConfigMapper.toEntity(request);
        config.setTenantId(tenantId);
        TenantVoipConfig saved = this.voipConfigAdminService.saveVoipConfig(config);
        VoipConfigResponse response = this.voipConfigMapper.toResponse(saved);
        log.info("\u2705 VoIP config created successfully with ID: {}", (Object)saved.getId());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @GetMapping
    public ResponseEntity<List<VoipConfigResponse>> getAllVoipConfigs(@PathVariable String tenantId) {
        log.info("\ud83d\udccb Fetching all VoIP configs for tenant: {}", (Object)tenantId);
        List configs = this.voipConfigAdminService.getAllConfigsForTenant(tenantId);
        List responses = this.voipConfigMapper.toResponseList(configs);
        return ResponseEntity.ok((Object)responses);
    }

    @GetMapping(value={"/{provider}"})
    public ResponseEntity<VoipConfigResponse> getVoipConfigByProvider(@PathVariable String tenantId, @PathVariable Provider provider) {
        log.info("\ud83d\udd0d Fetching VoIP config for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
        Optional config = this.voipConfigAdminService.getVoipConfig(tenantId, provider);
        if (config.isEmpty()) {
            log.info("\u26a0\ufe0f No DB config found - tenant is using environment variable defaults");
            return ResponseEntity.notFound().build();
        }
        VoipConfigResponse response = this.voipConfigMapper.toResponse((TenantVoipConfig)config.get());
        return ResponseEntity.ok((Object)response);
    }

    @PutMapping(value={"/{provider}"})
    public ResponseEntity<VoipConfigResponse> updateVoipConfig(@PathVariable String tenantId, @PathVariable Provider provider, @Valid @RequestBody UpdateVoipConfigRequest request) {
        log.info("\u270f\ufe0f Admin updating VoIP config for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
        Optional configOpt = this.voipConfigAdminService.getVoipConfig(tenantId, provider);
        if (configOpt.isEmpty()) {
            log.warn("\u26a0\ufe0f Cannot update non-existent config for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
            return ResponseEntity.notFound().build();
        }
        TenantVoipConfig config = (TenantVoipConfig)configOpt.get();
        this.voipConfigMapper.updateEntity(request, config);
        config.setTenantId(tenantId);
        config.setProvider(provider);
        TenantVoipConfig updated = this.voipConfigAdminService.saveVoipConfig(config);
        VoipConfigResponse response = this.voipConfigMapper.toResponse(updated);
        log.info("\u2705 VoIP config updated successfully");
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{provider}"})
    public ResponseEntity<Void> deleteVoipConfig(@PathVariable String tenantId, @PathVariable Provider provider) {
        log.info("\ud83d\uddd1\ufe0f Admin deleting VoIP config for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
        this.voipConfigAdminService.deleteVoipConfig(tenantId, provider);
        return ResponseEntity.noContent().build();
    }

    @PatchMapping(value={"/{provider}/activate"})
    public ResponseEntity<Void> activateVoipConfig(@PathVariable String tenantId, @PathVariable Provider provider) {
        log.info("\u2705 Admin activating VoIP config for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
        this.voipConfigAdminService.toggleVoipConfig(tenantId, provider, true);
        return ResponseEntity.ok().build();
    }

    @PatchMapping(value={"/{provider}/deactivate"})
    public ResponseEntity<Void> deactivateVoipConfig(@PathVariable String tenantId, @PathVariable Provider provider) {
        log.info("\u26d4 Admin deactivating VoIP config for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
        this.voipConfigAdminService.toggleVoipConfig(tenantId, provider, false);
        return ResponseEntity.ok().build();
    }

    @Generated
    public AdminTenantVoipConfigController(TenantVoipConfigAdminService voipConfigAdminService, VoipConfigMapper voipConfigMapper) {
        this.voipConfigAdminService = voipConfigAdminService;
        this.voipConfigMapper = voipConfigMapper;
    }
}

