/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.entity;

import com.saas.admin.entity.Permission;
import com.saas.admin.entity.RolePermission;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.hibernate.annotations.CreationTimestamp;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="permissions", schema="saas_db", uniqueConstraints={@UniqueConstraint(columnNames={"resource", "action"})})
public class Permission {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false, length=50)
    private String resource;
    @Column(nullable=false, length=50)
    private String action;
    @Column(length=500)
    private String description;
    @Column(nullable=false)
    private Boolean isActive;
    @Column(nullable=false)
    private Boolean isSystem;
    @OneToMany(mappedBy="permission", cascade={CascadeType.ALL}, orphanRemoval=true)
    private Set<RolePermission> rolePermissions;
    @CreationTimestamp
    @Column(nullable=false, updatable=false)
    private LocalDateTime createdAt;

    public String getPermissionString() {
        return this.resource + ":" + this.action;
    }

    public static Permission fromString(String permissionString, String description) {
        String[] parts = permissionString.split(":");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Invalid permission format. Expected 'resource:action', got: " + permissionString);
        }
        return Permission.builder().resource(parts[0].toLowerCase()).action(parts[1].toLowerCase()).description(description).isActive(Boolean.valueOf(true)).isSystem(Boolean.valueOf(false)).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Permission)) {
            return false;
        }
        Permission that = (Permission)o;
        return this.resource.equals(that.resource) && this.action.equals(that.action);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.action);
    }

    @Generated
    private static Boolean $default$isActive() {
        return true;
    }

    @Generated
    private static Boolean $default$isSystem() {
        return false;
    }

    @Generated
    private static Set<RolePermission> $default$rolePermissions() {
        return new HashSet<RolePermission>();
    }

    @Generated
    public static PermissionBuilder builder() {
        return new PermissionBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getResource() {
        return this.resource;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getIsActive() {
        return this.isActive;
    }

    @Generated
    public Boolean getIsSystem() {
        return this.isSystem;
    }

    @Generated
    public Set<RolePermission> getRolePermissions() {
        return this.rolePermissions;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setResource(String resource) {
        this.resource = resource;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setIsActive(Boolean isActive) {
        this.isActive = isActive;
    }

    @Generated
    public void setIsSystem(Boolean isSystem) {
        this.isSystem = isSystem;
    }

    @Generated
    public void setRolePermissions(Set<RolePermission> rolePermissions) {
        this.rolePermissions = rolePermissions;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public String toString() {
        return "Permission(id=" + this.getId() + ", resource=" + this.getResource() + ", action=" + this.getAction() + ", description=" + this.getDescription() + ", isActive=" + this.getIsActive() + ", isSystem=" + this.getIsSystem() + ", rolePermissions=" + String.valueOf(this.getRolePermissions()) + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ")";
    }

    @Generated
    public Permission() {
        this.isActive = Permission.$default$isActive();
        this.isSystem = Permission.$default$isSystem();
        this.rolePermissions = Permission.$default$rolePermissions();
    }

    @Generated
    public Permission(Long id, String resource, String action, String description, Boolean isActive, Boolean isSystem, Set<RolePermission> rolePermissions, LocalDateTime createdAt) {
        this.id = id;
        this.resource = resource;
        this.action = action;
        this.description = description;
        this.isActive = isActive;
        this.isSystem = isSystem;
        this.rolePermissions = rolePermissions;
        this.createdAt = createdAt;
    }
}

