/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.service;

import com.saas.admin.entity.Permission;
import com.saas.admin.repository.PermissionRepository;
import com.saas.admin.repository.RolePermissionRepository;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PermissionService.class);
    private final PermissionRepository permissionRepository;
    private final RolePermissionRepository rolePermissionRepository;

    @Transactional
    public Permission createPermission(String resource, String action, String description, boolean isSystem) {
        log.info("\ud83d\udcdd Creating permission: {}:{}", (Object)resource, (Object)action);
        String normalizedResource = resource.toLowerCase();
        String normalizedAction = action.toLowerCase();
        if (this.permissionRepository.existsByResourceAndAction(normalizedResource, normalizedAction)) {
            throw new IllegalArgumentException("Permission '" + normalizedResource + ":" + normalizedAction + "' already exists");
        }
        Permission permission = Permission.builder().resource(normalizedResource).action(normalizedAction).description(description).isActive(Boolean.valueOf(true)).isSystem(Boolean.valueOf(isSystem)).build();
        Permission saved = (Permission)this.permissionRepository.save((Object)permission);
        log.info("\u2705 Permission created with ID: {}", (Object)saved.getId());
        return saved;
    }

    @Transactional
    public Permission createPermissionFromString(String permissionString, String description, boolean isSystem) {
        Permission permission = Permission.fromString((String)permissionString, (String)description);
        permission.setIsSystem(Boolean.valueOf(isSystem));
        return this.createPermission(permission.getResource(), permission.getAction(), description, isSystem);
    }

    @Transactional(readOnly=true)
    public Optional<Permission> getPermissionById(Long id) {
        return this.permissionRepository.findById((Object)id);
    }

    @Transactional(readOnly=true)
    public Optional<Permission> getPermissionByResourceAndAction(String resource, String action) {
        return this.permissionRepository.findByResourceAndAction(resource.toLowerCase(), action.toLowerCase());
    }

    @Transactional(readOnly=true)
    public List<Permission> getAllPermissions() {
        return this.permissionRepository.findAll();
    }

    @Transactional(readOnly=true)
    public List<Permission> getAllActivePermissions() {
        return this.permissionRepository.findByIsActiveTrue();
    }

    @Transactional(readOnly=true)
    public List<Permission> getPermissionsByResource(String resource) {
        return this.permissionRepository.findByResource(resource.toLowerCase());
    }

    @Transactional(readOnly=true)
    public List<String> getAllResources() {
        return this.permissionRepository.findAllResources();
    }

    @Transactional(readOnly=true)
    public List<String> getAllActions() {
        return this.permissionRepository.findAllActions();
    }

    @Transactional
    public Permission updatePermission(Long id, String description, Boolean isActive) {
        log.info("\u270f\ufe0f Updating permission ID: {}", (Object)id);
        Permission permission = (Permission)this.permissionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Permission not found with ID: " + id));
        if (description != null) {
            permission.setDescription(description);
        }
        if (isActive != null) {
            permission.setIsActive(isActive);
        }
        Permission updated = (Permission)this.permissionRepository.save((Object)permission);
        log.info("\u2705 Permission updated");
        return updated;
    }

    @Transactional
    public void deletePermission(Long id) {
        log.info("\ud83d\uddd1\ufe0f Deleting permission ID: {}", (Object)id);
        Permission permission = (Permission)this.permissionRepository.findById((Object)id).orElseThrow(() -> new IllegalArgumentException("Permission not found with ID: " + id));
        if (permission.getIsSystem().booleanValue()) {
            throw new IllegalStateException("Cannot delete system permission: " + permission.getPermissionString());
        }
        long roleCount = this.rolePermissionRepository.findByPermission(permission).size();
        if (roleCount > 0L) {
            throw new IllegalStateException("Cannot delete permission assigned to " + roleCount + " roles. Remove role assignments first.");
        }
        this.permissionRepository.delete((Object)permission);
        log.info("\u2705 Permission deleted");
    }

    @Transactional
    public List<Permission> bulkCreatePermissions(List<String> permissionStrings, boolean isSystem) {
        log.info("\ud83d\udcdd Bulk creating {} permissions", (Object)permissionStrings.size());
        return permissionStrings.stream().map(permString -> {
            try {
                Permission perm = Permission.fromString((String)permString, (String)"Auto-created permission");
                perm.setIsSystem(Boolean.valueOf(isSystem));
                Optional existing = this.permissionRepository.findByResourceAndAction(perm.getResource(), perm.getAction());
                if (existing.isPresent()) {
                    log.debug("\u26a0\ufe0f Permission already exists: {}", permString);
                    return (Permission)existing.get();
                }
                return (Permission)this.permissionRepository.save((Object)perm);
            }
            catch (Exception e) {
                log.error("\u274c Failed to create permission: {}", permString, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).toList();
    }

    @Generated
    public PermissionService(PermissionRepository permissionRepository, RolePermissionRepository rolePermissionRepository) {
        this.permissionRepository = permissionRepository;
        this.rolePermissionRepository = rolePermissionRepository;
    }
}

