/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.security;

import com.saas.shared.core.TenantContext;
import com.saas.shared.enums.UserType;
import com.saas.shared.security.CustomUserDetailsService;
import com.saas.shared.security.JwtTokenProvider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    @Autowired
    private JwtTokenProvider tokenProvider;
    @Autowired
    private CustomUserDetailsService customUserDetailsService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            String jwt = this.getJwtFromRequest(request);
            if (StringUtils.hasText((String)jwt) && this.tokenProvider.validateToken(jwt)) {
                String userId = this.tokenProvider.getUserIdFromToken(jwt);
                String userTypeStr = this.tokenProvider.getUserTypeFromToken(jwt);
                String schemaName = this.tokenProvider.getSchemaNameFromToken(jwt);
                UserDetails userDetails = this.customUserDetailsService.loadUserById(Long.valueOf(Long.parseLong(userId)));
                if (UserType.TENANT_USER.name().equals(userTypeStr) && schemaName != null) {
                    TenantContext.setTenantId((String)schemaName);
                }
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                authentication.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)"Could not set user authentication in security context", (Throwable)ex);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        TenantContext.clear();
    }

    private String getJwtFromRequest(HttpServletRequest request) {
        String bearerToken = request.getHeader("Authorization");
        if (StringUtils.hasText((String)bearerToken) && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        return null;
    }
}

