/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.service;

import com.saas.admin.entity.TenantVoipConfig;
import com.saas.admin.repository.TenantVoipConfigRepository;
import com.saas.shared.dto.VoipConfigDTO;
import com.saas.shared.dto.mapper.VoipConfigDtoMapper;
import com.saas.shared.enums.Provider;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantVoipConfigRuntimeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantVoipConfigRuntimeService.class);
    private final TenantVoipConfigRepository repository;
    private final VoipConfigDtoMapper dtoMapper;

    @Cacheable(value={"voipConfigs"}, key="#tenantId + '_' + #provider")
    @Transactional(readOnly=true)
    public Optional<VoipConfigDTO> resolveVoipConfig(String tenantId, Provider provider) {
        log.info("\ud83d\udd0d Resolving VoIP config for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
        Optional dbConfig = this.repository.findByTenantIdAndProviderAndIsActive(tenantId, provider, Boolean.valueOf(true));
        if (dbConfig.isPresent()) {
            log.info("\u2705 VoIP config found in database (active)");
            VoipConfigDTO dto = this.dtoMapper.toDto((TenantVoipConfig)dbConfig.get());
            return Optional.of(dto);
        }
        log.info("\u26a0\ufe0f No active config in DB, attempting environment variable fallback");
        return this.buildConfigFromEnvironment(tenantId, provider);
    }

    private Optional<VoipConfigDTO> buildConfigFromEnvironment(String tenantId, Provider provider) {
        if (provider == Provider.TELNYX) {
            return this.buildTelnyxConfigFromEnv(tenantId);
        }
        if (provider == Provider.TWILIO) {
            return this.buildTwilioConfigFromEnv(tenantId);
        }
        if (provider == Provider.ZIWO) {
            return this.buildZiwoConfigFromEnv(tenantId);
        }
        log.warn("\u26a0\ufe0f No environment variable configuration available for provider: {}", (Object)provider);
        return Optional.empty();
    }

    private Optional<VoipConfigDTO> buildTelnyxConfigFromEnv(String tenantId) {
        String aiType = System.getenv("TELNYX_AI_TYPE");
        String aiAssistantId = System.getenv("TELNYX_AI_ASSISTANT_ID");
        if (aiAssistantId == null || aiAssistantId.isEmpty()) {
            aiAssistantId = System.getenv("TELNYX_VOICE_AI_ASSISTANT_ID");
        }
        String streamUrl = System.getenv("TELNYX_STREAM_URL");
        if ((aiAssistantId == null || aiAssistantId.isEmpty()) && (streamUrl == null || streamUrl.isEmpty())) {
            log.warn("\u26a0\ufe0f No Telnyx environment variables configured");
            return Optional.empty();
        }
        VoipConfigDTO config = VoipConfigDTO.builder().tenantId(tenantId).provider(Provider.TELNYX).aiAssistantId(aiAssistantId).aiType(aiType != null ? aiType : "TELNYX_NATIVE_AI").streamUrl(streamUrl).isActive(true).fromDatabase(false).build();
        log.info("\u2705 Built Telnyx config from environment variables (fallback mode)");
        return Optional.of(config);
    }

    private Optional<VoipConfigDTO> buildTwilioConfigFromEnv(String tenantId) {
        log.warn("\u26a0\ufe0f Twilio environment variable fallback not yet implemented");
        return Optional.empty();
    }

    private Optional<VoipConfigDTO> buildZiwoConfigFromEnv(String tenantId) {
        log.warn("\u26a0\ufe0f Ziwo environment variable fallback not yet implemented");
        return Optional.empty();
    }

    public boolean hasValidConfig(String tenantId, Provider provider) {
        Optional config = this.resolveVoipConfig(tenantId, provider);
        return config.isPresent() && ((VoipConfigDTO)config.get()).isValid();
    }

    @Generated
    public TenantVoipConfigRuntimeService(TenantVoipConfigRepository repository, VoipConfigDtoMapper dtoMapper) {
        this.repository = repository;
        this.dtoMapper = dtoMapper;
    }
}

