/*
 * Decompiled with CFR 0.152.
 */
package com.saas.tenant.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;
import lombok.Generated;
import org.hibernate.annotations.JdbcTypeCode;

@Entity
@Table(name="call_cost_records")
public class CallCostRecord {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="call_sid", nullable=false, unique=true)
    private String callSid;
    @Column(name="provider", nullable=false)
    private String provider;
    @Column(name="call_duration_seconds")
    private Integer callDurationSeconds;
    @Column(name="cost", precision=10, scale=6)
    private BigDecimal cost;
    @Column(name="currency", length=3)
    private String currency;
    @JdbcTypeCode(value=3001)
    @Column(name="cost_details", columnDefinition="JSON")
    private Map<String, Object> costDetails;
    @Column(name="call_start_time")
    private LocalDateTime callStartTime;
    @Column(name="call_end_time")
    private LocalDateTime callEndTime;
    @Column(name="from_number")
    private String fromNumber;
    @Column(name="to_number")
    private String toNumber;
    @Column(name="created_at", nullable=false, updatable=false)
    private LocalDateTime createdAt;
    @Column(name="updated_at")
    private LocalDateTime updatedAt;

    @PrePersist
    protected void onCreate() {
        this.createdAt = LocalDateTime.now();
        this.updatedAt = LocalDateTime.now();
    }

    @PreUpdate
    protected void onUpdate() {
        this.updatedAt = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCallSid() {
        return this.callSid;
    }

    @Generated
    public String getProvider() {
        return this.provider;
    }

    @Generated
    public Integer getCallDurationSeconds() {
        return this.callDurationSeconds;
    }

    @Generated
    public BigDecimal getCost() {
        return this.cost;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Map<String, Object> getCostDetails() {
        return this.costDetails;
    }

    @Generated
    public LocalDateTime getCallStartTime() {
        return this.callStartTime;
    }

    @Generated
    public LocalDateTime getCallEndTime() {
        return this.callEndTime;
    }

    @Generated
    public String getFromNumber() {
        return this.fromNumber;
    }

    @Generated
    public String getToNumber() {
        return this.toNumber;
    }

    @Generated
    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCallSid(String callSid) {
        this.callSid = callSid;
    }

    @Generated
    public void setProvider(String provider) {
        this.provider = provider;
    }

    @Generated
    public void setCallDurationSeconds(Integer callDurationSeconds) {
        this.callDurationSeconds = callDurationSeconds;
    }

    @Generated
    public void setCost(BigDecimal cost) {
        this.cost = cost;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCostDetails(Map<String, Object> costDetails) {
        this.costDetails = costDetails;
    }

    @Generated
    public void setCallStartTime(LocalDateTime callStartTime) {
        this.callStartTime = callStartTime;
    }

    @Generated
    public void setCallEndTime(LocalDateTime callEndTime) {
        this.callEndTime = callEndTime;
    }

    @Generated
    public void setFromNumber(String fromNumber) {
        this.fromNumber = fromNumber;
    }

    @Generated
    public void setToNumber(String toNumber) {
        this.toNumber = toNumber;
    }

    @Generated
    public void setCreatedAt(LocalDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(LocalDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CallCostRecord)) {
            return false;
        }
        CallCostRecord other = (CallCostRecord)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$callDurationSeconds = this.getCallDurationSeconds();
        Integer other$callDurationSeconds = other.getCallDurationSeconds();
        if (this$callDurationSeconds == null ? other$callDurationSeconds != null : !((Object)this$callDurationSeconds).equals(other$callDurationSeconds)) {
            return false;
        }
        String this$callSid = this.getCallSid();
        String other$callSid = other.getCallSid();
        if (this$callSid == null ? other$callSid != null : !this$callSid.equals(other$callSid)) {
            return false;
        }
        String this$provider = this.getProvider();
        String other$provider = other.getProvider();
        if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
            return false;
        }
        BigDecimal this$cost = this.getCost();
        BigDecimal other$cost = other.getCost();
        if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Map this$costDetails = this.getCostDetails();
        Map other$costDetails = other.getCostDetails();
        if (this$costDetails == null ? other$costDetails != null : !((Object)this$costDetails).equals(other$costDetails)) {
            return false;
        }
        LocalDateTime this$callStartTime = this.getCallStartTime();
        LocalDateTime other$callStartTime = other.getCallStartTime();
        if (this$callStartTime == null ? other$callStartTime != null : !((Object)this$callStartTime).equals(other$callStartTime)) {
            return false;
        }
        LocalDateTime this$callEndTime = this.getCallEndTime();
        LocalDateTime other$callEndTime = other.getCallEndTime();
        if (this$callEndTime == null ? other$callEndTime != null : !((Object)this$callEndTime).equals(other$callEndTime)) {
            return false;
        }
        String this$fromNumber = this.getFromNumber();
        String other$fromNumber = other.getFromNumber();
        if (this$fromNumber == null ? other$fromNumber != null : !this$fromNumber.equals(other$fromNumber)) {
            return false;
        }
        String this$toNumber = this.getToNumber();
        String other$toNumber = other.getToNumber();
        if (this$toNumber == null ? other$toNumber != null : !this$toNumber.equals(other$toNumber)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        return !(this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CallCostRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $callDurationSeconds = this.getCallDurationSeconds();
        result = result * 59 + ($callDurationSeconds == null ? 43 : ((Object)$callDurationSeconds).hashCode());
        String $callSid = this.getCallSid();
        result = result * 59 + ($callSid == null ? 43 : $callSid.hashCode());
        String $provider = this.getProvider();
        result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
        BigDecimal $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Map $costDetails = this.getCostDetails();
        result = result * 59 + ($costDetails == null ? 43 : ((Object)$costDetails).hashCode());
        LocalDateTime $callStartTime = this.getCallStartTime();
        result = result * 59 + ($callStartTime == null ? 43 : ((Object)$callStartTime).hashCode());
        LocalDateTime $callEndTime = this.getCallEndTime();
        result = result * 59 + ($callEndTime == null ? 43 : ((Object)$callEndTime).hashCode());
        String $fromNumber = this.getFromNumber();
        result = result * 59 + ($fromNumber == null ? 43 : $fromNumber.hashCode());
        String $toNumber = this.getToNumber();
        result = result * 59 + ($toNumber == null ? 43 : $toNumber.hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CallCostRecord(id=" + this.getId() + ", callSid=" + this.getCallSid() + ", provider=" + this.getProvider() + ", callDurationSeconds=" + this.getCallDurationSeconds() + ", cost=" + String.valueOf(this.getCost()) + ", currency=" + this.getCurrency() + ", costDetails=" + String.valueOf(this.getCostDetails()) + ", callStartTime=" + String.valueOf(this.getCallStartTime()) + ", callEndTime=" + String.valueOf(this.getCallEndTime()) + ", fromNumber=" + this.getFromNumber() + ", toNumber=" + this.getToNumber() + ", createdAt=" + String.valueOf(this.getCreatedAt()) + ", updatedAt=" + String.valueOf(this.getUpdatedAt()) + ")";
    }

    @Generated
    public CallCostRecord() {
    }

    @Generated
    public CallCostRecord(Long id, String callSid, String provider, Integer callDurationSeconds, BigDecimal cost, String currency, Map<String, Object> costDetails, LocalDateTime callStartTime, LocalDateTime callEndTime, String fromNumber, String toNumber, LocalDateTime createdAt, LocalDateTime updatedAt) {
        this.id = id;
        this.callSid = callSid;
        this.provider = provider;
        this.callDurationSeconds = callDurationSeconds;
        this.cost = cost;
        this.currency = currency;
        this.costDetails = costDetails;
        this.callStartTime = callStartTime;
        this.callEndTime = callEndTime;
        this.fromNumber = fromNumber;
        this.toNumber = toNumber;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }
}

