/*
 * Decompiled with CFR 0.152.
 */
package com.saas.tenant.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.saas.admin.entity.AdminInboundCallData;
import com.saas.admin.repository.AdminInboundCallDataRepository;
import com.saas.shared.core.TenantContext;
import com.saas.tenant.entity.InboundCallData;
import com.saas.tenant.entity.InboundCallRequest;
import com.saas.tenant.repository.InboundCallDataRepository;
import com.saas.tenant.repository.InboundCallRequestRepository;
import jakarta.persistence.EntityManagerFactory;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InboundCallService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InboundCallService.class);
    private final InboundCallDataRepository callDataRepository;
    private final InboundCallRequestRepository callRequestRepository;
    private final AdminInboundCallDataRepository adminCallDataRepository;
    private final EntityManagerFactory entityManagerFactory;

    @Transactional
    public InboundCallData saveCallData(InboundCallData callData) {
        try {
            InboundCallData saved = (InboundCallData)this.callDataRepository.save((Object)callData);
            log.info("\ud83d\udcbe Call data saved - CallSid: {}, From: {}, To: {}", new Object[]{saved.getCallSid(), saved.getFromNumber(), saved.getToNumber()});
            return saved;
        }
        catch (Exception e) {
            log.error("Error saving call data for CallSid: {}", (Object)callData.getCallSid(), (Object)e);
            throw e;
        }
    }

    public InboundCallData saveInBothDatabases(InboundCallData callData, String tenantId, String tenantSchema) {
        AdminInboundCallData adminCallData;
        try {
            adminCallData = AdminInboundCallData.builder().tenantId(tenantId).callSid(callData.getCallSid()).parentCallSid(callData.getParentCallSid()).fromNumber(callData.getFromNumber()).toNumber(callData.getToNumber()).caller(callData.getCaller()).called(callData.getCalled()).forwardedFrom(callData.getForwardedFrom()).provider(callData.getProvider()).direction(callData.getDirection()).callStatus(callData.getCallStatus()).callToken(callData.getCallToken()).fromCity(callData.getFromCity()).fromState(callData.getFromState()).fromZip(callData.getFromZip()).fromCountry(callData.getFromCountry()).toCity(callData.getToCity()).toState(callData.getToState()).toZip(callData.getToZip()).toCountry(callData.getToCountry()).callerCity(callData.getCallerCity()).callerState(callData.getCallerState()).callerZip(callData.getCallerZip()).callerCountry(callData.getCallerCountry()).calledCity(callData.getCalledCity()).calledState(callData.getCalledState()).calledZip(callData.getCalledZip()).calledCountry(callData.getCalledCountry()).startTime(callData.getStartTime()).endTime(callData.getEndTime()).duration(callData.getDuration()).accountSid(callData.getAccountSid()).apiVersion(callData.getApiVersion()).recordingSid(callData.getRecordingSid()).recordingUrl(callData.getRecordingUrl()).stirVerstat(callData.getStirVerstat()).conversation(callData.getConversation()).build();
            adminCallData = (AdminInboundCallData)this.adminCallDataRepository.save((Object)adminCallData);
            log.info("\u2705 [1/2] Call data saved to ADMIN database (saas_db) - CallSid: {}, Tenant: {}", (Object)callData.getCallSid(), (Object)tenantId);
        }
        catch (Exception e) {
            log.error("\u274c CRITICAL: Failed to save call data to ADMIN database - CallSid: {}", (Object)callData.getCallSid(), (Object)e);
            throw new RuntimeException("Failed to save call data to admin database (saas_db): " + e.getMessage(), e);
        }
        try {
            InboundCallData tenantCallData = this.saveInTenantSchema(callData, tenantSchema);
            log.info("\u2705 [2/2] Call data saved to TENANT database ({}) - CallSid: {}", (Object)tenantSchema, (Object)callData.getCallSid());
            log.info("\ud83c\udfaf SUCCESS: Call data saved to BOTH admin and tenant databases");
            return tenantCallData;
        }
        catch (Exception e) {
            log.error("\u274c CRITICAL: Failed to save call data to TENANT database - CallSid: {}", (Object)callData.getCallSid(), (Object)e);
            log.error("\ud83d\udd04 ROLLBACK: Deleting orphaned admin record for CallSid: {}", (Object)callData.getCallSid());
            try {
                this.adminCallDataRepository.delete((Object)adminCallData);
                log.info("\u2705 ROLLBACK SUCCESS: Admin record deleted for CallSid: {}", (Object)callData.getCallSid());
            }
            catch (Exception deleteEx) {
                log.error("\u274c ROLLBACK FAILED: Could not delete admin record - CallSid: {}", (Object)callData.getCallSid(), (Object)deleteEx);
                log.error("\u26a0\ufe0f CRITICAL: Orphaned admin record remains in saas_db - manual cleanup required!");
            }
            throw new RuntimeException("Failed to save call data to tenant database (" + tenantSchema + "): " + e.getMessage(), e);
        }
    }

    public InboundCallData saveInTenantSchema(InboundCallData callData, String tenantSchema) {
        if (tenantSchema == null || tenantSchema.isBlank()) {
            throw new IllegalArgumentException("tenantSchema cannot be null or blank");
        }
        log.info("\ud83c\udd95 Creating MANUAL Hibernate Session for tenant schema: {}", (Object)tenantSchema);
        Session session = ((SessionFactory)this.entityManagerFactory.unwrap(SessionFactory.class)).withOptions().tenantIdentifier(tenantSchema).openSession();
        try {
            session.beginTransaction();
            log.debug("\u2705 New Hibernate Session created with explicit tenantIdentifier: {}", (Object)tenantSchema);
            session.persist((Object)callData);
            session.flush();
            session.getTransaction().commit();
            log.info("\ud83d\udcbe Call data saved to TENANT schema '{}' - CallSid: {}, From: {}, To: {}", new Object[]{tenantSchema, callData.getCallSid(), callData.getFromNumber(), callData.getToNumber()});
            InboundCallData inboundCallData = callData;
            return inboundCallData;
        }
        catch (Exception e) {
            if (session.getTransaction() != null && session.getTransaction().isActive()) {
                session.getTransaction().rollback();
            }
            log.error("Error saving call data to tenant schema '{}' for CallSid: {}", new Object[]{tenantSchema, callData.getCallSid(), e});
            throw new RuntimeException("Failed to save call data to tenant schema: " + tenantSchema, e);
        }
        finally {
            session.close();
            log.debug("\ud83d\udd12 Closed manual Hibernate Session for schema: {}", (Object)tenantSchema);
        }
    }

    @Transactional
    public InboundCallRequest savePatientRequest(InboundCallRequest request) {
        try {
            InboundCallRequest saved = (InboundCallRequest)this.callRequestRepository.save((Object)request);
            log.info("\ud83d\udccb Patient request saved - CallSid: {}, Nom: {}, T\u00e9l\u00e9phone: {}", new Object[]{saved.getCallSid(), saved.getNom(), saved.getTelephone()});
            return saved;
        }
        catch (Exception e) {
            log.error("Error saving patient request for CallSid: {}", (Object)request.getCallSid(), (Object)e);
            throw e;
        }
    }

    @Transactional
    public void updateCallStatus(String callSid, String status, LocalDateTime endTime, Integer duration) {
        try {
            Optional callDataOpt = this.callDataRepository.findByCallSid(callSid);
            if (callDataOpt.isPresent()) {
                InboundCallData callData = (InboundCallData)callDataOpt.get();
                callData.setCallStatus(status);
                if (endTime != null) {
                    callData.setEndTime(endTime);
                }
                if (duration != null) {
                    callData.setDuration(duration);
                }
                this.callDataRepository.save((Object)callData);
                log.info("\u2705 Call status updated - CallSid: {}, Status: {}", (Object)callSid, (Object)status);
            }
        }
        catch (Exception e) {
            log.error("Error updating call status for CallSid: {}", (Object)callSid, (Object)e);
        }
    }

    @Transactional(readOnly=true)
    public Optional<InboundCallData> getCallByCallSid(String callSid) {
        return this.callDataRepository.findByCallSid(callSid);
    }

    @Transactional(readOnly=true)
    public Optional<InboundCallRequest> getPatientRequestByCallSid(String callSid) {
        return this.callRequestRepository.findByCallSid(callSid);
    }

    @Transactional(readOnly=true)
    public boolean callExists(String callSid) {
        return this.callDataRepository.existsByCallSid(callSid);
    }

    @Transactional
    public boolean updateSmsStatus(String smsSid, String smsStatus) {
        try {
            Optional requestOpt = this.callRequestRepository.findBySmsSid(smsSid);
            if (requestOpt.isPresent()) {
                InboundCallRequest request = (InboundCallRequest)requestOpt.get();
                request.setSmsStatus(smsStatus);
                this.callRequestRepository.save((Object)request);
                log.info("\u2705 SMS status updated - SID: {}, Status: {}", (Object)smsSid, (Object)smsStatus);
                return true;
            }
            log.warn("\u26a0\ufe0f No InboundCallRequest found with SMS SID: {}", (Object)smsSid);
            return false;
        }
        catch (Exception e) {
            log.error("\u274c Error updating SMS status for SID: {}", (Object)smsSid, (Object)e);
            return false;
        }
    }

    @Transactional
    public boolean updateTranscript(String callSessionId, List<Map<String, Object>> transcript) {
        try {
            Optional requestOpt = this.callRequestRepository.findByCallSid(callSessionId);
            if (requestOpt.isPresent()) {
                InboundCallRequest request = (InboundCallRequest)requestOpt.get();
                ObjectMapper mapper = new ObjectMapper();
                String transcriptJson = mapper.writeValueAsString(transcript);
                request.setConversationTranscript(transcriptJson);
                this.callRequestRepository.save((Object)request);
                log.info("\u2705 Transcript updated for CallSid: {}", (Object)callSessionId);
                return true;
            }
            log.warn("\u26a0\ufe0f No InboundCallRequest found with CallSid: {}", (Object)callSessionId);
            return false;
        }
        catch (Exception e) {
            log.error("\u274c Error updating transcript for CallSid: {}", (Object)callSessionId, (Object)e);
            return false;
        }
    }

    @Transactional(readOnly=true)
    public Page<InboundCallData> getAllInboundCallsPaginated(Pageable pageable) {
        return this.callDataRepository.findAll(pageable);
    }

    @Transactional(readOnly=true)
    public Optional<InboundCallData> getInboundCallByCallSid(String callSid) {
        return this.callDataRepository.findByCallSid(callSid);
    }

    @Transactional(readOnly=true)
    public List<InboundCallRequest> getCallRecordsByProvider(String provider) {
        return this.callRequestRepository.findAll().stream().filter(req -> provider.equalsIgnoreCase(req.getProvider())).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<InboundCallRequest> getCallRecordsByDateRange(LocalDateTime startDate, LocalDateTime endDate) {
        return this.callRequestRepository.findAll().stream().filter(req -> req.getCreatedAt() != null).filter(req -> !req.getCreatedAt().isBefore(startDate) && !req.getCreatedAt().isAfter(endDate)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public List<InboundCallRequest> getAllCallRecords() {
        String currentTenant = TenantContext.getTenantId();
        log.debug("\ud83d\udd0d Fetching all call records for tenant schema: {}", (Object)currentTenant);
        return this.callRequestRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<InboundCallRequest> getCallRecordByCallSid(String callSid) {
        return this.callRequestRepository.findByCallSid(callSid);
    }

    @Transactional(readOnly=true)
    public List<InboundCallRequest> getCallRecordsByPatientPhone(String phoneNumber) {
        return this.callRequestRepository.findByTelephone(phoneNumber);
    }

    @Transactional(readOnly=true)
    public List<InboundCallRequest> getRecentCallRecords(int limit) {
        return this.callRequestRepository.findAll().stream().sorted((r1, r2) -> r2.getCreatedAt().compareTo(r1.getCreatedAt())).limit(limit).collect(Collectors.toList());
    }

    @Generated
    public InboundCallService(InboundCallDataRepository callDataRepository, InboundCallRequestRepository callRequestRepository, AdminInboundCallDataRepository adminCallDataRepository, EntityManagerFactory entityManagerFactory) {
        this.callDataRepository = callDataRepository;
        this.callRequestRepository = callRequestRepository;
        this.adminCallDataRepository = adminCallDataRepository;
        this.entityManagerFactory = entityManagerFactory;
    }
}

