/*
 * Decompiled with CFR 0.152.
 */
package com.saas.tenant.service;

import com.saas.shared.dto.common.PageResponse;
import com.saas.shared.dto.mapper.UserMapper;
import com.saas.shared.exception.BusinessException;
import com.saas.shared.exception.ErrorCode;
import com.saas.shared.exception.ResourceNotFoundException;
import com.saas.tenant.dto.request.CreateTenantUserRequest;
import com.saas.tenant.dto.request.UpdateTenantUserRequest;
import com.saas.tenant.dto.response.TenantUserResponse;
import com.saas.tenant.entity.TenantUser;
import com.saas.tenant.repository.TenantUserRepository;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantUserService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantUserService.class);
    private final TenantUserRepository userRepository;
    private final UserMapper userMapper;
    private final PasswordEncoder passwordEncoder;

    @Transactional
    public TenantUserResponse createUser(CreateTenantUserRequest request) {
        log.info("Creating tenant user with email: {}", (Object)request.getEmail());
        if (this.userRepository.existsByEmail(request.getEmail())) {
            throw new BusinessException(ErrorCode.USER_ALREADY_EXISTS, "User with email " + request.getEmail() + " already exists in this tenant");
        }
        TenantUser user = this.userMapper.toTenantUserEntity(request);
        user.setPassword(this.passwordEncoder.encode((CharSequence)request.getPassword()));
        user.setStatus("ACTIVE");
        TenantUser savedUser = (TenantUser)this.userRepository.save((Object)user);
        log.info("Tenant user created successfully with ID: {}", (Object)savedUser.getId());
        return this.userMapper.toTenantUserResponse(savedUser);
    }

    @Transactional(readOnly=true)
    public TenantUserResponse getUserById(Long id) {
        log.debug("Fetching tenant user with ID: {}", (Object)id);
        return this.userRepository.findById((Object)id).map(arg_0 -> ((UserMapper)this.userMapper).toTenantUserResponse(arg_0)).orElseThrow(() -> new ResourceNotFoundException("User", (Object)id));
    }

    @Transactional(readOnly=true)
    public List<TenantUserResponse> getAllUsers() {
        log.debug("Fetching all tenant users");
        return this.userMapper.toTenantUserResponseList(this.userRepository.findAll());
    }

    @Transactional(readOnly=true)
    public PageResponse<TenantUserResponse> getUsers(int page, int size) {
        log.debug("Fetching tenant users - page: {}, size: {}", (Object)page, (Object)size);
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        Page userPage = this.userRepository.findAll((Pageable)pageable);
        return PageResponse.builder().content(this.userMapper.toTenantUserResponseList(userPage.getContent())).page(page).size(size).totalElements(userPage.getTotalElements()).totalPages(userPage.getTotalPages()).hasNext(userPage.hasNext()).hasPrevious(userPage.hasPrevious()).build();
    }

    @Transactional
    public TenantUserResponse updateUser(Long id, UpdateTenantUserRequest request) {
        log.info("Updating tenant user with ID: {}", (Object)id);
        TenantUser user = (TenantUser)this.userRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("User", (Object)id));
        this.userMapper.updateTenantUserEntity(request, user);
        TenantUser updatedUser = (TenantUser)this.userRepository.save((Object)user);
        log.info("Tenant user updated successfully with ID: {}", (Object)updatedUser.getId());
        return this.userMapper.toTenantUserResponse(updatedUser);
    }

    @Transactional
    public void deleteUser(Long id) {
        log.info("Deleting tenant user with ID: {}", (Object)id);
        if (!this.userRepository.existsById((Object)id)) {
            throw new ResourceNotFoundException("User", (Object)id);
        }
        this.userRepository.deleteById((Object)id);
        log.info("Tenant user deleted successfully with ID: {}", (Object)id);
    }

    @Generated
    public TenantUserService(TenantUserRepository userRepository, UserMapper userMapper, PasswordEncoder passwordEncoder) {
        this.userRepository = userRepository;
        this.userMapper = userMapper;
        this.passwordEncoder = passwordEncoder;
    }
}

