/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.shared.enums.Provider;
import com.saas.tenant.service.InboundCallService;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voip/telnyx/sms"})
public class TelnyxSmsCallbackController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelnyxSmsCallbackController.class);
    private final InboundCallService inboundCallService;
    private final PhoneNumberRepository phoneNumberRepository;
    private final TenantRepository tenantRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/status-callback"})
    public ResponseEntity<String> handleSmsStatusCallback(@RequestBody Map<String, Object> payload) {
        try {
            log.info("=== TELNYX SMS STATUS CALLBACK ===");
            Map data = (Map)payload.get("data");
            Map webhookPayload = (Map)data.get("payload");
            String messageId = (String)webhookPayload.get("id");
            String status = (String)webhookPayload.get("delivery_status");
            String to = (String)webhookPayload.get("to");
            String from = (String)webhookPayload.get("from");
            log.info("\ud83d\udce8 SMS Status Update - ID: {}, Status: {}, To: {}, From: {}", new Object[]{messageId, status, to, from});
            TenantContext.setTenantId((String)"admin");
            Optional phoneNumberOpt = this.phoneNumberRepository.findByPhoneNumber(from);
            if (phoneNumberOpt.isEmpty() || ((PhoneNumber)phoneNumberOpt.get()).getProvider() != Provider.TELNYX) {
                log.warn("\u26a0\ufe0f Num\u00e9ro Telnyx inconnu: {} - Impossible d'identifier le tenant", (Object)from);
                ResponseEntity responseEntity = ResponseEntity.ok((Object)"OK");
                return responseEntity;
            }
            PhoneNumber phoneNumber = (PhoneNumber)phoneNumberOpt.get();
            String tenantId = phoneNumber.getTenantId();
            Optional tenantOpt = this.tenantRepository.findByTenantId(tenantId);
            if (tenantOpt.isEmpty()) {
                log.warn("\u26a0\ufe0f Tenant inconnu: {}", (Object)tenantId);
                ResponseEntity responseEntity = ResponseEntity.ok((Object)"OK");
                return responseEntity;
            }
            String schemaName = ((Tenant)tenantOpt.get()).getSchemaName();
            log.info("\ud83d\udd04 Switching to tenant schema: {}", (Object)schemaName);
            TenantContext.setTenantId((String)schemaName);
            this.inboundCallService.updateSmsStatus(messageId, status);
            log.info("\u2705 SMS status updated successfully in tenant schema: {}", (Object)schemaName);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)"OK");
            return responseEntity;
        }
        catch (Exception e) {
            log.error("\u274c Error processing Telnyx SMS callback", (Throwable)e);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)"OK");
            return responseEntity;
        }
        finally {
            TenantContext.clear();
        }
    }

    @GetMapping(value={"/health"})
    public String health() {
        return "Telnyx SMS Callback Service is running!";
    }

    @Generated
    public TelnyxSmsCallbackController(InboundCallService inboundCallService, PhoneNumberRepository phoneNumberRepository, TenantRepository tenantRepository) {
        this.inboundCallService = inboundCallService;
        this.phoneNumberRepository = phoneNumberRepository;
        this.tenantRepository = tenantRepository;
    }
}

