/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.shared.dto.VoipConfigDTO;
import com.saas.shared.enums.Provider;
import com.saas.shared.service.TenantVoipConfigRuntimeService;
import com.saas.tenant.entity.InboundCallData;
import com.saas.tenant.entity.InboundCallRequest;
import com.saas.tenant.service.InboundCallService;
import com.saas.voip.service.TelnyxVoiceAIService;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"/api/voip/telnyx"})
public class TelnyxTeXMLController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelnyxTeXMLController.class);
    private final PhoneNumberRepository phoneNumberRepository;
    private final TenantRepository tenantRepository;
    private final InboundCallService inboundCallService;
    private final TenantVoipConfigRuntimeService voipRuntimeService;
    private final TelnyxVoiceAIService telnyxVoiceAIService;
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate = new RestTemplate();
    @Value(value="${telnyx.api.key:#{null}}")
    private String telnyxApiKey;

    @PostMapping(value={"/texml-response"}, produces={"application/xml"})
    public String handleTeXMLRequest(HttpServletRequest request, @RequestParam(value="From", required=false) String from, @RequestParam(value="To", required=false) String to, @RequestParam(value="CallSid", required=false) String callSid, @RequestParam(value="CallStatus", required=false) String callStatus) {
        log.info("=== TELNYX TeXML REQUEST ===");
        log.info("\ud83d\udcde From: {}, To: {}, CallSid: {}, Status: {}", new Object[]{from, to, callSid, callStatus});
        String tenantId = (String)request.getAttribute("RESOLVED_TENANT_ID");
        String tenantSchema = (String)request.getAttribute("RESOLVED_TENANT_SCHEMA");
        if (tenantId != null && tenantSchema != null) {
            log.info("\u2705 Using tenant from filter: {} (schema: {})", (Object)tenantId, (Object)tenantSchema);
        } else {
            log.warn("\u26a0\ufe0f No tenant info in request attributes - filter may not have resolved tenant");
        }
        boolean callDataSaved = false;
        if (callSid != null && from != null && to != null && tenantId != null && tenantSchema != null) {
            try {
                InboundCallData callData = InboundCallData.builder().callSid(callSid).fromNumber(from).toNumber(to).callStatus(callStatus != null ? callStatus : "initiated").direction("inbound").provider(Provider.TELNYX.name()).startTime(LocalDateTime.now()).build();
                this.inboundCallService.saveInBothDatabases(callData, tenantId, tenantSchema);
                callDataSaved = true;
                log.info("\u2705 SUCCESS: Telnyx call data saved to BOTH admin and tenant databases");
                log.info("   \u251c\u2500 Admin DB (saas_db): \u2705");
                log.info("   \u251c\u2500 Tenant DB ({}): \u2705", (Object)tenantSchema);
                log.info("   \u2514\u2500 CallSid: {}", (Object)callSid);
            }
            catch (Exception e) {
                log.error("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
                log.error("\u2551     CRITICAL ERROR: FAILED TO SAVE CALL DATA         \u2551");
                log.error("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
                log.error("\u274c Error saving Telnyx call data to databases");
                log.error("   \u251c\u2500 TenantId: {}", (Object)tenantId);
                log.error("   \u251c\u2500 Schema: {}", (Object)tenantSchema);
                log.error("   \u251c\u2500 CallSid: {}", (Object)callSid);
                log.error("   \u2514\u2500 Error: {}", (Object)e.getMessage(), (Object)e);
                return this.generateErrorTeXML("Database error - please try again");
            }
        }
        if (!callDataSaved && callSid != null) {
            log.error("\u274c Call data was NOT saved - returning error TeXML");
            return this.generateErrorTeXML("Failed to save call data");
        }
        Optional voipConfig = Optional.empty();
        if (tenantId != null) {
            voipConfig = this.voipRuntimeService.resolveVoipConfig(tenantId, Provider.TELNYX);
            log.info("\ud83d\udccb VoIP Config loaded for tenant: {} - Type: {}, AssistantID: {}", new Object[]{tenantId, voipConfig.map(VoipConfigDTO::getAiType).orElse("N/A"), voipConfig.map(VoipConfigDTO::getAiAssistantId).orElse("N/A")});
        }
        return this.generateTeXMLResponse(voipConfig, tenantId, callSid);
    }

    private String generateTeXMLResponse(Optional<VoipConfigDTO> configOpt, String tenantId, String callSid) {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<Response>\n");
        if (configOpt.isEmpty()) {
            log.warn("\u26a0\ufe0f No VoIP configuration found for tenant: {}", (Object)tenantId);
            xml.append("  <Say language=\"fr-FR\">Configuration VoIP non trouv\u00e9e.</Say>\n");
            xml.append("  <Hangup/>\n");
            xml.append("</Response>");
            return xml.toString();
        }
        VoipConfigDTO config = configOpt.get();
        if (!config.isValid()) {
            log.warn("\u26a0\ufe0f Invalid VoIP configuration for tenant: {}", (Object)tenantId);
            xml.append("  <Say language=\"fr-FR\">Configuration VoIP invalide.</Say>\n");
            xml.append("  <Hangup/>\n");
            xml.append("</Response>");
            return xml.toString();
        }
        String aiType = config.getAiType();
        String aiAssistantId = config.getAiAssistantId();
        String streamUrl = config.getStreamUrl();
        log.info("\ud83d\udd27 VoIP Config - Type: {}, AssistantID: {}, StreamURL: {}, Source: {}", new Object[]{aiType, aiAssistantId, streamUrl, config.isFromDatabase() ? "DATABASE" : "ENVIRONMENT"});
        if ("TELNYX_NATIVE_AI".equals(aiType)) {
            if (aiAssistantId != null && !aiAssistantId.isEmpty()) {
                log.info("\ud83e\udd16 Starting Telnyx Native AI Assistant with Connect: {}", (Object)aiAssistantId);
                Object baseUrl = System.getenv("REPLIT_DOMAINS");
                if (baseUrl == null || ((String)baseUrl).isEmpty()) {
                    baseUrl = System.getenv("BASE_URL");
                }
                if (baseUrl == null || ((String)baseUrl).isEmpty()) {
                    baseUrl = "https://benedictory-provocative-lauralee.ngrok-free.dev";
                }
                if (((String)baseUrl).contains(",")) {
                    baseUrl = ((String)baseUrl).split(",")[0].trim();
                }
                if (!((String)baseUrl).startsWith("http")) {
                    baseUrl = "https://" + (String)baseUrl;
                }
                String statusCallbackUrl = (String)baseUrl + "/api/voip/telnyx/status-callback";
                xml.append("  <!-- Telnyx AI Assistant - Full Conversation Mode -->\n");
                xml.append("  <Connect statusCallback=\"").append(statusCallbackUrl).append("\" ");
                xml.append("statusCallbackEvent=\"initiated ringing answered completed\">\n");
                xml.append("    <AIAssistant id=\"").append(aiAssistantId).append("\"/>\n");
                xml.append("  </Connect>\n");
                log.info("\ud83d\udcde StatusCallback configured: {}", (Object)statusCallbackUrl);
            } else {
                log.warn("\u26a0\ufe0f AI Assistant ID not configured");
                xml.append("  <Say language=\"fr-FR\">Identifiant de l'assistant vocal non configur\u00e9.</Say>\n");
                xml.append("  <Hangup/>\n");
            }
        } else if ("WEBSOCKET_STREAM".equals(aiType)) {
            if (streamUrl != null && !streamUrl.isEmpty()) {
                log.info("\ud83c\udf10 Starting WebSocket stream to: {}", (Object)streamUrl);
                xml.append("  <!-- Stream audio to WebSocket for AI processing -->\n");
                xml.append("  <Start>\n");
                xml.append("    <Stream url=\"").append(streamUrl).append("\">\n");
                xml.append("      <Parameter name=\"tenantId\" value=\"").append(tenantId != null ? tenantId : "unknown").append("\"/>\n");
                xml.append("      <Parameter name=\"callSid\" value=\"").append(callSid != null ? callSid : "unknown").append("\"/>\n");
                xml.append("    </Stream>\n");
                xml.append("  </Start>\n");
                xml.append("  <Pause length=\"3600\"/>\n");
            } else {
                log.warn("\u26a0\ufe0f Stream URL not configured");
                xml.append("  <Say language=\"fr-FR\">URL de streaming non configur\u00e9e.</Say>\n");
                xml.append("  <Hangup/>\n");
            }
        } else {
            log.info("\ud83d\udce2 Using default greeting (no specific AI type configured)");
            xml.append("  <Say language=\"fr-FR\">Bonjour, vous \u00eates connect\u00e9 au syst\u00e8me Telnyx.</Say>\n");
            xml.append("  <Pause length=\"1\"/>\n");
            xml.append("  <Say language=\"fr-FR\">Veuillez configurer l'assistant vocal pour ce tenant.</Say>\n");
            xml.append("  <Hangup/>\n");
        }
        xml.append("</Response>");
        String response = xml.toString();
        log.info("\ud83d\udcc4 TeXML Response:\n{}", (Object)response);
        return response;
    }

    private String generateErrorTeXML(String errorMessage) {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        xml.append("<Response>\n");
        xml.append("  <Say language=\"fr-FR\">Une erreur s'est produite. </Say>\n");
        xml.append("  <Say language=\"fr-FR\">").append(errorMessage).append("</Say>\n");
        xml.append("  <Hangup/>\n");
        xml.append("</Response>");
        String response = xml.toString();
        log.error("\ud83d\udcc4 Error TeXML Response:\n{}", (Object)response);
        return response;
    }

    @GetMapping(value={"/texml-test"})
    public String testTeXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<Response>\n  <Say language=\"fr-FR\">Test TeXML - Telnyx est correctement configur\u00e9.</Say>\n</Response>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/status-callback"})
    public ResponseEntity<Map<String, Object>> handleStatusCallback(@RequestParam Map<String, String> params) {
        ResponseEntity responseEntity;
        log.info("=== TELNYX STATUS CALLBACK ===");
        log.info("\ud83d\udcca Received parameters: {}", params);
        String callSid = params.get("CallSid");
        String to = params.get("To");
        String from = params.get("From");
        String callStatus = params.get("CallStatus");
        String duration = params.get("CallDuration");
        String timestamp = params.get("Timestamp");
        log.info("\ud83d\udcde CallSid: {}, Status: {}, Duration: {}s, From: {}, To: {}", new Object[]{callSid, callStatus, duration, from, to});
        if (callSid == null || to == null) {
            log.warn("\u26a0\ufe0f Missing CallSid or To number in status callback");
            return ResponseEntity.ok(Map.of("status", "ignored", "reason", "missing_data"));
        }
        Optional phoneOpt = this.phoneNumberRepository.findByPhoneNumber(to);
        if (phoneOpt.isEmpty() || ((PhoneNumber)phoneOpt.get()).getProvider() != Provider.TELNYX) {
            log.warn("\u26a0\ufe0f No Telnyx phone number found for: {}", (Object)to);
            return ResponseEntity.ok(Map.of("status", "ignored", "reason", "phone_not_found"));
        }
        PhoneNumber phoneNumber = (PhoneNumber)phoneOpt.get();
        String tenantId = phoneNumber.getTenantId();
        Optional tenantOpt = this.tenantRepository.findByTenantId(tenantId);
        if (tenantOpt.isEmpty()) {
            log.error("\u274c Tenant not found for phone: {}", (Object)to);
            return ResponseEntity.ok(Map.of("status", "error", "reason", "tenant_not_found"));
        }
        Tenant tenant = (Tenant)tenantOpt.get();
        String schemaName = tenant.getSchemaName();
        TenantContext.setTenantId((String)schemaName);
        log.info("\ud83d\udcca Set tenant context: {}", (Object)schemaName);
        try {
            Optional existingCall = this.inboundCallService.getCallByCallSid(callSid);
            if (existingCall.isPresent()) {
                InboundCallData callData = (InboundCallData)existingCall.get();
                callData.setCallStatus(callStatus);
                if (duration != null && !duration.isEmpty()) {
                    try {
                        callData.setDuration(Integer.valueOf(Integer.parseInt(duration)));
                    }
                    catch (NumberFormatException e) {
                        log.warn("\u26a0\ufe0f Invalid duration format: {}", (Object)duration);
                    }
                }
                if ("completed".equalsIgnoreCase(callStatus)) {
                    callData.setEndTime(LocalDateTime.now());
                    log.info("\u2705 Call completed - Duration: {}s", (Object)duration);
                    try {
                        log.info("\ud83d\udce5 Retrieving conversation transcript for CallSid: {}", (Object)callSid);
                        Map conversationData = this.telnyxVoiceAIService.getConversationTranscript(callSid);
                        if (conversationData != null && !conversationData.isEmpty()) {
                            Object messagesObj = conversationData.get("messages");
                            if (messagesObj != null) {
                                List messages = (List)this.objectMapper.convertValue(messagesObj, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                                callData.setConversation(messages);
                                log.info("\u2705 Conversation transcript stored ({} messages)", (Object)messages.size());
                                this.extractPatientDataFromConversation(callSid, messages, schemaName);
                            } else {
                                log.warn("\u26a0\ufe0f No messages found in conversation data");
                            }
                        } else {
                            log.warn("\u26a0\ufe0f No conversation data available for CallSid: {}", (Object)callSid);
                        }
                    }
                    catch (Exception convEx) {
                        log.error("\u274c Failed to retrieve conversation for CallSid: {}", (Object)callSid, (Object)convEx);
                    }
                }
                this.inboundCallService.saveInBothDatabases(callData, tenantId, schemaName);
                log.info("\u2705 Updated call record with status: {}", (Object)callStatus);
            } else {
                log.warn("\u26a0\ufe0f No existing call record found for CallSid: {}", (Object)callSid);
                InboundCallData newCall = InboundCallData.builder().callSid(callSid).fromNumber(from).toNumber(to).callStatus(callStatus).direction("inbound").startTime(LocalDateTime.now()).build();
                if (duration != null && !duration.isEmpty()) {
                    try {
                        newCall.setDuration(Integer.valueOf(Integer.parseInt(duration)));
                    }
                    catch (NumberFormatException e) {
                        log.warn("\u26a0\ufe0f Invalid duration: {}", (Object)duration);
                    }
                }
                this.inboundCallService.saveCallData(newCall);
                log.info("\u2705 Created new call record from status callback");
            }
            responseEntity = ResponseEntity.ok(Map.of("status", "success", "message", "Status callback processed", "callStatus", callStatus != null ? callStatus : "unknown"));
        }
        catch (Throwable throwable) {
            try {
                TenantContext.clear();
                throw throwable;
            }
            catch (Exception e) {
                log.error("\u274c Error processing status callback", (Throwable)e);
                TenantContext.clear();
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("status", "error", "message", e.getMessage()));
            }
        }
        TenantContext.clear();
        return responseEntity;
    }

    private void startTelnyxAIAssistant(String callControlId, String assistantId) {
        if (this.telnyxApiKey == null || this.telnyxApiKey.isEmpty()) {
            log.error("\u274c TELNYX_API_KEY not configured! Cannot start AI assistant");
            log.error("\ud83d\udca1 Add TELNYX_API_KEY to your .env file or application.properties");
            log.error("\ud83d\udca1 Example: TELNYX_API_KEY=KEY0123456789ABCDEF...");
            return;
        }
        log.info("\u2705 Using Telnyx API Key: {}...", (Object)this.telnyxApiKey.substring(0, Math.min(10, this.telnyxApiKey.length())));
        if (callControlId == null || callControlId.isEmpty()) {
            log.error("\u274c Call Control ID is null! Cannot start AI assistant");
            return;
        }
        try {
            String url = "https://api.telnyx.com/v2/calls/" + callControlId + "/actions/ai_assistant_start";
            HttpHeaders headers = new HttpHeaders();
            headers.set("Authorization", "Bearer " + this.telnyxApiKey);
            headers.setContentType(MediaType.APPLICATION_JSON);
            HashMap payload = new HashMap();
            HashMap<String, String> assistant = new HashMap<String, String>();
            assistant.put("id", assistantId);
            payload.put("assistant", assistant);
            HttpEntity request = new HttpEntity(payload, (MultiValueMap)headers);
            log.info("\ud83d\udd04 Calling Telnyx API to start AI assistant {} for call {}", (Object)assistantId, (Object)callControlId);
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, request, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                log.info("\u2705 AI Assistant started successfully! Response: {}", response.getBody());
            } else {
                log.error("\u274c Failed to start AI assistant. Status: {}, Body: {}", (Object)response.getStatusCode(), response.getBody());
            }
        }
        catch (Exception e) {
            log.error("\u274c Error calling Telnyx API to start AI assistant", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractPatientDataFromConversation(String callSid, List<Object> messages, String schemaName) {
        block19: {
            if (messages == null || messages.isEmpty()) {
                log.warn("\u26a0\ufe0f No conversation messages to extract patient data from");
                return;
            }
            try {
                log.info("\ud83d\udd0d Extracting patient data from {} conversation messages", (Object)messages.size());
                String patientName = null;
                String patientPhone = null;
                String illness = null;
                String doctorName = null;
                LocalDateTime appointmentDateTime = null;
                for (Object msgObj : messages) {
                    String argsJson;
                    Map functionCall;
                    if (!(msgObj instanceof Map)) continue;
                    Map message = (Map)msgObj;
                    String role = (String)message.get("role");
                    String content = (String)message.get("content");
                    if (content != null && !content.isEmpty()) {
                        Pattern pattern;
                        Matcher matcher;
                        String[] parts;
                        if (patientName == null && content.toLowerCase().contains("nom") && (parts = content.split(":")).length > 1) {
                            patientName = parts[1].trim();
                        }
                        if (patientPhone == null && content.contains("+") && content.matches(".*\\+\\d{10,15}.*") && (matcher = (pattern = Pattern.compile("\\+\\d{10,15}")).matcher(content)).find()) {
                            patientPhone = matcher.group();
                        }
                    }
                    if (!message.containsKey("function_call") || (functionCall = (Map)message.get("function_call")) == null || !functionCall.containsKey("arguments") || (argsJson = (String)functionCall.get("arguments")) == null) continue;
                    try {
                        Map args = (Map)this.objectMapper.readValue(argsJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                        if (args.containsKey("patient_name")) {
                            patientName = (String)args.get("patient_name");
                        }
                        if (args.containsKey("patient_phone")) {
                            patientPhone = (String)args.get("patient_phone");
                        }
                        if (args.containsKey("illness") || args.containsKey("maladie")) {
                            illness = (String)args.getOrDefault("illness", args.get("maladie"));
                        }
                        if (args.containsKey("doctor_name")) {
                            doctorName = (String)args.get("doctor_name");
                        }
                        if (!args.containsKey("appointment_datetime")) continue;
                        try {
                            appointmentDateTime = LocalDateTime.parse((String)args.get("appointment_datetime"));
                        }
                        catch (Exception dtEx) {
                            log.warn("Failed to parse appointment datetime", (Throwable)dtEx);
                        }
                    }
                    catch (Exception jsonEx) {
                        log.warn("Failed to parse function arguments JSON", (Throwable)jsonEx);
                    }
                }
                if (patientName != null || patientPhone != null || illness != null) {
                    log.info("\ud83d\udcdd Patient data extracted - Name: {}, Phone: {}, Illness: {}", new Object[]{patientName, patientPhone, illness});
                    TenantContext.setTenantId((String)schemaName);
                    try {
                        InboundCallRequest request = new InboundCallRequest();
                        request.setCallSid(callSid);
                        request.setNom(patientName);
                        request.setTelephone(patientPhone);
                        request.setMaladie(illness);
                        request.setDoctorName(doctorName);
                        request.setAppointmentDateTime(appointmentDateTime);
                        request.setProvider("TELNYX");
                        String conversationJson = this.objectMapper.writeValueAsString(messages);
                        request.setConversationTranscript(conversationJson);
                        this.inboundCallService.savePatientRequest(request);
                        log.info("\u2705 Patient data saved to InboundCallRequest (tenant DB only)");
                        break block19;
                    }
                    finally {
                        TenantContext.clear();
                    }
                }
                log.info("\u23ed\ufe0f No patient data found in conversation");
            }
            catch (Exception e) {
                log.error("\u274c Error extracting patient data from conversation", (Throwable)e);
            }
        }
    }

    @Generated
    public TelnyxTeXMLController(PhoneNumberRepository phoneNumberRepository, TenantRepository tenantRepository, InboundCallService inboundCallService, TenantVoipConfigRuntimeService voipRuntimeService, TelnyxVoiceAIService telnyxVoiceAIService, ObjectMapper objectMapper) {
        this.phoneNumberRepository = phoneNumberRepository;
        this.tenantRepository = tenantRepository;
        this.inboundCallService = inboundCallService;
        this.voipRuntimeService = voipRuntimeService;
        this.telnyxVoiceAIService = telnyxVoiceAIService;
        this.objectMapper = objectMapper;
    }
}

