/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.tenant.service.InboundCallService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voip/sms"})
public class TwilioSmsCallbackController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwilioSmsCallbackController.class);
    private final InboundCallService inboundCallService;
    private final PhoneNumberRepository phoneNumberRepository;
    private final TenantRepository tenantRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/status-callback"}, produces={"application/xml"})
    public String handleSmsStatusCallback(HttpServletRequest request) {
        MultiValueMap formData = this.extractFormData(request);
        String messageSid = (String)formData.getFirst((Object)"MessageSid");
        String messageStatus = (String)formData.getFirst((Object)"MessageStatus");
        String to = (String)formData.getFirst((Object)"To");
        String from = (String)formData.getFirst((Object)"From");
        log.info("\ud83d\udcec Callback SMS re\u00e7u - SID: {} | Statut: {} | From (Twilio): {} | To (Patient): {}", new Object[]{messageSid, messageStatus, from, to});
        formData.forEach((key, values) -> log.debug("SMS Callback param - {}: {}", key, values.get(0)));
        String errorCode = (String)formData.getFirst((Object)"ErrorCode");
        String errorMessage = (String)formData.getFirst((Object)"ErrorMessage");
        if (errorCode != null) {
            log.error("\u274c SMS Error - Code: {}, Message: {}", (Object)errorCode, (Object)errorMessage);
        }
        try {
            TenantContext.setTenantId((String)"admin");
            Optional phoneNumberOpt = this.phoneNumberRepository.findByPhoneNumber(from);
            if (phoneNumberOpt.isEmpty()) {
                log.warn("\u26a0\ufe0f Num\u00e9ro inconnu: {} - Impossible d'identifier le tenant", (Object)from);
                String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Response></Response>";
                return string;
            }
            PhoneNumber phoneNumber = (PhoneNumber)phoneNumberOpt.get();
            String tenantId = phoneNumber.getTenantId();
            Optional tenantOpt = this.tenantRepository.findByTenantId(tenantId);
            if (tenantOpt.isEmpty()) {
                log.warn("\u26a0\ufe0f Tenant non trouv\u00e9 pour ID: {}", (Object)tenantId);
                String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Response></Response>";
                return string;
            }
            String schemaName = ((Tenant)tenantOpt.get()).getSchemaName();
            log.info("\ud83c\udfe2 Tenant identifi\u00e9 via num\u00e9ro Twilio {} \u2192 Tenant ID: {} | Schema: {}", new Object[]{from, tenantId, schemaName});
            TenantContext.setTenantId((String)schemaName);
            boolean updated = this.inboundCallService.updateSmsStatus(messageSid, messageStatus);
            if (updated) {
                log.info("\u2705 Statut SMS mis \u00e0 jour dans {} : {} \u2192 {}", new Object[]{schemaName, messageSid, messageStatus});
            } else {
                log.warn("\u26a0\ufe0f SMS non trouv\u00e9 dans {} pour SID: {}", (Object)schemaName, (Object)messageSid);
            }
        }
        catch (Exception e) {
            log.error("\u274c Erreur lors de la mise \u00e0 jour du statut SMS: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            TenantContext.clear();
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Response></Response>";
    }

    @GetMapping(value={"/status-callback"}, produces={"application/xml"})
    public String handleSmsStatusCallbackGet(HttpServletRequest request) {
        return this.handleSmsStatusCallback(request);
    }

    private MultiValueMap<String, String> extractFormData(HttpServletRequest request) {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String[] paramValues;
            String paramName = (String)parameterNames.nextElement();
            for (String paramValue : paramValues = request.getParameterValues(paramName)) {
                formData.add((Object)paramName, (Object)paramValue);
            }
        }
        return formData;
    }

    @Generated
    public TwilioSmsCallbackController(InboundCallService inboundCallService, PhoneNumberRepository phoneNumberRepository, TenantRepository tenantRepository) {
        this.inboundCallService = inboundCallService;
        this.phoneNumberRepository = phoneNumberRepository;
        this.tenantRepository = tenantRepository;
    }
}

