/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.extractor;

import com.saas.tenant.entity.InboundCallData;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TelnyxCallDataExtractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelnyxCallDataExtractor.class);
    private static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_DATE_TIME;

    public InboundCallData extractFromTelnyxRequest(Map<String, Object> payload) {
        try {
            Map eventData = (Map)payload.get("data");
            Map callPayload = (Map)eventData.get("payload");
            InboundCallData callData = new InboundCallData();
            callData.setCallSid(this.getString(callPayload, "call_session_id"));
            callData.setProvider("TELNYX");
            callData.setFromNumber(this.getString(callPayload, "from"));
            callData.setToNumber(this.getString(callPayload, "to"));
            callData.setCallStatus(this.getString(callPayload, "state", "initiated"));
            callData.setDirection(this.getString(callPayload, "direction", "inbound"));
            callData.setCallToken(this.getString(callPayload, "call_control_id"));
            callData.setFromCity(this.getString(callPayload, "from_number_object.city"));
            callData.setFromState(this.getString(callPayload, "from_number_object.state"));
            callData.setFromCountry(this.getString(callPayload, "from_number_object.country"));
            callData.setToCity(this.getString(callPayload, "to_number_object.city"));
            callData.setToState(this.getString(callPayload, "to_number_object.state"));
            callData.setToCountry(this.getString(callPayload, "to_number_object.country"));
            String startTimeStr = this.getString(callPayload, "start_time");
            if (startTimeStr != null && !startTimeStr.isEmpty()) {
                try {
                    callData.setStartTime(LocalDateTime.parse(startTimeStr, ISO_FORMATTER));
                }
                catch (Exception e) {
                    log.warn("Failed to parse start_time: {}", (Object)startTimeStr);
                }
            }
            log.debug("\ud83d\udccb Extracted Telnyx call data - CallSid: {}, From: {}, To: {}", new Object[]{callData.getCallSid(), callData.getFromNumber(), callData.getToNumber()});
            return callData;
        }
        catch (Exception e) {
            log.error("Error extracting Telnyx call data", (Throwable)e);
            throw new RuntimeException("Failed to extract Telnyx call data", e);
        }
    }

    private String getString(Map<String, Object> map, String key) {
        return this.getString(map, key, null);
    }

    private String getString(Map<String, Object> map, String key, String defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        if (key.contains(".")) {
            String[] parts = key.split("\\.", 2);
            Object nested = map.get(parts[0]);
            if (nested instanceof Map) {
                return this.getString((Map)nested, parts[1], defaultValue);
            }
            return defaultValue;
        }
        Object value = map.get(key);
        return value != null ? value.toString() : defaultValue;
    }
}

