/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.filter;

import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.shared.enums.Provider;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=-2147483648)
public class TelnyxTenantResolverFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelnyxTenantResolverFilter.class);
    private final PhoneNumberRepository phoneNumberRepository;
    private final TenantRepository tenantRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain filterChain) throws ServletException, IOException {
        String requestUri = request.getRequestURI();
        if (this.isTelnyxWebhook(requestUri)) {
            log.debug("\ud83c\udfaf TelnyxTenantResolverFilter: Intercepting webhook: {}", (Object)requestUri);
            try {
                TenantContext.setTenantId((String)"saas_db");
                String toNumber = this.extractToNumber(request);
                if (toNumber != null) {
                    Optional phoneOpt = this.phoneNumberRepository.findByPhoneNumber(toNumber);
                    if (phoneOpt.isPresent() && ((PhoneNumber)phoneOpt.get()).getProvider() == Provider.TELNYX) {
                        String tenantId = ((PhoneNumber)phoneOpt.get()).getTenantId();
                        Optional tenantOpt = this.tenantRepository.findByTenantId(tenantId);
                        if (tenantOpt.isPresent()) {
                            String schemaName = ((Tenant)tenantOpt.get()).getSchemaName();
                            request.setAttribute("RESOLVED_TENANT_ID", (Object)tenantId);
                            request.setAttribute("RESOLVED_TENANT_SCHEMA", (Object)schemaName);
                            log.info("\u2705 TelnyxTenantResolverFilter: Resolved tenant '{}' (schema: {}) for number: {} - Context remains 'saas_db'", new Object[]{tenantId, schemaName, toNumber});
                        } else {
                            log.warn("\u26a0\ufe0f TelnyxTenantResolverFilter: Tenant not found for ID: {}", (Object)tenantId);
                        }
                    } else {
                        log.warn("\u26a0\ufe0f TelnyxTenantResolverFilter: No Telnyx phone number found: {}", (Object)toNumber);
                    }
                } else {
                    log.warn("\u26a0\ufe0f TelnyxTenantResolverFilter: Could not extract 'To' number from request");
                }
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            finally {
                TenantContext.clear();
                log.debug("\ud83e\uddf9 TelnyxTenantResolverFilter: Cleared TenantContext");
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean isTelnyxWebhook(String uri) {
        return uri != null && uri.contains("/api/voip/telnyx/");
    }

    private String extractToNumber(HttpServletRequest request) {
        String to = request.getParameter("To");
        if (to == null) {
            to = request.getParameter("to");
        }
        if (to == null) {
            to = request.getParameter("TO");
        }
        return to;
    }

    @Generated
    public TelnyxTenantResolverFilter(PhoneNumberRepository phoneNumberRepository, TenantRepository tenantRepository) {
        this.phoneNumberRepository = phoneNumberRepository;
        this.tenantRepository = tenantRepository;
    }
}

