/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.handler;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.saas.voip.handler.AiSessionHandler;
import com.saas.voip.service.OpenAIRealtimeService;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.WebSocketSession;

@Component
public class OpenAiSessionHandler
implements AiSessionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenAiSessionHandler.class);
    private final OpenAIRealtimeService openAIRealtimeService;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public void onClientConnect(WebSocketSession session, String streamSid, String callSid, String fromNumber, String toNumber) throws Exception {
        log.info("OpenAI handler - Client connected: streamSid={}, callSid={}", (Object)streamSid, (Object)callSid);
        this.openAIRealtimeService.setStreamSid(session.getId(), streamSid);
        this.openAIRealtimeService.setCallSidForSession(session.getId(), callSid);
        this.openAIRealtimeService.connectToOpenAI(session);
    }

    public void onMediaFrame(WebSocketSession session, String payload) throws Exception {
        JsonNode mediaNode = this.objectMapper.readTree(payload);
        if (mediaNode.has("media") && mediaNode.get("media").has("payload")) {
            String audioPayload = mediaNode.get("media").get("payload").asText();
            this.openAIRealtimeService.sendAudioToOpenAI(session, audioPayload);
        }
    }

    public void onMark(WebSocketSession session, Map<String, Object> markData) throws Exception {
        log.debug("Mark event received (no action required for OpenAI)");
    }

    public void onClose(WebSocketSession session) throws Exception {
        log.info("OpenAI handler - Closing session: {}", (Object)session.getId());
        this.openAIRealtimeService.closeConnection(session);
    }

    public boolean supportsStructuredExtraction() {
        return true;
    }

    public Map<String, Object> buildStructuredPayload(String transcript) {
        return new HashMap<String, Object>();
    }

    @Generated
    public OpenAiSessionHandler(OpenAIRealtimeService openAIRealtimeService) {
        this.openAIRealtimeService = openAIRealtimeService;
    }
}

