/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.saas.shared.core.TenantContext;
import com.saas.tenant.entity.CallCostRecord;
import com.saas.tenant.service.CallCostTrackingService;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Locale;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TwilioCostService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwilioCostService.class);
    @Value(value="${twilio.account.sid:}")
    private String twilioAccountSid;
    @Value(value="${twilio.auth.token:}")
    private String twilioAuthToken;
    private final CallCostTrackingService callCostTrackingService;
    private final ObjectMapper objectMapper;
    private final RestTemplate restTemplate = new RestTemplate();

    public void saveCallCostFromWebhook(String callSid, String priceStr, String currency, String durationStr, String timestampStr, String fromNumber, String toNumber) {
        log.info("\ud83d\udce5 [TwilioCostService] saveCallCostFromWebhook() CALLED - CallSid: {}", (Object)callSid);
        log.info("\ud83d\udce5 [TwilioCostService] Webhook data - Price: {} {}, Duration: {}s", new Object[]{priceStr, currency, durationStr});
        String startTimeStr = timestampStr;
        String endTimeStr = timestampStr;
        this.saveCallCost(callSid, priceStr, currency, durationStr, startTimeStr, endTimeStr, fromNumber, toNumber);
    }

    public void fetchAndSaveCallCost(String callSid, String fromNumber, String toNumber) {
        block6: {
            log.info("\ud83d\ude80 [TwilioCostService] fetchAndSaveCallCost() CALLED - CallSid: {}, From: {}, To: {}", new Object[]{callSid, fromNumber, toNumber});
            if (this.twilioAccountSid == null || this.twilioAccountSid.isEmpty()) {
                log.error("\u274c [TwilioCostService] Twilio Account SID not configured - CANNOT fetch call cost!");
                log.error("\u274c [TwilioCostService] Please set twilio.account.sid in application properties");
                return;
            }
            if (this.twilioAuthToken == null || this.twilioAuthToken.isEmpty()) {
                log.error("\u274c [TwilioCostService] Twilio Auth Token not configured - CANNOT fetch call cost!");
                log.error("\u274c [TwilioCostService] Please set twilio.auth.token in application properties");
                return;
            }
            log.info("\u2705 [TwilioCostService] Twilio credentials configured");
            try {
                String url = String.format("https://api.twilio.com/2010-04-01/Accounts/%s/Calls/%s.json", this.twilioAccountSid, callSid);
                String auth = this.twilioAccountSid + ":" + this.twilioAuthToken;
                String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
                HttpHeaders headers = new HttpHeaders();
                headers.set("Authorization", "Basic " + encodedAuth);
                headers.set("Accept", "application/json");
                HttpEntity entity = new HttpEntity((MultiValueMap)headers);
                log.info("\ud83d\udd0d [TwilioCostService] Calling Twilio API: {}", (Object)url);
                ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, String.class, new Object[0]);
                log.info("\ud83d\udce1 [TwilioCostService] Twilio API response status: {}", (Object)response.getStatusCode());
                if (response.getStatusCode().is2xxSuccessful()) {
                    log.info("\ud83d\udcc4 [TwilioCostService] Twilio API response body: {}", response.getBody());
                    JsonNode callData = this.objectMapper.readTree((String)response.getBody());
                    String price = callData.has("price") ? callData.get("price").asText() : null;
                    String priceUnit = callData.has("price_unit") ? callData.get("price_unit").asText() : null;
                    String duration = callData.has("duration") ? callData.get("duration").asText() : null;
                    String startTime = callData.has("start_time") ? callData.get("start_time").asText() : null;
                    String endTime = callData.has("end_time") ? callData.get("end_time").asText() : null;
                    log.info("\ud83d\udcb0 [TwilioCostService] Parsed data - Price: {} {}, Duration: {}s, StartTime: {}, EndTime: {}", new Object[]{price, priceUnit, duration, startTime, endTime});
                    this.saveCallCost(callSid, price, priceUnit, duration, startTime, endTime, fromNumber, toNumber);
                } else {
                    log.error("\u274c [TwilioCostService] Failed to fetch - HTTP Status: {}, Body: {}", (Object)response.getStatusCode(), response.getBody());
                }
            }
            catch (Exception e) {
                log.error("\u274c [TwilioCostService] EXCEPTION while fetching call cost for CallSid: {}", (Object)callSid, (Object)e);
                log.error("\u274c [TwilioCostService] Exception message: {}", (Object)e.getMessage());
                log.error("\u274c [TwilioCostService] Exception class: {}", (Object)e.getClass().getName());
                if (e.getMessage() == null || !e.getMessage().contains("20008")) break block6;
                log.error("\u274c [TwilioCostService] ========================================");
                log.error("\u274c [TwilioCostService] ERROR: Test Account Credentials detected!");
                log.error("\u274c [TwilioCostService] ========================================");
                log.error("\u274c [TwilioCostService] Twilio Test Accounts cannot access call data via API.");
                log.error("\u274c [TwilioCostService] NOTE: The date '2010-04-01' in the URL is the Twilio API VERSION, not a real date.");
                log.error("\u274c [TwilioCostService] SOLUTIONS:");
                log.error("\u274c [TwilioCostService]   1. Upgrade to a paid Twilio account (recommended)");
                log.error("\u274c [TwilioCostService]   2. Use webhook data instead of API calls");
                log.error("\u274c [TwilioCostService] ========================================");
            }
        }
    }

    private void saveCallCost(String callSid, String priceStr, String currency, String durationStr, String startTimeStr, String endTimeStr, String from, String to) {
        log.info("\ud83d\udcbe [TwilioCostService] saveCallCost() CALLED - CallSid: {}", (Object)callSid);
        log.info("\ud83d\udcbe [TwilioCostService] Raw data - Price: {}, Currency: {}, Duration: {}", new Object[]{priceStr, currency, durationStr});
        try {
            DateTimeFormatter formatter;
            CallCostRecord costRecord = new CallCostRecord();
            costRecord.setCallSid(callSid);
            costRecord.setProvider("TWILIO");
            if (priceStr != null && !priceStr.isEmpty() && !priceStr.equals("null")) {
                BigDecimal price = new BigDecimal(priceStr).abs();
                costRecord.setCost(price);
                log.info("\ud83d\udcb0 [TwilioCostService] Parsed cost: {}", (Object)price);
            } else {
                log.warn("\u26a0\ufe0f [TwilioCostService] Price is null or empty!");
            }
            costRecord.setCurrency(currency != null ? currency.toUpperCase() : "USD");
            log.info("\ud83d\udcb1 [TwilioCostService] Currency: {}", (Object)costRecord.getCurrency());
            if (durationStr != null && !durationStr.isEmpty() && !durationStr.equals("null")) {
                costRecord.setCallDurationSeconds(Integer.valueOf(Integer.parseInt(durationStr)));
                log.info("\u23f1\ufe0f [TwilioCostService] Duration: {}s", (Object)costRecord.getCallDurationSeconds());
            }
            if (startTimeStr != null && !startTimeStr.isEmpty() && !startTimeStr.equals("null")) {
                try {
                    formatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
                    ZonedDateTime zonedStart = ZonedDateTime.parse(startTimeStr, formatter);
                    costRecord.setCallStartTime(zonedStart.toLocalDateTime());
                    log.info("\ud83d\udcc5 [TwilioCostService] Parsed start time: {}", (Object)costRecord.getCallStartTime());
                }
                catch (Exception e) {
                    log.error("\u274c [TwilioCostService] Failed to parse start time: {}", (Object)startTimeStr, (Object)e);
                }
            }
            if (endTimeStr != null && !endTimeStr.isEmpty() && !endTimeStr.equals("null")) {
                try {
                    formatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
                    ZonedDateTime zonedEnd = ZonedDateTime.parse(endTimeStr, formatter);
                    costRecord.setCallEndTime(zonedEnd.toLocalDateTime());
                    log.info("\ud83d\udcc5 [TwilioCostService] Parsed end time: {}", (Object)costRecord.getCallEndTime());
                }
                catch (Exception e) {
                    log.error("\u274c [TwilioCostService] Failed to parse end time: {}", (Object)endTimeStr, (Object)e);
                }
            }
            costRecord.setFromNumber(from);
            costRecord.setToNumber(to);
            log.info("\ud83c\udfaf [TwilioCostService] Setting TenantContext to saas_db for ADMIN database save");
            TenantContext.setTenantId((String)"saas_db");
            try {
                log.info("\ud83d\udcbe [TwilioCostService] Calling callCostTrackingService.saveCallCost()...");
                this.callCostTrackingService.saveCallCost(costRecord);
                log.info("\u2705 [TwilioCostService] Twilio call cost saved to ADMIN database (saas_db)!");
                log.info("\u2705 [TwilioCostService] CallSid: {}, Cost: {} {}, Duration: {}s", new Object[]{callSid, costRecord.getCost(), costRecord.getCurrency(), costRecord.getCallDurationSeconds()});
            }
            catch (Exception e) {
                log.error("\u274c [TwilioCostService] EXCEPTION while saving to database!", (Throwable)e);
                log.error("\u274c [TwilioCostService] Exception message: {}", (Object)e.getMessage());
                throw e;
            }
            finally {
                TenantContext.clear();
                log.info("\ud83e\uddf9 [TwilioCostService] TenantContext cleared");
            }
        }
        catch (Exception e) {
            log.error("\u274c [TwilioCostService] EXCEPTION in saveCallCost() for CallSid: {}", (Object)callSid, (Object)e);
            log.error("\u274c [TwilioCostService] Exception type: {}, Message: {}", (Object)e.getClass().getName(), (Object)e.getMessage());
        }
    }

    @Generated
    public TwilioCostService(CallCostTrackingService callCostTrackingService, ObjectMapper objectMapper) {
        this.callCostTrackingService = callCostTrackingService;
        this.objectMapper = objectMapper;
    }
}

