/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.service;

import com.saas.tenant.entity.InboundCallRequest;
import com.saas.tenant.repository.InboundCallRequestRepository;
import com.saas.voip.service.ZiwoApiService;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ZiwoSmsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZiwoSmsService.class);
    private final ZiwoApiService ziwoApiService;
    private final InboundCallRequestRepository inboundCallRequestRepository;
    private static final DateTimeFormatter FRENCH_DATE_FORMATTER = DateTimeFormatter.ofPattern("EEEE d MMMM yyyy '\u00e0' HH'h'mm", Locale.FRENCH);

    public void sendAppointmentConfirmation(Long requestId, String fromNumber, String toNumber, String patientName, String doctorName, LocalDateTime appointmentDateTime) {
        try {
            String message = this.buildConfirmationMessage(patientName, doctorName, appointmentDateTime);
            log.info("Sending Ziwo SMS confirmation to: {} from: {}", (Object)toNumber, (Object)fromNumber);
            Map result = this.ziwoApiService.sendSms(fromNumber, toNumber, message);
            if (result != null) {
                String smsSid = result.get("message_id") != null ? result.get("message_id").toString() : null;
                String smsStatus = result.get("status") != null ? result.get("status").toString() : "sent";
                Optional requestOpt = this.inboundCallRequestRepository.findById((Object)requestId);
                if (requestOpt.isPresent()) {
                    InboundCallRequest request = (InboundCallRequest)requestOpt.get();
                    request.setSmsSent(Boolean.valueOf(true));
                    request.setSmsSid(smsSid);
                    request.setSmsStatus(smsStatus);
                    this.inboundCallRequestRepository.save((Object)request);
                    log.info("Updated InboundCallRequest with Ziwo SMS details: smsSid={}", (Object)smsSid);
                }
            } else {
                log.error("Failed to send Ziwo SMS confirmation");
            }
        }
        catch (Exception e) {
            log.error("Error sending Ziwo SMS confirmation", (Throwable)e);
        }
    }

    public void sendCustomSms(String fromNumber, String toNumber, String message) {
        try {
            log.info("Sending custom Ziwo SMS to: {} from: {}", (Object)toNumber, (Object)fromNumber);
            Map result = this.ziwoApiService.sendSms(fromNumber, toNumber, message);
            if (result != null) {
                log.info("Custom Ziwo SMS sent successfully");
            } else {
                log.error("Failed to send custom Ziwo SMS");
            }
        }
        catch (Exception e) {
            log.error("Error sending custom Ziwo SMS", (Throwable)e);
        }
    }

    private String buildConfirmationMessage(String patientName, String doctorName, LocalDateTime appointmentDateTime) {
        String formattedDateTime = appointmentDateTime != null ? appointmentDateTime.format(FRENCH_DATE_FORMATTER) : "\u00e0 confirmer";
        return String.format("Bonjour %s,\n\nVotre rendez-vous avec %s est confirm\u00e9 pour le %s.\n\n\u00c0 bient\u00f4t !", patientName != null ? patientName : "cher(e) patient(e)", doctorName != null ? doctorName : "le m\u00e9decin", formattedDateTime);
    }

    @Generated
    public ZiwoSmsService(ZiwoApiService ziwoApiService, InboundCallRequestRepository inboundCallRequestRepository) {
        this.ziwoApiService = ziwoApiService;
        this.inboundCallRequestRepository = inboundCallRequestRepository;
    }
}

