# ElevenLabs First Message - Guide Rapide

## 🔴 Problème

**Vous entendez le message d'accueil du code, mais l'agent ElevenLabs ne répond pas ensuite.**

## ✅ Solution

Le code a été modifié pour désactiver le message TwiML `<Say>` quand vous utilisez ElevenLabs. **L'agent du dashboard doit parler à la place !**

---

## 📋 Checklist de Configuration

### 1. Mode Provider Vérifié ✓

```bash
# Dans votre .env
TWILIO_AI_PROVIDER=ELEVENLABS  # ✅ Correct
ELEVENLABS_API_KEY=sk_xxxxx
ELEVENLABS_AGENT_ID=your-agent-id
```

### 2. Agent ElevenLabs Configuré

Allez sur https://elevenlabs.io/app/conversational-ai

#### A. System Prompt
Copiez le prompt médical depuis votre code (`OpenAIRealtimeService.java` lignes 43-133)

#### B. First Message ⚠️ **OBLIGATOIRE !**

Dans le champ "First Message" de l'agent, ajoutez :

```
Bonjour, vous êtes en contact avec la Clinique La Rive Bleue. Cet appel est enregistré afin d'améliorer la qualité de nos services. Comment puis-je vous aider aujourd'hui ?
```

**Sans ce message, l'agent sera silencieux après connexion !**

#### C. Tools/Functions

Configurez le tool `enregistrer_patient` :

```json
{
  "name": "enregistrer_patient",
  "description": "Enregistre les informations du patient et son rendez-vous",
  "parameters": {
    "type": "object",
    "properties": {
      "nom": { "type": "string", "description": "Nom complet du patient" },
      "date_naissance": { "type": "string", "description": "Date de naissance JJ/MM/AAAA" },
      "telephone": { "type": "string", "description": "Numéro de téléphone" },
      "maladie": { "type": "string", "description": "Motif de consultation" },
      "motif_visite": { "type": "string", "description": "Motif détaillé de la visite" },
      "appointment_date_time": { "type": "string", "description": "Date/heure ISO 8601" },
      "doctor_name": { "type": "string", "description": "Nom du médecin" },
      "appointment_confirmed": { "type": "boolean", "description": "Confirmation du RDV" }
    },
    "required": ["nom", "date_naissance", "telephone", "maladie"]
  }
}
```

**Webhook URL**: `https://votre-domaine.com/api/voip/elevenlabs/call-summary`

#### D. Voice

Choisissez une voix française professionnelle :
- **Charlotte** (féminin, chaleureux)
- **Antoine** (masculin, rassurant)

### 3. Activez l'Agent

⚠️ **Important** : L'agent doit être **"Active"** dans le dashboard !

---

## 🔄 Comment ça marche maintenant

### Avant (Problème)
```
Appel Twilio → TwiML <Say> message → WebSocket → Agent silent ❌
```

### Après (Solution)
```
Appel Twilio → TwiML (pas de <Say>) → WebSocket → Agent parle avec "First Message" ✅
```

---

## 🧪 Test de Vérification

1. **Appelez votre numéro Twilio**
2. **Vous devriez entendre** : Le message d'accueil depuis l'agent ElevenLabs (pas le code)
3. **Vérifiez les logs** :

```
INFO  TwilioVoiceController - 🎙️ ElevenLabs mode: Agent will deliver welcome message from dashboard
INFO  ElevenLabsSessionHandler - ElevenLabs handler - Client connected: callSid=CAxxxxx
```

---

## 🐛 Dépannage Rapide

### "J'entends toujours le message du code"

➡️ Vérifiez `TWILIO_AI_PROVIDER=ELEVENLABS` dans `.env`  
➡️ Redémarrez l'application après modification

### "Silence après connexion"

➡️ **Cause #1** : Pas de "first message" dans le dashboard  
➡️ **Cause #2** : Agent pas "Active"  
➡️ **Cause #3** : API Key ou Agent ID incorrect

### "L'agent parle mais les données ne sont pas sauvegardées"

➡️ Vérifiez que le tool `enregistrer_patient` est configuré  
➡️ Vérifiez que le webhook URL est accessible publiquement  
➡️ Regardez les logs pour les callbacks

---

## 📊 Comparaison OpenAI vs ElevenLabs

| Aspect | OpenAI | ElevenLabs |
|--------|--------|------------|
| **Message d'accueil** | TwiML `<Say>` (code) | Agent "First Message" (dashboard) |
| **Configuration** | Code | Dashboard |
| **Extraction données** | Function calling | Tool callbacks |
| **Coût/min** | ~$0.30 | ~$0.10 |
| **Setup** | Plus complexe | Plus simple |

---

## ✅ Résumé

1. ✅ **Code modifié** : Pas de `<Say>` quand `TWILIO_AI_PROVIDER=ELEVENLABS`
2. ✅ **Agent doit avoir** : "First Message" configuré dans le dashboard
3. ✅ **Build réussi** : Tout compile correctement
4. ✅ **Documentation à jour** : `TWILIO_AI_PROVIDER_SWITCH.md` explique tout

**Votre problème est résolu ! Configurez juste le "first message" dans le dashboard ElevenLabs.** 🎉
