# 🔍 Diagnostic : Telnyx Cost Tracking (`call_cost_records` vide)

## ✅ Code Existant (Déjà Implémenté)

Le système a déjà tout le code nécessaire :

1. **TelnyxCallEndController** → Reçoit webhook `call.hangup`
2. **TelnyxCostService** → Appelle API Telnyx Detail Records
3. **CallCostTrackingService** → Sauvegarde dans `saas_db.call_cost_records`

## ❌ Pourquoi `call_cost_records` est Vide ?

### Problème 1 : API Key Telnyx Non Configurée

**Vérification** :
```yaml
# application.yml ou .env
telnyx:
  api:
    key: ${TELNYX_API_KEY:your-telnyx-api-key}
```

**Action** : Ajoutez votre vraie API Key Telnyx
```bash
# Dans .env
TELNYX_API_KEY=KEYxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
```

**Test dans les logs** :
```
❌ [TelnyxCostService] Telnyx API Key not configured - CANNOT fetch call cost!
```
Si vous voyez ce message → API Key manquante !

---

### Problème 2 : Webhook `call.hangup` Non Configuré

Le webhook `/api/voip/telnyx/call-ended` doit recevoir les événements `call.hangup` de Telnyx.

**Configuration Telnyx Portal** :

1. Allez sur [Telnyx Portal](https://portal.telnyx.com/) → **Webhooks**
2. Créez un nouveau webhook :
   - **Event Type** : `call.hangup`
   - **Webhook URL** : `https://votre-domain.ngrok.dev/api/voip/telnyx/call-ended`
   - **Method** : POST
3. Sauvegardez

**Test** : Après un appel, vérifiez les logs :
```
╔═══════════════════════════════════════════════════════╗
║     TELNYX CALL ENDED WEBHOOK RECEIVED               ║
╚═══════════════════════════════════════════════════════╝
```
Si vous ne voyez PAS ce message → Webhook pas configuré !

---

### Problème 3 : Délai des Detail Records

Les CDRs Telnyx ne sont **pas immédiatement disponibles** après un appel. Il faut **attendre quelques minutes**.

**Logs attendus** :
```
⚠️ [TelnyxCostService] No detail records found for call session: v3:xxx
⚠️ [TelnyxCostService] Call detail records may not be available yet (wait a few minutes after call ends)
```

**Solution** : Attendez 2-5 minutes, puis testez manuellement l'API.

---

## 🧪 Tests Manuels

### Test 1 : Vérifier API Key

```bash
# Remplacez YOUR_API_KEY et CALL_SESSION_ID
curl -X GET "https://api.telnyx.com/v2/detail_records?filter[call_session_id]=v3:your-call-session-id" \
  -H "Authorization: Bearer YOUR_API_KEY" \
  -H "Accept: application/json"
```

**Réponse Attendue** :
```json
{
  "data": [
    {
      "call_session_id": "v3:xxx",
      "cost": "-0.0075",
      "duration": "30",
      "start_time": "2025-10-21T14:00:00Z",
      "end_time": "2025-10-21T14:00:30Z"
    }
  ]
}
```

**Erreurs Possibles** :
- `401 Unauthorized` → API Key invalide
- `"data": []` → CDR pas encore disponible (attendre 2-5 min)

---

### Test 2 : Simuler Webhook Telnyx

```bash
curl -X POST http://localhost:7001/api/voip/telnyx/call-ended \
  -H "Content-Type: application/json" \
  -d '{
    "data": {
      "payload": {
        "event_type": "call.hangup",
        "call_session_id": "v3:test-session-id",
        "from": "+212661979197",
        "to": "+18066983980",
        "state": "hangup"
      }
    }
  }'
```

**Logs Attendus** :
```
╔═══════════════════════════════════════════════════════╗
║     TELNYX CALL ENDED WEBHOOK RECEIVED               ║
╚═══════════════════════════════════════════════════════╝
✅ [TelnyxCostService] Telnyx API Key configured
🔍 [TelnyxCostService] Calling Telnyx Detail Records API
💰 [TelnyxCostService] Cost set: 0.0075 USD
✅ [TelnyxCostService] Telnyx call cost saved to ADMIN database (saas_db)!
```

---

### Test 3 : Vérifier Base de Données

```sql
-- Vérifier si des records existent
SELECT * FROM saas_db.call_cost_records 
WHERE provider = 'TELNYX' 
ORDER BY created_at DESC 
LIMIT 5;

-- Si vide, vérifier la structure
DESCRIBE saas_db.call_cost_records;
```

---

## 🚀 Solution Complète

### Étape 1 : Configurer API Key

```yaml
# application.yml
telnyx:
  api:
    key: KEYxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  # Votre vraie clé
```

### Étape 2 : Configurer Webhook Telnyx Portal

1. Portal Telnyx → Webhooks → New Webhook
2. Event: `call.hangup`
3. URL: `https://votre-ngrok.dev/api/voip/telnyx/call-ended`

### Étape 3 : Tester

1. Passez un appel Telnyx
2. Attendez 2-5 minutes
3. Vérifiez les logs :
```bash
tail -f logs/spring-boot.log | grep TelnyxCost
```
4. Vérifiez la base :
```sql
SELECT * FROM saas_db.call_cost_records WHERE provider = 'TELNYX';
```

---

## 📊 Résultat Attendu

Après un appel Telnyx, vous devriez avoir :

| Base | Table | Données |
|------|-------|---------|
| `saas_db` | `inbound_call_data` | ✅ Remplie (provider=TELNYX) |
| `tenant_X` | `inbound_call_data` | ✅ Remplie (provider=TELNYX) |
| `saas_db` | `call_cost_records` | ✅ Remplie (cost, duration) |

**Exemple Record** :
```json
{
  "id": 1,
  "provider": "TELNYX",
  "call_sid": "v3:qg18_QgOdwtbMq...",
  "cost": 0.0075,
  "currency": "USD",
  "call_duration_seconds": 30,
  "from_number": "+212661979197",
  "to_number": "+18066983980",
  "created_at": "2025-10-21 14:05:00"
}
```

---

## 🔧 Troubleshooting

| Symptôme | Cause Probable | Solution |
|----------|----------------|----------|
| Webhook jamais reçu | URL incorrecte ou Webhook pas configuré | Vérifier Telnyx Portal |
| `API Key not configured` | Variable d'environnement manquante | Ajouter `TELNYX_API_KEY` |
| `No detail records found` | CDR pas encore disponible | Attendre 2-5 minutes |
| `401 Unauthorized` | API Key invalide | Vérifier clé sur Telnyx Portal |
| `Tenant schema not found` | Numéro pas dans `phone_numbers` | Ajouter numéro via Admin API |

---

**Prochaine Étape** : Vérifiez d'abord si `TELNYX_API_KEY` est configurée et partagez les logs après un appel test ! 🚀
