package com.saas.admin.repository;

import com.saas.admin.entity.PhoneNumber;
import com.saas.shared.enums.Provider;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface PhoneNumberRepository extends JpaRepository<PhoneNumber, Long> {
    
    Optional<PhoneNumber> findByPhoneNumber(String phoneNumber);
    
    Optional<PhoneNumber> findByPhoneNumberAndProvider(String phoneNumber, Provider provider);
    
    List<PhoneNumber> findByTenantId(String tenantId);
    
    List<PhoneNumber> findByTenantIdAndProvider(String tenantId, Provider provider);
    
    List<PhoneNumber> findByIsActive(Boolean isActive);
    
    List<PhoneNumber> findByProvider(Provider provider);
    
    Optional<PhoneNumber> findByPhoneNumberAndIsActive(String phoneNumber, Boolean isActive);
}
