package com.saas.shared.dto.mapper;

import com.saas.admin.dto.response.RoleResponse;
import com.saas.admin.entity.Role;
import com.saas.admin.entity.RolePermission;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Named;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Mapper(componentModel = "spring")
public interface RoleMapper {
    
    @Mapping(target = "permissions", source = "role", qualifiedByName = "extractPermissions")
    RoleResponse toResponse(Role role);
    
    List<RoleResponse> toResponseList(List<Role> roles);
    
    @Named("extractPermissions")
    default List<String> extractPermissions(Role role) {
        if (role.getRolePermissions() == null) {
            return List.of();
        }
        
        return role.getRolePermissions().stream()
                .map(rp -> rp.getPermission().getPermissionString())
                .collect(Collectors.toList());
    }
}
