package com.saas.shared.config;

import com.saas.shared.interceptor.TenantMigrationInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig implements WebMvcConfigurer {
    
    @Autowired
    private TenantMigrationInterceptor tenantMigrationInterceptor;
    
    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(tenantMigrationInterceptor)
                .addPathPatterns("/api/tenant/**")
                .excludePathPatterns(
                        "/api/auth/**",
                        "/api/admin/**",
                        "/api/voip/**",
                        "/actuator/**"
                );
    }
}
