package com.saas.shared.dto.mapper;

import com.saas.admin.entity.TenantVoipConfig;
import com.saas.shared.dto.VoipConfigDTO;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

/**
 * MapStruct mapper for converting between TenantVoipConfig entity and VoipConfigDTO.
 * Used by RuntimeService to convert DB entities to immutable DTOs.
 */
@Mapper(componentModel = "spring")
public interface VoipConfigDtoMapper {
    
    /**
     * Convert entity to DTO
     * Sets fromDatabase = true since this comes from DB
     */
    @Mapping(target = "fromDatabase", constant = "true")
    VoipConfigDTO toDto(TenantVoipConfig entity);
}
