package com.saas.voip.config;

import com.saas.shared.enums.VoiceAiProviderType;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix = "twilio.ai")
@Data
public class VoiceAiConfig {
    
    private VoiceAiProviderType provider = VoiceAiProviderType.OPENAI;
    
    private OpenAiSettings openai = new OpenAiSettings();
    private ElevenLabsSettings elevenlabs = new ElevenLabsSettings();
    
    @Data
    public static class OpenAiSettings {
        private String apiKey;
        private String model = "gpt-4o-realtime-preview-2024-10-01";
        private String wsUrl = "wss://api.openai.com/v1/realtime";
    }
    
    @Data
    public static class ElevenLabsSettings {
        private String apiKey;
        private String agentId;
        private String wsUrl = "wss://api.elevenlabs.io/v1/convai/conversation";
    }
}
