package com.saas.voip.service;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
@RequiredArgsConstructor
@Slf4j
public class ZiwoVoiceAIService {

    private final ZiwoApiService ziwoApiService;

    public Map<String, Object> startAIAgent(String callId, String aiAgentId) {
        log.info("Starting Ziwo AI Agent for callId: {}, agentId: {}", callId, aiAgentId);
        
        log.warn("Ziwo AI Agent is automatically started via workflow configuration in Ziwo dashboard. " +
                 "No explicit API call needed to start the agent on an active call. " +
                 "Configure the AI Agent workflow in your Ziwo dashboard and assign it to your phone number.");
        
        return Map.of(
            "status", "configured_via_dashboard",
            "message", "Ziwo AI Agent starts automatically when call is routed to configured workflow",
            "callId", callId
        );
    }

    public boolean stopAIAgent(String callId) {
        log.info("Stopping Ziwo AI Agent for callId: {}", callId);
        
        return ziwoApiService.hangupCall(callId);
    }

    public String getConversationTranscript(String callId) {
        log.info("Getting Ziwo conversation transcript for callId: {}", callId);
        
        Map<String, Object> callDetails = ziwoApiService.getCallDetails(callId);
        
        if (callDetails != null && callDetails.containsKey("transcript")) {
            return callDetails.get("transcript").toString();
        }
        
        return null;
    }

    public Map<String, Object> getCallVariables(String callId) {
        log.info("Getting Ziwo call variables for callId: {}", callId);
        
        Map<String, Object> callDetails = ziwoApiService.getCallDetails(callId);
        
        if (callDetails != null && callDetails.containsKey("variables")) {
            @SuppressWarnings("unchecked")
            Map<String, Object> variables = (Map<String, Object>) callDetails.get("variables");
            return variables;
        }
        
        return null;
    }
}
