@if(setting('chatpro-temp-chat-allowed', 1) == 1)
		<div class="pointer-events-auto">
			<x-button
				class="lqd-chat-temp-btn size-auto shrink-0 border-heading-foreground/5 text-heading-foreground max-md:bg-transparent max-md:hover:bg-transparent max-md:hover:shadow-none md:size-10 md:border md:hover:border-primary md:hover:bg-primary md:hover:text-primary-foreground lg:size-11 [&.active]:border-primary [&.active]:bg-primary [&.active]:text-primary-foreground"
				id="temp_chat_button"
				variant="none"
				x-data="tempButtonStatus({ status: {{ $tempChat ? 'true' : 'false' }} })"
				::class="{ 'active': status }"
				size="none"
				tag="button"
				title="{{ __('Temporary Chat') }}"
				@click.prevent="{{ auth()->check() ? 'toggle' : 'toastr.warning(\'' . __('Login to use Temporary Chat.') . '\')' }}"
			>
				<svg
					class="max-md:size-5"
					width="23"
					height="13"
					viewBox="0 0 23 13"
					fill="currentColor"
					xmlns="http://www.w3.org/2000/svg"
				>
					<path
						d="M6.62216 12.0625C5.8028 12.0625 5.01276 11.9166 4.25206 11.6247C3.49145 11.333 2.81389 10.9075 2.21947 10.3484C1.44605 9.61398 0.882744 8.73839 0.529772 7.72162C0.176591 6.70475 0 5.6553 0 4.57315C0 3.36834 0.289062 2.38837 0.867187 1.63312C1.44531 0.877672 2.28958 0.5 3.3999 0.5C3.60487 0.5 3.80333 0.518605 3.99537 0.55571C4.18741 0.59271 4.3804 0.64821 4.57455 0.722316L11.0369 3.14203L17.4993 0.722316C17.6935 0.64821 17.8864 0.59271 18.0785 0.55571C18.2705 0.518605 18.469 0.5 18.674 0.5C19.7843 0.5 20.6285 0.877672 21.2067 1.63312C21.7848 2.38837 22.0739 3.36834 22.0739 4.57315C22.0739 5.6553 21.8973 6.70475 21.5441 7.72162C21.1911 8.73839 20.6278 9.61398 19.8544 10.3484C19.26 10.9075 18.5824 11.333 17.8218 11.6247C17.0611 11.9166 16.2711 12.0625 15.4517 12.0625C14.3898 12.0625 13.4644 11.7997 12.6753 11.2741L11.4918 10.4858H10.5821L9.39842 11.2741C8.60944 11.7997 7.68402 12.0625 6.62216 12.0625ZM6.62216 10.4858C7.27039 10.4858 7.8748 10.3325 8.43537 10.0259C8.99594 9.71931 9.51278 9.3471 9.98579 8.90909H12.0881C12.5611 9.3471 13.0779 9.71931 13.6385 10.0259C14.1991 10.3325 14.8035 10.4858 15.4517 10.4858C16.0824 10.4858 16.6912 10.3763 17.2781 10.1573C17.8649 9.93836 18.3862 9.60105 18.8416 9.1456C19.4373 8.54992 19.8621 7.84923 20.1161 7.04332C20.3702 6.23742 20.4972 5.41406 20.4972 4.57315C20.4972 3.85491 20.3482 3.25482 20.0504 2.77308C19.7526 2.29135 19.2796 2.05915 18.6314 2.0767C18.5788 2.0767 18.3862 2.11171 18.0533 2.18182L11.0369 4.80966L4.0206 2.18182C3.93304 2.14682 3.84106 2.12054 3.74467 2.10298C3.64828 2.08543 3.54758 2.0767 3.44247 2.0767C2.79424 2.0767 2.32122 2.31321 2.02344 2.78622C1.72565 3.25923 1.5767 3.85491 1.5767 4.57315C1.5767 5.43162 1.70368 6.2637 1.95774 7.0696C2.2118 7.87551 2.6454 8.5762 3.25852 9.17188C3.71398 9.60988 4.23082 9.93836 4.80895 10.1573C5.38707 10.3763 5.99148 10.4858 6.62216 10.4858ZM7.9098 8.74753C8.50401 8.74753 8.96998 8.61814 9.3076 8.35935C9.64512 8.10056 9.8174 7.74075 9.82423 7.27983C9.81068 6.46184 9.25746 5.6799 8.16449 4.9339C7.07162 4.18802 5.91811 3.81507 4.70384 3.81507C4.10963 3.81507 3.64366 3.94436 3.30614 4.20315C2.96851 4.46194 2.79623 4.82175 2.7894 5.28267C2.80296 6.10066 3.35617 6.88261 4.44914 7.62849C5.54201 8.37448 6.69553 8.74753 7.9098 8.74753ZM7.81289 7.49395C7.03925 7.49395 6.24406 7.25649 5.42754 6.78159C4.61081 6.30648 4.14926 5.81759 4.04299 5.31494C4.10353 5.23947 4.19918 5.17682 4.32995 5.1271C4.4606 5.07717 4.61754 5.05216 4.80086 5.05216C5.57449 5.05216 6.36957 5.29234 7.18609 5.77282C8.00283 6.25329 8.46438 6.74491 8.57075 7.24756C8.5101 7.32303 8.41445 7.38305 8.28379 7.42751C8.15303 7.47187 7.9961 7.49395 7.81289 7.49395ZM14.1641 8.77381C15.3783 8.77381 16.5319 8.39635 17.6247 7.64174C18.7177 6.88702 19.2709 6.10066 19.2845 5.28267C19.2776 4.82858 19.1081 4.46615 18.7759 4.19527C18.4438 3.92429 17.9752 3.78879 17.37 3.78879C16.1626 3.80225 15.0108 4.18465 13.9144 4.93611C12.8181 5.68725 12.2632 6.46856 12.2497 7.27983C12.2566 7.73392 12.4287 8.09635 12.7664 8.36723C13.1039 8.63821 13.5699 8.77381 14.1641 8.77381ZM14.2611 7.50425C14.0845 7.49741 13.9319 7.47187 13.8033 7.42751C13.6745 7.38305 13.5798 7.32303 13.5192 7.24756C13.6257 6.75153 14.0872 6.26611 14.9039 5.79121C15.7206 5.31599 16.5157 5.07171 17.2891 5.05825C17.4657 5.06509 17.6183 5.09063 17.7471 5.13499C17.8757 5.17945 17.9703 5.23947 18.031 5.31494C17.9246 5.81759 17.4631 6.30816 16.6463 6.78664C15.8298 7.26501 15.0347 7.50425 14.2611 7.50425Z"
					/>
				</svg>

				<span class="md:hidden">
					{{ __('Temporary Chat') }}
				</span>
			</x-button>
		</div>
		@push('script')
			<script>
				document.addEventListener('alpine:init', () => {
					Alpine.data('tempButtonStatus', (options = {
						status: false
					}) => ({
						status: options.status,
						toggle() {
							this.status = !this.status;
							@auth
								startNewChat('{{ $category->id }}', '{{ LaravelLocalization::getCurrentLocale() }}', this.status ? 'chatpro-temp' : 'chatpro');
							@endauth
						}
					}));
				});
			</script>
		@endpush
@endif
