<?php
/**
 * ListAssociationsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Marketing Events
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Events\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Marketing\Events\ApiException;
use HubSpot\Client\Marketing\Events\Configuration;
use HubSpot\Client\Marketing\Events\HeaderSelector;
use HubSpot\Client\Marketing\Events\ObjectSerializer;

/**
 * ListAssociationsApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Events
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ListAssociationsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'associateByExternalAccountAndEventIds' => [
            'application/json',
        ],
        'associateByMarketingEventId' => [
            'application/json',
        ],
        'disassociateByExternalAccountAndEventIds' => [
            'application/json',
        ],
        'disassociateByMarketingEventId' => [
            'application/json',
        ],
        'getAllByExternalAccountAndEventIds' => [
            'application/json',
        ],
        'getAllByMarketingEventId' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation associateByExternalAccountAndEventIds
     *
     * Associate a list with a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['associateByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function associateByExternalAccountAndEventIds($external_account_id, $external_event_id, $list_id, string $contentType = self::contentTypes['associateByExternalAccountAndEventIds'][0])
    {
        $this->associateByExternalAccountAndEventIdsWithHttpInfo($external_account_id, $external_event_id, $list_id, $contentType);
    }

    /**
     * Operation associateByExternalAccountAndEventIdsWithHttpInfo
     *
     * Associate a list with a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['associateByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function associateByExternalAccountAndEventIdsWithHttpInfo($external_account_id, $external_event_id, $list_id, string $contentType = self::contentTypes['associateByExternalAccountAndEventIds'][0])
    {
        $request = $this->associateByExternalAccountAndEventIdsRequest($external_account_id, $external_event_id, $list_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation associateByExternalAccountAndEventIdsAsync
     *
     * Associate a list with a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['associateByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function associateByExternalAccountAndEventIdsAsync($external_account_id, $external_event_id, $list_id, string $contentType = self::contentTypes['associateByExternalAccountAndEventIds'][0])
    {
        return $this->associateByExternalAccountAndEventIdsAsyncWithHttpInfo($external_account_id, $external_event_id, $list_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation associateByExternalAccountAndEventIdsAsyncWithHttpInfo
     *
     * Associate a list with a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['associateByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function associateByExternalAccountAndEventIdsAsyncWithHttpInfo($external_account_id, $external_event_id, $list_id, string $contentType = self::contentTypes['associateByExternalAccountAndEventIds'][0])
    {
        $returnType = '';
        $request = $this->associateByExternalAccountAndEventIdsRequest($external_account_id, $external_event_id, $list_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'associateByExternalAccountAndEventIds'
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['associateByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function associateByExternalAccountAndEventIdsRequest($external_account_id, $external_event_id, $list_id, string $contentType = self::contentTypes['associateByExternalAccountAndEventIds'][0])
    {

        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling associateByExternalAccountAndEventIds'
            );
        }

        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling associateByExternalAccountAndEventIds'
            );
        }

        // verify the required parameter 'list_id' is set
        if ($list_id === null || (is_array($list_id) && count($list_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $list_id when calling associateByExternalAccountAndEventIds'
            );
        }


        $resourcePath = '/marketing/v3/marketing-events/associations/{externalAccountId}/{externalEventId}/lists/{listId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalAccountId' . '}',
                ObjectSerializer::toPathValue($external_account_id),
                $resourcePath
            );
        }
        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }
        // path params
        if ($list_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listId' . '}',
                ObjectSerializer::toPathValue($list_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation associateByMarketingEventId
     *
     * Associate a list with a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['associateByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function associateByMarketingEventId($marketing_event_id, $list_id, string $contentType = self::contentTypes['associateByMarketingEventId'][0])
    {
        $this->associateByMarketingEventIdWithHttpInfo($marketing_event_id, $list_id, $contentType);
    }

    /**
     * Operation associateByMarketingEventIdWithHttpInfo
     *
     * Associate a list with a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['associateByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function associateByMarketingEventIdWithHttpInfo($marketing_event_id, $list_id, string $contentType = self::contentTypes['associateByMarketingEventId'][0])
    {
        $request = $this->associateByMarketingEventIdRequest($marketing_event_id, $list_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation associateByMarketingEventIdAsync
     *
     * Associate a list with a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['associateByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function associateByMarketingEventIdAsync($marketing_event_id, $list_id, string $contentType = self::contentTypes['associateByMarketingEventId'][0])
    {
        return $this->associateByMarketingEventIdAsyncWithHttpInfo($marketing_event_id, $list_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation associateByMarketingEventIdAsyncWithHttpInfo
     *
     * Associate a list with a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['associateByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function associateByMarketingEventIdAsyncWithHttpInfo($marketing_event_id, $list_id, string $contentType = self::contentTypes['associateByMarketingEventId'][0])
    {
        $returnType = '';
        $request = $this->associateByMarketingEventIdRequest($marketing_event_id, $list_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'associateByMarketingEventId'
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['associateByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function associateByMarketingEventIdRequest($marketing_event_id, $list_id, string $contentType = self::contentTypes['associateByMarketingEventId'][0])
    {

        // verify the required parameter 'marketing_event_id' is set
        if ($marketing_event_id === null || (is_array($marketing_event_id) && count($marketing_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketing_event_id when calling associateByMarketingEventId'
            );
        }

        // verify the required parameter 'list_id' is set
        if ($list_id === null || (is_array($list_id) && count($list_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $list_id when calling associateByMarketingEventId'
            );
        }


        $resourcePath = '/marketing/v3/marketing-events/associations/{marketingEventId}/lists/{listId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($marketing_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'marketingEventId' . '}',
                ObjectSerializer::toPathValue($marketing_event_id),
                $resourcePath
            );
        }
        // path params
        if ($list_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listId' . '}',
                ObjectSerializer::toPathValue($list_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation disassociateByExternalAccountAndEventIds
     *
     * Disassociate a list from a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disassociateByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function disassociateByExternalAccountAndEventIds($external_account_id, $external_event_id, $list_id, string $contentType = self::contentTypes['disassociateByExternalAccountAndEventIds'][0])
    {
        $this->disassociateByExternalAccountAndEventIdsWithHttpInfo($external_account_id, $external_event_id, $list_id, $contentType);
    }

    /**
     * Operation disassociateByExternalAccountAndEventIdsWithHttpInfo
     *
     * Disassociate a list from a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disassociateByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function disassociateByExternalAccountAndEventIdsWithHttpInfo($external_account_id, $external_event_id, $list_id, string $contentType = self::contentTypes['disassociateByExternalAccountAndEventIds'][0])
    {
        $request = $this->disassociateByExternalAccountAndEventIdsRequest($external_account_id, $external_event_id, $list_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation disassociateByExternalAccountAndEventIdsAsync
     *
     * Disassociate a list from a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disassociateByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function disassociateByExternalAccountAndEventIdsAsync($external_account_id, $external_event_id, $list_id, string $contentType = self::contentTypes['disassociateByExternalAccountAndEventIds'][0])
    {
        return $this->disassociateByExternalAccountAndEventIdsAsyncWithHttpInfo($external_account_id, $external_event_id, $list_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation disassociateByExternalAccountAndEventIdsAsyncWithHttpInfo
     *
     * Disassociate a list from a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disassociateByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function disassociateByExternalAccountAndEventIdsAsyncWithHttpInfo($external_account_id, $external_event_id, $list_id, string $contentType = self::contentTypes['disassociateByExternalAccountAndEventIds'][0])
    {
        $returnType = '';
        $request = $this->disassociateByExternalAccountAndEventIdsRequest($external_account_id, $external_event_id, $list_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'disassociateByExternalAccountAndEventIds'
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disassociateByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function disassociateByExternalAccountAndEventIdsRequest($external_account_id, $external_event_id, $list_id, string $contentType = self::contentTypes['disassociateByExternalAccountAndEventIds'][0])
    {

        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling disassociateByExternalAccountAndEventIds'
            );
        }

        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling disassociateByExternalAccountAndEventIds'
            );
        }

        // verify the required parameter 'list_id' is set
        if ($list_id === null || (is_array($list_id) && count($list_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $list_id when calling disassociateByExternalAccountAndEventIds'
            );
        }


        $resourcePath = '/marketing/v3/marketing-events/associations/{externalAccountId}/{externalEventId}/lists/{listId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalAccountId' . '}',
                ObjectSerializer::toPathValue($external_account_id),
                $resourcePath
            );
        }
        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }
        // path params
        if ($list_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listId' . '}',
                ObjectSerializer::toPathValue($list_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation disassociateByMarketingEventId
     *
     * Disassociate a list from a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disassociateByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function disassociateByMarketingEventId($marketing_event_id, $list_id, string $contentType = self::contentTypes['disassociateByMarketingEventId'][0])
    {
        $this->disassociateByMarketingEventIdWithHttpInfo($marketing_event_id, $list_id, $contentType);
    }

    /**
     * Operation disassociateByMarketingEventIdWithHttpInfo
     *
     * Disassociate a list from a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disassociateByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function disassociateByMarketingEventIdWithHttpInfo($marketing_event_id, $list_id, string $contentType = self::contentTypes['disassociateByMarketingEventId'][0])
    {
        $request = $this->disassociateByMarketingEventIdRequest($marketing_event_id, $list_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation disassociateByMarketingEventIdAsync
     *
     * Disassociate a list from a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disassociateByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function disassociateByMarketingEventIdAsync($marketing_event_id, $list_id, string $contentType = self::contentTypes['disassociateByMarketingEventId'][0])
    {
        return $this->disassociateByMarketingEventIdAsyncWithHttpInfo($marketing_event_id, $list_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation disassociateByMarketingEventIdAsyncWithHttpInfo
     *
     * Disassociate a list from a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disassociateByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function disassociateByMarketingEventIdAsyncWithHttpInfo($marketing_event_id, $list_id, string $contentType = self::contentTypes['disassociateByMarketingEventId'][0])
    {
        $returnType = '';
        $request = $this->disassociateByMarketingEventIdRequest($marketing_event_id, $list_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'disassociateByMarketingEventId'
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $list_id The ILS ID of the list. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['disassociateByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function disassociateByMarketingEventIdRequest($marketing_event_id, $list_id, string $contentType = self::contentTypes['disassociateByMarketingEventId'][0])
    {

        // verify the required parameter 'marketing_event_id' is set
        if ($marketing_event_id === null || (is_array($marketing_event_id) && count($marketing_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketing_event_id when calling disassociateByMarketingEventId'
            );
        }

        // verify the required parameter 'list_id' is set
        if ($list_id === null || (is_array($list_id) && count($list_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $list_id when calling disassociateByMarketingEventId'
            );
        }


        $resourcePath = '/marketing/v3/marketing-events/associations/{marketingEventId}/lists/{listId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($marketing_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'marketingEventId' . '}',
                ObjectSerializer::toPathValue($marketing_event_id),
                $resourcePath
            );
        }
        // path params
        if ($list_id !== null) {
            $resourcePath = str_replace(
                '{' . 'listId' . '}',
                ObjectSerializer::toPathValue($list_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllByExternalAccountAndEventIds
     *
     * Get lists associated with a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function getAllByExternalAccountAndEventIds($external_account_id, $external_event_id, string $contentType = self::contentTypes['getAllByExternalAccountAndEventIds'][0])
    {
        list($response) = $this->getAllByExternalAccountAndEventIdsWithHttpInfo($external_account_id, $external_event_id, $contentType);
        return $response;
    }

    /**
     * Operation getAllByExternalAccountAndEventIdsWithHttpInfo
     *
     * Get lists associated with a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllByExternalAccountAndEventIdsWithHttpInfo($external_account_id, $external_event_id, string $contentType = self::contentTypes['getAllByExternalAccountAndEventIds'][0])
    {
        $request = $this->getAllByExternalAccountAndEventIdsRequest($external_account_id, $external_event_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllByExternalAccountAndEventIdsAsync
     *
     * Get lists associated with a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllByExternalAccountAndEventIdsAsync($external_account_id, $external_event_id, string $contentType = self::contentTypes['getAllByExternalAccountAndEventIds'][0])
    {
        return $this->getAllByExternalAccountAndEventIdsAsyncWithHttpInfo($external_account_id, $external_event_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllByExternalAccountAndEventIdsAsyncWithHttpInfo
     *
     * Get lists associated with a marketing event
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllByExternalAccountAndEventIdsAsyncWithHttpInfo($external_account_id, $external_event_id, string $contentType = self::contentTypes['getAllByExternalAccountAndEventIds'][0])
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging';
        $request = $this->getAllByExternalAccountAndEventIdsRequest($external_account_id, $external_event_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllByExternalAccountAndEventIds'
     *
     * @param  string $external_account_id The accountId that is associated with this marketing event in the external event application. (required)
     * @param  string $external_event_id The id of the marketing event in the external event application. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllByExternalAccountAndEventIds'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllByExternalAccountAndEventIdsRequest($external_account_id, $external_event_id, string $contentType = self::contentTypes['getAllByExternalAccountAndEventIds'][0])
    {

        // verify the required parameter 'external_account_id' is set
        if ($external_account_id === null || (is_array($external_account_id) && count($external_account_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_account_id when calling getAllByExternalAccountAndEventIds'
            );
        }

        // verify the required parameter 'external_event_id' is set
        if ($external_event_id === null || (is_array($external_event_id) && count($external_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_event_id when calling getAllByExternalAccountAndEventIds'
            );
        }


        $resourcePath = '/marketing/v3/marketing-events/associations/{externalAccountId}/{externalEventId}/lists';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_account_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalAccountId' . '}',
                ObjectSerializer::toPathValue($external_account_id),
                $resourcePath
            );
        }
        // path params
        if ($external_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'externalEventId' . '}',
                ObjectSerializer::toPathValue($external_event_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAllByMarketingEventId
     *
     * Get lists associated with a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging|\HubSpot\Client\Marketing\Events\Model\Error
     */
    public function getAllByMarketingEventId($marketing_event_id, string $contentType = self::contentTypes['getAllByMarketingEventId'][0])
    {
        list($response) = $this->getAllByMarketingEventIdWithHttpInfo($marketing_event_id, $contentType);
        return $response;
    }

    /**
     * Operation getAllByMarketingEventIdWithHttpInfo
     *
     * Get lists associated with a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Marketing\Events\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging|\HubSpot\Client\Marketing\Events\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAllByMarketingEventIdWithHttpInfo($marketing_event_id, string $contentType = self::contentTypes['getAllByMarketingEventId'][0])
    {
        $request = $this->getAllByMarketingEventIdRequest($marketing_event_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Marketing\Events\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Marketing\Events\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Marketing\Events\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Marketing\Events\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAllByMarketingEventIdAsync
     *
     * Get lists associated with a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllByMarketingEventIdAsync($marketing_event_id, string $contentType = self::contentTypes['getAllByMarketingEventId'][0])
    {
        return $this->getAllByMarketingEventIdAsyncWithHttpInfo($marketing_event_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAllByMarketingEventIdAsyncWithHttpInfo
     *
     * Get lists associated with a marketing event
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAllByMarketingEventIdAsyncWithHttpInfo($marketing_event_id, string $contentType = self::contentTypes['getAllByMarketingEventId'][0])
    {
        $returnType = '\HubSpot\Client\Marketing\Events\Model\CollectionResponseWithTotalPublicListNoPaging';
        $request = $this->getAllByMarketingEventIdRequest($marketing_event_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAllByMarketingEventId'
     *
     * @param  string $marketing_event_id The internal id of the marketing event in HubSpot. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAllByMarketingEventId'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAllByMarketingEventIdRequest($marketing_event_id, string $contentType = self::contentTypes['getAllByMarketingEventId'][0])
    {

        // verify the required parameter 'marketing_event_id' is set
        if ($marketing_event_id === null || (is_array($marketing_event_id) && count($marketing_event_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $marketing_event_id when calling getAllByMarketingEventId'
            );
        }


        $resourcePath = '/marketing/v3/marketing-events/associations/{marketingEventId}/lists';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($marketing_event_id !== null) {
            $resourcePath = str_replace(
                '{' . 'marketingEventId' . '}',
                ObjectSerializer::toPathValue($marketing_event_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires OAuth (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
