<!DOCTYPE html>
<html
    class="max-sm:overflow-x-hidden"
    lang="<?php echo e(LaravelLocalization::getCurrentLocale()); ?>"
    dir="<?php echo e(LaravelLocalization::getCurrentLocaleDirection()); ?>"
>

<head>
    <meta charset="UTF-8" />
    <meta
        http-equiv="X-UA-Compatible"
        content="IE=edge"
    />
    <meta
        name="viewport"
        content="width=device-width, initial-scale=1.0"
    />
    <?php if(isset($hero['type'])): ?>
        <?php if(isset($setting->meta_description)): ?>
            <meta
                name="description"
                content="<?php echo e($setting->meta_description); ?>"
            >
        <?php endif; ?>
        <?php if(isset($setting->meta_keywords)): ?>
            <meta
                name="keywords"
                content="<?php echo e($setting->meta_keywords); ?>"
            >
        <?php endif; ?>
    <?php else: ?>
        <?php if(isset($post->seo_title)): ?>
            <meta
                name="description"
                content="<?php echo e($post->seo_title); ?>"
            >
        <?php else: ?>
            <?php if(isset($setting->meta_description)): ?>
                <meta
                    name="description"
                    content="<?php echo e($setting->meta_description); ?>"
                >
            <?php endif; ?>
        <?php endif; ?>
        <?php if(isset($post->seo_description)): ?>
            <meta
                name="keywords"
                content="<?php echo e($post->seo_description); ?>"
            >
        <?php else: ?>
            <?php if(isset($setting->meta_keywords)): ?>
                <meta
                    name="keywords"
                    content="<?php echo e($setting->meta_keywords); ?>"
                >
            <?php endif; ?>
        <?php endif; ?>
    <?php endif; ?>
    <link
        rel="icon"
        href="<?php echo e(custom_theme_url($setting->favicon_path ?? 'assets/favicon.ico')); ?>"
    >
    <title>
        <?php if(isset($hero['type'])): ?>
            <?php if($hero['type'] == 'blog'): ?>
                <?php echo e($hero['title']); ?>

            <?php elseif($hero['type'] == 'category'): ?>
                <?php echo e(ucfirst($hero['title'])); ?>

            <?php elseif($hero['type'] == 'tag'): ?>
                <?php echo e(ucfirst($hero['title'])); ?>

            <?php elseif($hero['type'] == 'author'): ?>
                <?php echo e(ucfirst(App\Models\User::where('id', $hero['title'])->first()->name)); ?>

            <?php endif; ?>
        <?php else: ?>
            <?php if(isset($post->title)): ?>
                <?php echo e($post?->title); ?>

            <?php else: ?>
                <?php echo e($setting->site_name); ?>

            <?php endif; ?>
        <?php endif; ?> | <?php echo e($setting->site_name); ?>

    </title>

    <link
        rel="preconnect"
        href="https://fonts.googleapis.com"
    >
    <link
        rel="preconnect"
        href="https://fonts.gstatic.com"
        crossorigin
    >
    <link
        href="https://fonts.googleapis.com/css2?family=Golos+Text:wght@400;500;600;700&display=swap"
        rel="stylesheet"
    >
    <link
        rel="stylesheet"
        href="<?php echo e(custom_theme_url('assets/css/frontend/flickity.min.css')); ?>"
    >

    <?php
        $link = 'resources/views/' . get_theme() . '/scss/landing-page.scss';
    ?>
    <?php echo app('Illuminate\Foundation\Vite')($link); ?>

    <?php if($setting->frontend_custom_css != null): ?>
        <link
            rel="stylesheet"
            href="<?php echo e($setting->frontend_custom_css); ?>"
        />
    <?php endif; ?>

    <?php if($setting->frontend_code_before_head != null): ?>
        <?php echo $setting->frontend_code_before_head; ?>

    <?php endif; ?>

    <script>
        window.liquid = {
            isLandingPage: true
        };
    </script>
	<?php if(setting('additional_custom_css') != null): ?>
        <?php echo setting('additional_custom_css'); ?>

    <?php endif; ?>
</head>

<body class="text-body group/body bg-background font-body">

    <script src="<?php echo e(custom_theme_url('assets/js/tabler-theme.min.js')); ?>"></script>
    <script src="<?php echo e(custom_theme_url('assets/js/navbar-shrink.js')); ?>"></script>

    <div
        class="fixed left-0 right-0 top-0 z-[99] opacity-0 transition-opacity"
        id="app-loading-indicator"
    >
        <div class="progress [--tblr-progress-height:3px]">
            <div class="progress-bar progress-bar-indeterminate bg-[--tblr-primary] before:[animation-timing-function:ease-in-out] dark:bg-white">
            </div>
        </div>
    </div>

    <?php echo $__env->make('blog.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make('blog.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php if($setting->frontend_custom_js != null): ?>
        <script src="<?php echo e(custom_theme_url($setting->frontend_custom_js)); ?>"></script>
    <?php endif; ?>

    <?php if($setting->frontend_code_before_body != null): ?>
        <?php echo $setting->frontend_code_before_body; ?>

    <?php endif; ?>

    <script src="<?php echo e(custom_theme_url('assets/libs/vanillajs-scrollspy.min.js')); ?>"></script>
    <script src="<?php echo e(custom_theme_url('assets/libs/flickity.pkgd.min.js')); ?>"></script>
    <script src="<?php echo e(custom_theme_url('assets/js/frontend.js')); ?>"></script>
    <script src="<?php echo e(custom_theme_url('assets/js/frontend/frontend-animations.js')); ?>"></script>
    <?php if($setting->gdpr_status == 1): ?>
        <script src="<?php echo e(custom_theme_url('assets/js/gdpr.js')); ?>"></script>
    <?php endif; ?>

</body>

</html>
<?php /**PATH /home/withanouar/public_html/solvamind.ai/resources/views/default/blog/app.blade.php ENDPATH**/ ?>