<?php $__env->startSection('title', __('Subscription Payment')); ?>
<?php $__env->startSection('titlebar_actions', ''); ?>

<?php $__env->startSection('content'); ?>
    <!-- Page body -->
    <div class="py-10">
        <div class="container-xl">
            <div class="row row-cards">
                <div class="col-sm-8 col-lg-8">
                    <?php echo $__env->make('panel.user.finance.coupon.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="px-4" id="paypal-button-container"></div>
                    <br>
                    <p class="mt-3"><?php echo e(__('By purchasing you confirm our')); ?> <a
                            href="<?php echo e(url('/') . '/terms'); ?>"><?php echo e(__('Terms and Conditions')); ?></a> </p>
                </div>
                <div class="col-sm-4 col-lg-4">
                    <?php echo $__env->make('panel.user.finance.partials.plan_card', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <?php
        $clientId = $gateway->mode == 'live' ? $gateway->live_client_id : $gateway->sandbox_client_id;
        $bilig = $billingPlanId == null ? '&currency=' . currency()->code : '&vault=true&intent=subscription';
    ?>
    <script src="<?php echo e(custom_theme_url('https://www.paypal.com/sdk/js?client-id=' . $clientId . $bilig)); ?>"></script>
    <script>
        let couponValue = null;
        var bilingID = "<?php echo e($billingPlanId ?? 'null'); ?>";
        var currentURL = window.location.href;
        if (currentURL.includes('coupon=')) {
            couponValue = getParameterByName('coupon', currentURL);
        }


        //its lifetime plan, take payment for one time
        if (bilingID == null) {
            paypal.Buttons({
                style: {
                    color: 'blue',
                    shape: 'pill',
                    label: 'pay',
                },
                createOrder() {
                    return fetch("<?php echo e(route('dashboard.user.payment.prepaid.createPayPalOrder')); ?>", {
                            method: "POST",
                            headers: {
                                "Content-Type": "application/json",
                                'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>",
                            },
                            body: JSON.stringify({
                                plan_id: "<?php echo e($plan->id); ?>",
                                couponID: couponValue
                            }),
                        })
                        .then((response) => response.json())
                        .then((order) => order.id);
                },
                onApprove(data) {
                    return fetch("<?php echo e(route('dashboard.user.payment.subscription.checkout')); ?>", {
                            method: "POST",
                            headers: {
                                "Content-Type": "application/json",
                                'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>",
                            },
                            body: JSON.stringify({
                                paypalSubscriptionID: "lifetime",
                                billingPlanId: "lifetime",
                                planID: "<?php echo e($plan->id); ?>",
                                productId: "<?php echo e($productId); ?>",
                                gateway: "paypal",
                                couponID: couponValue,
                            })
                        })
                        .then((response) => response.json())
                        .then((response) => {
                            if (response.result == "OK") {
                                const element = document.getElementById('paypal-button-container');
                                element.innerHTML = '<h3><?php echo e(__('Thank you for your payment!')); ?></h3>';
                                setTimeout(function() {
                                    location.href = '/dashboard/user/payment/succesful';
                                }, 1000);
                            } else {
                                console.log(response.result);
                            }
                        });
                }
            }).render('#paypal-button-container');
        } else {
            paypal.Buttons({
                style: {
                    color: 'blue',
                    shape: 'pill',
                    label: 'pay',
                },
                createSubscription: function(data, actions) {
                    return actions.subscription.create({
                        'plan_id': '<?php echo e($billingPlanId); ?>'
                    });
                },
                onApprove: function(data, actions) {
                    return fetch("<?php echo e(route('dashboard.user.payment.subscription.checkout')); ?>", {
                            method: "POST",
                            headers: {
                                "Content-Type": "application/json",
                                'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>",
                            },
                            body: JSON.stringify({
                                paypalSubscriptionID: data.subscriptionID,
                                billingPlanId: "<?php echo e($billingPlanId); ?>",
                                planID: "<?php echo e($plan->id); ?>",
                                productId: "<?php echo e($productId); ?>",
                                gateway: "paypal",
                                couponID: couponValue,
                            })
                        })
                        .then((response) => response.json())
                        .then((response) => {
                            if (response.result == "OK") {
                                const element = document.getElementById('paypal-button-container');
                                element.innerHTML = '<h3><?php echo e(__('Thank you for your payment!')); ?></h3>';
                                setTimeout(function() {
                                    location.href = '/dashboard/user/payment/succesful';
                                }, 1000);
                            } else {
                                console.log(response.result);
                            }
                        });
                }
            }).render('#paypal-button-container');
        }

        function getParameterByName(name, url) {
            name = name.replace(/[\[\]]/g, '\\$&');
            var regex = new RegExp('[?&]' + name + '(=([^&#]*)|&|#|$)'),
                results = regex.exec(url);
            if (!results) return null;
            if (!results[2]) return '';
            return decodeURIComponent(results[2].replace(/\+/g, ' '));
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('panel.layout.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/withanouar/public_html/solvamind.ai/resources/views/default/panel/user/finance/subscription/paypal.blade.php ENDPATH**/ ?>