<section
    class="relative flex min-h-[200px] items-center justify-center overflow-hidden pb-28 pt-52 text-center text-black max-md:pb-16 max-md:pt-48"
    id="banner"
>

    <div class="container relative">
        <div class="mx-auto flex w-1/2 flex-col items-center max-lg:w-2/3 max-md:w-full">
            <div class="banner-title-wrap relative">
                <?php if(isset($post->category)): ?>
                    <?php $cat = explode(',', $post->category); ?>
                    <a
                        class="font-normal text-black"
                        href="<?php echo e(url('/blog/category', $cat[0])); ?>"
                    >
                        <span class="rounded-md bg-gradient-to-r from-purple-100 via-purple-200 to-slate-200 px-4 py-1">
                            <?php echo e($cat[0]); ?>

                        </span>
                    </a>
                <?php elseif(isset($hero['subtitle'])): ?>
                    <span class="rounded-md bg-gradient-to-r from-purple-100 via-purple-200 to-slate-200 px-4 py-1"><?php echo e(__($hero['subtitle'])); ?></span>
                <?php endif; ?>
                <h1
                    class="mb-8 mt-4 translate-y-7 font-body text-[55px] font-semibold -tracking-wide text-black opacity-0 transition-all ease-out group-[.page-loaded]/body:translate-y-0 group-[.page-loaded]/body:opacity-100">
                    <?php if(isset($post->title)): ?>
                        <?php echo e($post->title); ?>

                    <?php elseif(isset($hero['title'])): ?>
                        <?php if($hero['type'] == 'author'): ?>
                            <?php echo e(ucfirst(App\Models\User::where('id', $hero['title'])->first()->name)); ?>

                        <?php else: ?>
                            <?php echo e($hero['title']); ?>

                        <?php endif; ?>
                    <?php else: ?>
                        <?php echo e(__('Blog Posts')); ?>

                    <?php endif; ?>
                </h1>
                <?php if(isset($hero['description'])): ?>
                    <p class="text-[20px] font-medium text-[#0E3F58]">
                        <?php echo e(__($hero['description'])); ?>

                    </p>
                <?php endif; ?>
                <?php if(isset($post->seo_description)): ?>
                    <p class="text-[20px] font-medium text-[#0E3F58]">
                        <?php echo e($post->seo_description); ?>

                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/withanouar/public_html/solvamind.ai/resources/views/default/blog/hero.blade.php ENDPATH**/ ?>