/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.service;

import com.saas.shared.core.TenantContext;
import com.saas.tenant.entity.SchemaVersion;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.UniqueConstraint;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Service;

@Service
public class TenantSchemaMigrationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantSchemaMigrationService.class);
    @Autowired
    private DataSource dataSource;
    @Autowired
    private EntityManagerFactory entityManagerFactory;
    private static final String TENANT_ENTITY_PACKAGE = "com.saas.tenant.entity";

    public boolean needsMigration(String tenantSchemaName) {
        boolean needsMigration;
        String currentHash = this.calculateSchemaVersionHash();
        String dbHash = this.getLatestSchemaVersionHash(tenantSchemaName);
        if (dbHash == null) {
            log.info("No schema version found in tenant '{}'. First migration needed.", (Object)tenantSchemaName);
            return true;
        }
        boolean bl = needsMigration = !currentHash.equals(dbHash);
        if (needsMigration) {
            log.info("Schema version mismatch for tenant '{}'. Current: {}, DB: {}. Migration needed.", new Object[]{tenantSchemaName, currentHash, dbHash});
        } else {
            log.debug("Schema version up-to-date for tenant '{}'. Hash: {}", (Object)tenantSchemaName, (Object)currentHash);
        }
        return needsMigration;
    }

    public void migrateIfNeeded(String tenantSchemaName) {
        if (!this.needsMigration(tenantSchemaName)) {
            log.debug("Tenant '{}' schema is up-to-date. Skipping migration.", (Object)tenantSchemaName);
            return;
        }
        log.info("Starting automatic schema migration for tenant '{}'...", (Object)tenantSchemaName);
        try {
            this.performMigration(tenantSchemaName);
            log.info("Schema migration completed successfully for tenant '{}'", (Object)tenantSchemaName);
        }
        catch (Exception e) {
            log.error("CRITICAL: Schema migration failed for tenant '{}'. Application may be in inconsistent state!", (Object)tenantSchemaName, (Object)e);
            throw new RuntimeException("Schema migration failed for tenant: " + tenantSchemaName + ". Please check logs and resolve schema conflicts before retrying.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordInitialVersion(String tenantSchemaName) {
        TenantContext.setTenantId((String)tenantSchemaName);
        try (EntityManager em = this.entityManagerFactory.createEntityManager();){
            em.getTransaction().begin();
            Set entities = this.scanTenantEntities();
            String currentHash = this.calculateSchemaVersionHash();
            String entityNames = entities.stream().map(Class::getSimpleName).sorted().collect(Collectors.joining(", "));
            SchemaVersion version = new SchemaVersion();
            version.setVersionHash(currentHash);
            version.setEntityCount(Integer.valueOf(entities.size()));
            version.setEntityNames(entityNames);
            version.setMigrationType("INITIAL");
            version.setMigrationStatus("SUCCESS");
            version.setMigrationNotes("Initial schema creation");
            version.setIsCurrent(Boolean.valueOf(true));
            version.setAppliedBy("SYSTEM");
            version.setAppliedAt(LocalDateTime.now());
            em.persist((Object)version);
            em.getTransaction().commit();
            log.info("Initial schema version recorded for tenant '{}'. Hash: {}, Entities: {}", new Object[]{tenantSchemaName, currentHash, entities.size()});
        }
        finally {
            TenantContext.clear();
        }
    }

    private void performMigration(String tenantSchemaName) {
        StandardServiceRegistry serviceRegistry;
        block8: {
            TenantContext.setTenantId((String)tenantSchemaName);
            serviceRegistry = null;
            SessionFactory sessionFactory = null;
            Object session = null;
            Object transaction = null;
            try {
                log.info("Building Hibernate metadata for schema migration...");
                HashMap<String, Object> settings = new HashMap<String, Object>();
                settings.put("hibernate.connection.datasource", this.dataSource);
                settings.put("hibernate.dialect", "org.hibernate.dialect.MySQLDialect");
                settings.put("hibernate.default_catalog", tenantSchemaName);
                settings.put("hibernate.hbm2ddl.auto", "update");
                settings.put("hibernate.physical_naming_strategy", "org.hibernate.boot.model.naming.CamelCaseToUnderscoresNamingStrategy");
                serviceRegistry = new StandardServiceRegistryBuilder().applySettings(settings).build();
                MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
                Set tenantEntities = this.scanTenantEntities();
                log.info("Migrating {} entity tables...", (Object)tenantEntities.size());
                for (Class entityClass : tenantEntities) {
                    log.debug("Adding entity for migration: {}", (Object)entityClass.getSimpleName());
                    metadataSources.addAnnotatedClass(entityClass);
                }
                Metadata metadata = metadataSources.buildMetadata();
                sessionFactory = metadata.buildSessionFactory();
                log.info("Hibernate DDL update completed. Recording migration version...");
                this.recordMigrationVersion(tenantSchemaName, sessionFactory);
                if (sessionFactory == null) break block8;
            }
            catch (Exception e) {
                try {
                    log.error("Migration failed for tenant '{}'", (Object)tenantSchemaName, (Object)e);
                    throw new RuntimeException("Schema migration failed", e);
                }
                catch (Throwable throwable) {
                    if (sessionFactory != null) {
                        sessionFactory.close();
                    }
                    if (serviceRegistry != null) {
                        StandardServiceRegistryBuilder.destroy(serviceRegistry);
                    }
                    TenantContext.clear();
                    throw throwable;
                }
            }
            sessionFactory.close();
        }
        if (serviceRegistry != null) {
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)serviceRegistry);
        }
        TenantContext.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordMigrationVersion(String tenantSchemaName, SessionFactory sessionFactory) {
        Transaction transaction = null;
        try (Session session = null;){
            session = sessionFactory.openSession();
            transaction = session.beginTransaction();
            String query = "UPDATE SchemaVersion SET isCurrent = false WHERE isCurrent = true";
            session.createQuery(query).executeUpdate();
            Set entities = this.scanTenantEntities();
            String currentHash = this.calculateSchemaVersionHash();
            String entityNames = entities.stream().map(Class::getSimpleName).sorted().collect(Collectors.joining(", "));
            SchemaVersion version = new SchemaVersion();
            version.setVersionHash(currentHash);
            version.setEntityCount(Integer.valueOf(entities.size()));
            version.setEntityNames(entityNames);
            version.setMigrationType("AUTO");
            version.setMigrationStatus("SUCCESS");
            version.setMigrationNotes("Automatic migration on connection");
            version.setIsCurrent(Boolean.valueOf(true));
            version.setAppliedBy("SYSTEM");
            version.setAppliedAt(LocalDateTime.now());
            session.persist((Object)version);
            transaction.commit();
            log.info("Migration version recorded for tenant '{}'. Hash: {}, Entities: {}", new Object[]{tenantSchemaName, currentHash, entities.size()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLatestSchemaVersionHash(String tenantSchemaName) {
        TenantContext.setTenantId((String)tenantSchemaName);
        try {
            String string;
            EntityManager em = this.entityManagerFactory.createEntityManager();
            try {
                TypedQuery query = em.createQuery("SELECT sv.versionHash FROM SchemaVersion sv WHERE sv.isCurrent = true", String.class);
                query.setMaxResults(1);
                List results = query.getResultList();
                string = results.isEmpty() ? null : (String)results.get(0);
            }
            catch (Throwable throwable) {
                try {
                    em.close();
                    throw throwable;
                }
                catch (Exception e) {
                    log.debug("Could not retrieve schema version for tenant '{}' (table may not exist yet): {}", (Object)tenantSchemaName, (Object)e.getMessage());
                    String string2 = null;
                    return string2;
                }
            }
            em.close();
            return string;
        }
        finally {
            TenantContext.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private String calculateSchemaVersionHash() {
        try {
            void var10_19;
            Set entities = this.scanTenantEntities();
            StringBuilder fullSignature = new StringBuilder();
            List sortedEntities = entities.stream().sorted(Comparator.comparing(Class::getName)).collect(Collectors.toList());
            for (Class entityClass : sortedEntities) {
                fullSignature.append("CLASS:").append(entityClass.getName()).append("|");
                Table tableAnnotation = entityClass.getAnnotation(Table.class);
                if (tableAnnotation != null) {
                    fullSignature.append("TABLE:").append(tableAnnotation.name()).append(",schema=").append(tableAnnotation.schema()).append(",catalog=").append(tableAnnotation.catalog());
                    if (tableAnnotation.uniqueConstraints() != null && tableAnnotation.uniqueConstraints().length > 0) {
                        fullSignature.append(",UNIQUE_CONSTRAINTS:[");
                        for (UniqueConstraint uniqueConstraint : tableAnnotation.uniqueConstraints()) {
                            fullSignature.append("(name=").append(uniqueConstraint.name()).append(",cols=").append(String.join((CharSequence)",", uniqueConstraint.columnNames())).append(")");
                        }
                        fullSignature.append("]");
                    }
                    if (tableAnnotation.indexes() != null && tableAnnotation.indexes().length > 0) {
                        fullSignature.append(",INDEXES:[");
                        for (UniqueConstraint uniqueConstraint : tableAnnotation.indexes()) {
                            fullSignature.append("(name=").append(uniqueConstraint.name()).append(",cols=").append(uniqueConstraint.columnList()).append(",unique=").append(uniqueConstraint.unique()).append(")");
                        }
                        fullSignature.append("]");
                    }
                    fullSignature.append("|");
                }
                List allFields = this.getAllFields(entityClass);
                ArrayList<String> fieldSignatures = new ArrayList<String>();
                for (Field field : allFields) {
                    JoinTable joinTableAnnotation;
                    JoinColumn joinColumnAnnotation;
                    OneToOne oneToOneAnnotation;
                    ManyToMany manyToManyAnnotation;
                    OneToMany oneToManyAnnotation;
                    ManyToOne manyToOneAnnotation;
                    GeneratedValue genAnnotation;
                    Id idAnnotation;
                    StringBuilder fieldSig = new StringBuilder();
                    fieldSig.append("FIELD:").append(field.getName()).append(":").append(field.getType().getSimpleName());
                    Column columnAnnotation = field.getAnnotation(Column.class);
                    if (columnAnnotation != null) {
                        fieldSig.append(":COL(").append("name=").append(columnAnnotation.name()).append(",nullable=").append(columnAnnotation.nullable()).append(",unique=").append(columnAnnotation.unique()).append(",length=").append(columnAnnotation.length()).append(",precision=").append(columnAnnotation.precision()).append(",scale=").append(columnAnnotation.scale()).append(",insertable=").append(columnAnnotation.insertable()).append(",updatable=").append(columnAnnotation.updatable()).append(",columnDef=").append(columnAnnotation.columnDefinition()).append(",table=").append(columnAnnotation.table()).append(")");
                    }
                    if ((idAnnotation = field.getAnnotation(Id.class)) != null) {
                        fieldSig.append(":PK");
                    }
                    if ((genAnnotation = field.getAnnotation(GeneratedValue.class)) != null) {
                        fieldSig.append(":GEN(strategy=").append(genAnnotation.strategy()).append(",generator=").append(genAnnotation.generator()).append(")");
                    }
                    if ((manyToOneAnnotation = field.getAnnotation(ManyToOne.class)) != null) {
                        fieldSig.append(":MANYTOONE(").append("fetch=").append(manyToOneAnnotation.fetch()).append(",optional=").append(manyToOneAnnotation.optional()).append(",cascade=").append(Arrays.toString(manyToOneAnnotation.cascade())).append(")");
                    }
                    if ((oneToManyAnnotation = field.getAnnotation(OneToMany.class)) != null) {
                        fieldSig.append(":ONETOMANY(").append("fetch=").append(oneToManyAnnotation.fetch()).append(",mappedBy=").append(oneToManyAnnotation.mappedBy()).append(",cascade=").append(Arrays.toString(oneToManyAnnotation.cascade())).append(",orphanRemoval=").append(oneToManyAnnotation.orphanRemoval()).append(")");
                    }
                    if ((manyToManyAnnotation = field.getAnnotation(ManyToMany.class)) != null) {
                        fieldSig.append(":MANYTOMANY(").append("fetch=").append(manyToManyAnnotation.fetch()).append(",mappedBy=").append(manyToManyAnnotation.mappedBy()).append(",cascade=").append(Arrays.toString(manyToManyAnnotation.cascade())).append(")");
                    }
                    if ((oneToOneAnnotation = field.getAnnotation(OneToOne.class)) != null) {
                        fieldSig.append(":ONETOONE(").append("fetch=").append(oneToOneAnnotation.fetch()).append(",optional=").append(oneToOneAnnotation.optional()).append(",mappedBy=").append(oneToOneAnnotation.mappedBy()).append(",cascade=").append(Arrays.toString(oneToOneAnnotation.cascade())).append(",orphanRemoval=").append(oneToOneAnnotation.orphanRemoval()).append(")");
                    }
                    if ((joinColumnAnnotation = field.getAnnotation(JoinColumn.class)) != null) {
                        fieldSig.append(":JOIN(").append("name=").append(joinColumnAnnotation.name()).append(",ref=").append(joinColumnAnnotation.referencedColumnName()).append(",nullable=").append(joinColumnAnnotation.nullable()).append(",unique=").append(joinColumnAnnotation.unique()).append(",insertable=").append(joinColumnAnnotation.insertable()).append(",updatable=").append(joinColumnAnnotation.updatable()).append(",columnDef=").append(joinColumnAnnotation.columnDefinition()).append(",table=").append(joinColumnAnnotation.table()).append(",fk=(name=").append(joinColumnAnnotation.foreignKey().name()).append(",def=").append(joinColumnAnnotation.foreignKey().value()).append(")").append(")");
                    }
                    if ((joinTableAnnotation = field.getAnnotation(JoinTable.class)) != null) {
                        fieldSig.append(":JOINTABLE(").append("name=").append(joinTableAnnotation.name()).append(",schema=").append(joinTableAnnotation.schema()).append(",catalog=").append(joinTableAnnotation.catalog()).append(",fk=(name=").append(joinTableAnnotation.foreignKey().name()).append(",def=").append(joinTableAnnotation.foreignKey().value()).append(")").append(",inverseFk=(name=").append(joinTableAnnotation.inverseForeignKey().name()).append(",def=").append(joinTableAnnotation.inverseForeignKey().value()).append(")").append(",joinCols=[");
                        for (JoinColumn joinColumn : joinTableAnnotation.joinColumns()) {
                            fieldSig.append("(name=").append(joinColumn.name()).append(",ref=").append(joinColumn.referencedColumnName()).append(",nullable=").append(joinColumn.nullable()).append(",unique=").append(joinColumn.unique()).append(",insertable=").append(joinColumn.insertable()).append(",updatable=").append(joinColumn.updatable()).append(",columnDef=").append(joinColumn.columnDefinition()).append(",table=").append(joinColumn.table()).append(",fk=(name=").append(joinColumn.foreignKey().name()).append(",def=").append(joinColumn.foreignKey().value()).append(")").append(")");
                        }
                        fieldSig.append("],inverseJoinCols=[");
                        for (JoinColumn joinColumn : joinTableAnnotation.inverseJoinColumns()) {
                            fieldSig.append("(name=").append(joinColumn.name()).append(",ref=").append(joinColumn.referencedColumnName()).append(",nullable=").append(joinColumn.nullable()).append(",unique=").append(joinColumn.unique()).append(",insertable=").append(joinColumn.insertable()).append(",updatable=").append(joinColumn.updatable()).append(",columnDef=").append(joinColumn.columnDefinition()).append(",table=").append(joinColumn.table()).append(",fk=(name=").append(joinColumn.foreignKey().name()).append(",def=").append(joinColumn.foreignKey().value()).append(")").append(")");
                        }
                        fieldSig.append("]");
                        if (joinTableAnnotation.uniqueConstraints() != null && joinTableAnnotation.uniqueConstraints().length > 0) {
                            fieldSig.append(",uniqueConstraints=[");
                            for (JoinColumn joinColumn : joinTableAnnotation.uniqueConstraints()) {
                                fieldSig.append("(cols=").append(String.join((CharSequence)",", joinColumn.columnNames())).append(")");
                            }
                            fieldSig.append("]");
                        }
                        if (joinTableAnnotation.indexes() != null && joinTableAnnotation.indexes().length > 0) {
                            fieldSig.append(",indexes=[");
                            for (JoinColumn joinColumn : joinTableAnnotation.indexes()) {
                                fieldSig.append("(name=").append(joinColumn.name()).append(",cols=").append(joinColumn.columnList()).append(",unique=").append(joinColumn.unique()).append(")");
                            }
                            fieldSig.append("]");
                        }
                        fieldSig.append(")");
                    }
                    fieldSignatures.add(fieldSig.toString());
                }
                fieldSignatures.sort(String::compareTo);
                fullSignature.append(String.join((CharSequence)"|", fieldSignatures)).append("||");
            }
            String signature = fullSignature.toString();
            log.debug("Full entity signature for hashing: {}", (Object)signature.substring(0, Math.min(200, signature.length())));
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(signature.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            byte[] byArray = hashBytes;
            int n = byArray.length;
            boolean bl = false;
            while (var10_19 < n) {
                byte b = byArray[var10_19];
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
                ++var10_19;
            }
            return hexString.toString();
        }
        catch (Exception e) {
            log.error("Failed to calculate schema version hash", (Throwable)e);
            throw new RuntimeException("Hash calculation failed", e);
        }
    }

    private Set<Class<?>> scanTenantEntities() {
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        HashSet entityClasses = new HashSet();
        try {
            Set candidates = scanner.findCandidateComponents(TENANT_ENTITY_PACKAGE);
            for (BeanDefinition bd : candidates) {
                try {
                    Class<?> clazz = Class.forName(bd.getBeanClassName());
                    entityClasses.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    log.error("Could not load entity class: {}", (Object)bd.getBeanClassName(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("Error scanning tenant entities", (Throwable)e);
            throw new RuntimeException("Failed to scan tenant entities", e);
        }
        return entityClasses;
    }

    private List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> currentClass = clazz; currentClass != null && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
            Field[] declaredFields;
            for (Field field : declaredFields = currentClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                fields.add(field);
            }
        }
        return fields;
    }
}

