/*
 * Decompiled with CFR 0.152.
 */
package com.saas.admin.service;

import com.saas.admin.entity.TenantVoipConfig;
import com.saas.admin.repository.TenantVoipConfigRepository;
import com.saas.shared.enums.Provider;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantVoipConfigAdminService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantVoipConfigAdminService.class);
    private final TenantVoipConfigRepository voipConfigRepository;

    @Transactional(readOnly=true)
    public Optional<TenantVoipConfig> getVoipConfigById(Long id) {
        log.debug("Admin fetching VoIP config by ID: {}", (Object)id);
        return this.voipConfigRepository.findById((Object)id);
    }

    @Transactional(readOnly=true)
    public Optional<TenantVoipConfig> getVoipConfig(String tenantId, Provider provider) {
        log.debug("Admin fetching VoIP config for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
        return this.voipConfigRepository.findByTenantIdAndProvider(tenantId, provider);
    }

    @CacheEvict(value={"voipConfigs"}, key="#config.tenantId + '_' + #config.provider")
    @Transactional
    public TenantVoipConfig saveVoipConfig(TenantVoipConfig config) {
        log.info("\ud83d\udcbe Admin saving VoIP config for tenant: {}, provider: {}", (Object)config.getTenantId(), (Object)config.getProvider());
        Optional existing = this.voipConfigRepository.findByTenantIdAndProvider(config.getTenantId(), config.getProvider());
        if (existing.isPresent()) {
            TenantVoipConfig existingConfig = (TenantVoipConfig)existing.get();
            existingConfig.setAiAssistantId(config.getAiAssistantId());
            existingConfig.setAiType(config.getAiType());
            existingConfig.setMessagingProfileId(config.getMessagingProfileId());
            existingConfig.setStreamUrl(config.getStreamUrl());
            existingConfig.setIsActive(config.getIsActive());
            existingConfig.setMetadata(config.getMetadata());
            log.info("\u2705 Updated existing VoIP config ID: {}", (Object)existingConfig.getId());
            return (TenantVoipConfig)this.voipConfigRepository.save((Object)existingConfig);
        }
        TenantVoipConfig saved = (TenantVoipConfig)this.voipConfigRepository.save((Object)config);
        log.info("\u2705 Created new VoIP config ID: {}", (Object)saved.getId());
        return saved;
    }

    @Transactional(readOnly=true)
    public List<TenantVoipConfig> getAllConfigsForTenant(String tenantId) {
        log.debug("Fetching all VoIP configs for tenant: {}", (Object)tenantId);
        return this.voipConfigRepository.findByTenantId(tenantId);
    }

    @CacheEvict(value={"voipConfigs"}, key="#tenantId + '_' + #provider")
    @Transactional
    public void deleteVoipConfig(String tenantId, Provider provider) {
        log.info("\ud83d\uddd1\ufe0f Admin deleting VoIP config for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
        Optional config = this.voipConfigRepository.findByTenantIdAndProvider(tenantId, provider);
        if (config.isPresent()) {
            this.voipConfigRepository.delete((Object)((TenantVoipConfig)config.get()));
            log.info("\u2705 Deleted VoIP config ID: {}", (Object)((TenantVoipConfig)config.get()).getId());
        } else {
            log.warn("\u26a0\ufe0f No config found to delete for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
        }
    }

    @CacheEvict(value={"voipConfigs"}, key="#tenantId + '_' + #provider")
    @Transactional
    public void toggleVoipConfig(String tenantId, Provider provider, boolean isActive) {
        log.info("\ud83d\udd04 Admin toggling VoIP config to {} for tenant: {}, provider: {}", new Object[]{isActive, tenantId, provider});
        Optional config = this.voipConfigRepository.findByTenantIdAndProvider(tenantId, provider);
        if (config.isPresent()) {
            ((TenantVoipConfig)config.get()).setIsActive(Boolean.valueOf(isActive));
            this.voipConfigRepository.save((Object)((TenantVoipConfig)config.get()));
            log.info("\u2705 Toggled VoIP config ID: {} to active={}", (Object)((TenantVoipConfig)config.get()).getId(), (Object)isActive);
        } else {
            log.warn("\u26a0\ufe0f No config found to toggle for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
        }
    }

    @Generated
    public TenantVoipConfigAdminService(TenantVoipConfigRepository voipConfigRepository) {
        this.voipConfigRepository = voipConfigRepository;
    }
}

