/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.exception;

import com.saas.shared.dto.common.ApiResponse;
import com.saas.shared.dto.common.ErrorField;
import com.saas.shared.dto.common.ErrorResponse;
import com.saas.shared.exception.BusinessException;
import com.saas.shared.exception.ErrorCode;
import com.saas.shared.exception.ResourceNotFoundException;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={BusinessException.class})
    public ResponseEntity<ApiResponse<ErrorResponse>> handleBusinessException(BusinessException ex, HttpServletRequest request) {
        log.warn("Business exception: {} - {}", (Object)ex.getErrorCode().getCode(), (Object)ex.getMessage());
        ErrorResponse error = ErrorResponse.builder().errorCode(ex.getErrorCode().getCode()).message(ex.getMessage()).timestamp(LocalDateTime.now()).path(request.getRequestURI()).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((Object)error, (String)ex.getMessage()));
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    public ResponseEntity<ApiResponse<ErrorResponse>> handleResourceNotFound(ResourceNotFoundException ex, HttpServletRequest request) {
        log.warn("Resource not found: {}", (Object)ex.getMessage());
        ErrorResponse error = ErrorResponse.builder().errorCode(ex.getErrorCode().getCode()).message(ex.getMessage()).timestamp(LocalDateTime.now()).path(request.getRequestURI()).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body((Object)ApiResponse.error((Object)error, (String)ex.getMessage()));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<ApiResponse<ErrorResponse>> handleValidation(MethodArgumentNotValidException ex, HttpServletRequest request) {
        List fields = ex.getBindingResult().getFieldErrors().stream().map(error -> new ErrorField(error.getField(), error.getDefaultMessage(), error.getRejectedValue())).collect(Collectors.toList());
        ErrorResponse error2 = ErrorResponse.builder().errorCode(ErrorCode.VALIDATION_ERROR.getCode()).message("Validation failed").fields(fields).timestamp(LocalDateTime.now()).path(request.getRequestURI()).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponse.error((Object)error2, (String)"Validation failed"));
    }

    @ExceptionHandler(value={BadCredentialsException.class})
    public ResponseEntity<ApiResponse<ErrorResponse>> handleBadCredentials(BadCredentialsException ex, HttpServletRequest request) {
        log.warn("Bad credentials: {}", (Object)ex.getMessage());
        ErrorResponse error = ErrorResponse.builder().errorCode(ErrorCode.INVALID_CREDENTIALS.getCode()).message("Invalid email or password").timestamp(LocalDateTime.now()).path(request.getRequestURI()).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)ApiResponse.error((Object)error, (String)"Invalid email or password"));
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ResponseEntity<ApiResponse<ErrorResponse>> handleAccessDenied(AccessDeniedException ex, HttpServletRequest request) {
        log.warn("Access denied: {}", (Object)ex.getMessage());
        ErrorResponse error = ErrorResponse.builder().errorCode(ErrorCode.FORBIDDEN.getCode()).message("Access forbidden").timestamp(LocalDateTime.now()).path(request.getRequestURI()).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.FORBIDDEN).body((Object)ApiResponse.error((Object)error, (String)"Access forbidden"));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ApiResponse<ErrorResponse>> handleGeneric(Exception ex, HttpServletRequest request) {
        log.error("Unhandled exception", (Throwable)ex);
        ErrorResponse error = ErrorResponse.builder().errorCode(ErrorCode.INTERNAL_ERROR.getCode()).message("An unexpected error occurred").timestamp(LocalDateTime.now()).path(request.getRequestURI()).build();
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponse.error((Object)error, (String)"An unexpected error occurred"));
    }
}

