/*
 * Decompiled with CFR 0.152.
 */
package com.saas.shared.health;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
public class TenantDatabaseHealthIndicator
implements HealthIndicator {
    private final JdbcTemplate jdbcTemplate;

    public TenantDatabaseHealthIndicator(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Health health() {
        try {
            this.jdbcTemplate.queryForObject("SELECT 1", Integer.class);
            return Health.up().withDetail("database", (Object)"MySQL").withDetail("status", (Object)"Connected").build();
        }
        catch (Exception e) {
            return Health.down().withDetail("database", (Object)"MySQL").withDetail("status", (Object)"Disconnected").withDetail("error", (Object)e.getMessage()).build();
        }
    }
}

