/*
 * Decompiled with CFR 0.152.
 */
package com.saas.tenant.controller;

import com.saas.admin.dto.request.UpdateVoipConfigRequest;
import com.saas.admin.dto.response.VoipConfigResponse;
import com.saas.admin.entity.TenantVoipConfig;
import com.saas.admin.service.TenantVoipConfigAdminService;
import com.saas.shared.core.TenantContext;
import com.saas.shared.dto.VoipConfigDTO;
import com.saas.shared.dto.mapper.VoipConfigMapper;
import com.saas.shared.enums.Provider;
import com.saas.shared.service.TenantVoipConfigRuntimeService;
import com.saas.tenant.controller.TenantVoipConfigController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tenant/voip-configs"})
@PreAuthorize(value="hasRole('TENANT_USER')")
@Tag(name="Tenant VoIP Config", description="Self-service VoIP configuration management for tenants")
public class TenantVoipConfigController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantVoipConfigController.class);
    private final TenantVoipConfigRuntimeService voipRuntimeService;
    private final TenantVoipConfigAdminService voipAdminService;
    private final VoipConfigMapper voipConfigMapper;

    @GetMapping(value={"/{provider}"})
    @Operation(summary="Get VoIP configuration", description="Get current VoIP configuration for this tenant and provider. Returns database config if available, otherwise environment defaults.")
    public ResponseEntity<VoipConfigDTO> getVoipConfig(@PathVariable Provider provider) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udcde Tenant {} requesting VoIP config for provider: {}", (Object)tenantId, (Object)provider);
        Optional config = this.voipRuntimeService.resolveVoipConfig(tenantId, provider);
        if (config.isEmpty()) {
            log.warn("\u26a0\ufe0f No VoIP configuration available for tenant: {}, provider: {}", (Object)tenantId, (Object)provider);
            return ResponseEntity.notFound().build();
        }
        log.info("\u2705 Returning VoIP config (source: {})", (Object)(((VoipConfigDTO)config.get()).isFromDatabase() ? "DATABASE" : "ENVIRONMENT"));
        return ResponseEntity.ok((Object)((VoipConfigDTO)config.get()));
    }

    @PutMapping(value={"/{provider}"})
    @Operation(summary="Update VoIP configuration", description="Update VoIP configuration for this tenant. Creates new if doesn't exist.")
    public ResponseEntity<VoipConfigResponse> updateVoipConfig(@PathVariable Provider provider, @Valid @RequestBody UpdateVoipConfigRequest request) {
        TenantVoipConfig config;
        String tenantId = TenantContext.getTenantId();
        log.info("\u270f\ufe0f Tenant {} updating VoIP config for provider: {}", (Object)tenantId, (Object)provider);
        Optional existingOpt = this.voipAdminService.getVoipConfig(tenantId, provider);
        if (existingOpt.isPresent()) {
            config = (TenantVoipConfig)existingOpt.get();
            this.voipConfigMapper.updateEntity(request, config);
            log.info("\ud83d\udcdd Updating existing VoIP config ID: {}", (Object)config.getId());
        } else {
            config = new TenantVoipConfig();
            config.setTenantId(tenantId);
            config.setProvider(provider);
            this.voipConfigMapper.updateEntity(request, config);
            if (config.getIsActive() == null) {
                config.setIsActive(Boolean.valueOf(true));
            }
            log.info("\u2795 Creating new VoIP config for tenant");
        }
        TenantVoipConfig saved = this.voipAdminService.saveVoipConfig(config);
        VoipConfigResponse response = this.voipConfigMapper.toResponse(saved);
        log.info("\u2705 VoIP config saved successfully with ID: {}", (Object)saved.getId());
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/{provider}/status"})
    @Operation(summary="Check VoIP configuration status", description="Returns whether this tenant has a valid VoIP configuration for the provider")
    public ResponseEntity<VoipConfigStatusResponse> checkVoipConfigStatus(@PathVariable Provider provider) {
        String tenantId = TenantContext.getTenantId();
        log.info("\ud83d\udd0d Tenant {} checking VoIP config status for provider: {}", (Object)tenantId, (Object)provider);
        boolean hasValidConfig = this.voipRuntimeService.hasValidConfig(tenantId, provider);
        Optional config = this.voipRuntimeService.resolveVoipConfig(tenantId, provider);
        VoipConfigStatusResponse response = new VoipConfigStatusResponse(hasValidConfig, config.isPresent() && ((VoipConfigDTO)config.get()).isFromDatabase() ? "DATABASE" : "ENVIRONMENT", config.map(VoipConfigDTO::isActive).orElse(false).booleanValue());
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public TenantVoipConfigController(TenantVoipConfigRuntimeService voipRuntimeService, TenantVoipConfigAdminService voipAdminService, VoipConfigMapper voipConfigMapper) {
        this.voipRuntimeService = voipRuntimeService;
        this.voipAdminService = voipAdminService;
        this.voipConfigMapper = voipConfigMapper;
    }
}

