/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.TenantRepository;
import com.saas.admin.service.PhoneNumberService;
import com.saas.shared.core.TenantContext;
import com.saas.shared.enums.VoiceAiProviderType;
import com.saas.shared.service.DualSaveCallDataService;
import com.saas.tenant.entity.InboundCallData;
import com.saas.voip.config.VoiceAiConfig;
import com.saas.voip.extractor.CallDataExtractor;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voip"})
public class TwilioVoiceController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwilioVoiceController.class);
    @Value(value="${server.port:8000}")
    private String serverPort;
    private final CallDataExtractor callDataExtractor;
    private final DualSaveCallDataService dualSaveCallDataService;
    private final PhoneNumberService phoneNumberService;
    private final TenantRepository tenantRepository;
    private final VoiceAiConfig voiceAiConfig;

    @GetMapping(value={"/incoming-call"}, produces={"application/xml"})
    public String handleIncomingCallGet(HttpServletRequest request) {
        return this.handleIncomingCall(request);
    }

    @PostMapping(value={"/incoming-call"}, produces={"application/xml"})
    public String handleIncomingCallPost(HttpServletRequest request) {
        return this.handleIncomingCall(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleIncomingCall(HttpServletRequest request) {
        String twiml;
        String host = request.getHeader("Host");
        String scheme = request.getScheme();
        String forwardedProto = request.getHeader("X-Forwarded-Proto");
        log.info("=== INCOMING CALL FROM TWILIO ===");
        log.info("Host: {}", (Object)host);
        log.info("Scheme: {}", (Object)scheme);
        log.info("X-Forwarded-Proto: {}", (Object)forwardedProto);
        MultiValueMap formData = this.extractFormData(request);
        String toNumber = (String)formData.getFirst((Object)"To");
        String schemaName = null;
        if (toNumber != null) {
            try {
                TenantContext.setTenantId((String)"saas_db");
                Optional foundTenantId = this.phoneNumberService.getTenantIdByPhoneNumber(toNumber);
                if (foundTenantId.isPresent()) {
                    String tenantId = (String)foundTenantId.get();
                    log.info("\ud83d\udcde Identified Tenant ID: {} for phone number: {}", (Object)tenantId, (Object)toNumber);
                    Optional tenant = this.tenantRepository.findByTenantId(tenantId);
                    if (tenant.isPresent()) {
                        schemaName = ((Tenant)tenant.get()).getSchemaName();
                        log.info("\ud83d\udcca Using schema: {} for tenant: {}", (Object)schemaName, (Object)tenantId);
                    }
                } else {
                    log.warn("\u26a0\ufe0f No tenant found for phone number: {}", (Object)toNumber);
                }
            }
            finally {
                TenantContext.clear();
            }
        }
        if (schemaName != null) {
            try {
                InboundCallData callData = this.callDataExtractor.extractFromTwilioRequest(formData);
                this.dualSaveCallDataService.saveToBothDatabases(callData, schemaName);
                log.info("\u2705 Twilio call data saved to BOTH admin + tenant databases");
            }
            catch (Exception e) {
                log.error("Error saving Twilio call data", (Throwable)e);
            }
        } else {
            log.warn("\u26a0\ufe0f Skipping call data persistence - no tenant schema identified");
        }
        String wsProtocol = "https".equals(forwardedProto) || "https".equals(scheme) ? "wss" : "ws";
        String wsUrl = wsProtocol + "://" + host + "/media-stream";
        log.info("Generated WebSocket URL: {}", (Object)wsUrl);
        VoiceAiProviderType provider = this.voiceAiConfig.getProvider();
        String fromNumber = (String)formData.getFirst((Object)"From");
        String toNumberParam = (String)formData.getFirst((Object)"To");
        if (provider == VoiceAiProviderType.ELEVENLABS) {
            log.info("\ud83c\udf99\ufe0f ElevenLabs mode: Agent will deliver welcome message from dashboard");
            twiml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Response>  <Connect>    <Stream url=\"" + wsUrl + "\">      <Parameter name=\"From\" value=\"" + fromNumber + "\" />      <Parameter name=\"To\" value=\"" + toNumberParam + "\" />    </Stream>  </Connect></Response>";
        } else {
            log.info("\ud83c\udf99\ufe0f OpenAI mode: TwiML will deliver welcome message");
            twiml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Response>  <Say voice=\"alice\" language=\"fr-FR\">    Bonjour, vous \u00eates en contact avec la Clinique La Rive Bleue. Cet appel est enregistr\u00e9 afin d'am\u00e9liorer la qualit\u00e9 de nos services.  </Say>  <Connect>    <Stream url=\"" + wsUrl + "\">      <Parameter name=\"From\" value=\"" + fromNumber + "\" />      <Parameter name=\"To\" value=\"" + toNumberParam + "\" />    </Stream>  </Connect></Response>";
        }
        log.info("Returning TwiML for provider {}: {}", (Object)provider, (Object)twiml);
        return twiml;
    }

    @GetMapping(value={"/health"})
    public String health() {
        return "Twilio VoIP Service is running!";
    }

    private MultiValueMap<String, String> extractFormData(HttpServletRequest request) {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String[] paramValues;
            String paramName = (String)parameterNames.nextElement();
            for (String paramValue : paramValues = request.getParameterValues(paramName)) {
                formData.add((Object)paramName, (Object)paramValue);
            }
        }
        return formData;
    }

    @Generated
    public TwilioVoiceController(CallDataExtractor callDataExtractor, DualSaveCallDataService dualSaveCallDataService, PhoneNumberService phoneNumberService, TenantRepository tenantRepository, VoiceAiConfig voiceAiConfig) {
        this.callDataExtractor = callDataExtractor;
        this.dualSaveCallDataService = dualSaveCallDataService;
        this.phoneNumberService = phoneNumberService;
        this.tenantRepository = tenantRepository;
        this.voiceAiConfig = voiceAiConfig;
    }
}

