/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.controller;

import com.saas.admin.entity.PhoneNumber;
import com.saas.admin.entity.Tenant;
import com.saas.admin.repository.PhoneNumberRepository;
import com.saas.admin.repository.TenantRepository;
import com.saas.shared.core.TenantContext;
import com.saas.shared.enums.Provider;
import com.saas.tenant.entity.InboundCallData;
import com.saas.tenant.service.InboundCallService;
import com.saas.voip.extractor.ZiwoCallDataExtractor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/voip/ziwo"})
public class ZiwoVoiceController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZiwoVoiceController.class);
    private final PhoneNumberRepository phoneNumberRepository;
    private final TenantRepository tenantRepository;
    private final InboundCallService inboundCallService;
    private final ZiwoCallDataExtractor ziwoCallDataExtractor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostMapping(value={"/incoming-call"})
    public ResponseEntity<Map<String, Object>> handleIncomingCall(@RequestBody Map<String, Object> payload) {
        ResponseEntity responseEntity;
        String toNumber;
        log.info("Received Ziwo incoming call webhook: {}", payload);
        String string = toNumber = payload.get("to") != null ? payload.get("to").toString() : null;
        if (toNumber == null || toNumber.isEmpty()) {
            log.warn("No 'to' number in Ziwo webhook");
            return ResponseEntity.badRequest().body(Map.of("error", "Missing 'to' number"));
        }
        TenantContext.clear();
        Optional phoneOpt = this.phoneNumberRepository.findByPhoneNumber(toNumber);
        if (!phoneOpt.isPresent() || ((PhoneNumber)phoneOpt.get()).getProvider() != Provider.ZIWO) {
            log.warn("No Ziwo phone number found for: {}", (Object)toNumber);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Map.of("error", "Phone number not configured"));
        }
        PhoneNumber phoneNumber = (PhoneNumber)phoneOpt.get();
        String tenantId = phoneNumber.getTenantId();
        Optional tenantOpt = this.tenantRepository.findByTenantId(tenantId);
        if (!tenantOpt.isPresent()) {
            log.error("Tenant not found for phone number: {}", (Object)toNumber);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.NOT_FOUND).body(Map.of("error", "Tenant not found"));
        }
        Tenant tenant = (Tenant)tenantOpt.get();
        String schemaName = tenant.getSchemaName();
        TenantContext.setTenantId((String)schemaName);
        log.info("Set tenant context for Ziwo call: {}", (Object)schemaName);
        try {
            InboundCallData callData = this.ziwoCallDataExtractor.extractFromZiwoRequest(payload);
            this.inboundCallService.saveCallData(callData);
            log.info("Saved Ziwo inbound call data: {}", (Object)callData.getCallSid());
            HashMap<String, String> response = new HashMap<String, String>();
            response.put("status", "success");
            response.put("message", "Call received and logged");
            response.put("call_id", callData.getCallSid());
            responseEntity = ResponseEntity.ok(response);
        }
        catch (Throwable throwable) {
            try {
                TenantContext.clear();
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error handling Ziwo incoming call", (Throwable)e);
                TenantContext.clear();
                return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(Map.of("error", "Internal server error"));
            }
        }
        TenantContext.clear();
        return responseEntity;
    }

    @GetMapping(value={"/health"})
    public ResponseEntity<Map<String, Object>> health() {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", "UP");
        response.put("provider", "Ziwo");
        response.put("timestamp", System.currentTimeMillis());
        return ResponseEntity.ok(response);
    }

    @Generated
    public ZiwoVoiceController(PhoneNumberRepository phoneNumberRepository, TenantRepository tenantRepository, InboundCallService inboundCallService, ZiwoCallDataExtractor ziwoCallDataExtractor) {
        this.phoneNumberRepository = phoneNumberRepository;
        this.tenantRepository = tenantRepository;
        this.inboundCallService = inboundCallService;
        this.ziwoCallDataExtractor = ziwoCallDataExtractor;
    }
}

