/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.factory;

import com.saas.shared.enums.VoiceAiProviderType;
import com.saas.voip.config.VoiceAiConfig;
import com.saas.voip.factory.VoiceAiSessionFactory;
import com.saas.voip.handler.AiSessionHandler;
import com.saas.voip.handler.ElevenLabsSessionHandler;
import com.saas.voip.handler.OpenAiSessionHandler;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VoiceAiSessionFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VoiceAiSessionFactory.class);
    private final VoiceAiConfig voiceAiConfig;
    private final OpenAiSessionHandler openAiSessionHandler;
    private final ElevenLabsSessionHandler elevenLabsSessionHandler;

    public AiSessionHandler createHandler() {
        VoiceAiProviderType provider = this.voiceAiConfig.getProvider();
        log.info("Creating AI session handler for provider: {}", (Object)provider);
        switch (1.$SwitchMap$com$saas$shared$enums$VoiceAiProviderType[provider.ordinal()]) {
            case 1: {
                return this.openAiSessionHandler;
            }
            case 2: {
                return this.elevenLabsSessionHandler;
            }
        }
        log.warn("Unknown provider {}, falling back to OpenAI", (Object)provider);
        return this.openAiSessionHandler;
    }

    @Generated
    public VoiceAiSessionFactory(VoiceAiConfig voiceAiConfig, OpenAiSessionHandler openAiSessionHandler, ElevenLabsSessionHandler elevenLabsSessionHandler) {
        this.voiceAiConfig = voiceAiConfig;
        this.openAiSessionHandler = openAiSessionHandler;
        this.elevenLabsSessionHandler = elevenLabsSessionHandler;
    }
}

