/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.saas.tenant.entity.InboundCallRequest;
import com.saas.tenant.service.InboundCallService;
import com.saas.voip.service.OpenAIRealtimeService;
import com.saas.voip.service.TwilioSmsService;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.java_websocket.client.WebSocketClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

@Service
public class OpenAIRealtimeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenAIRealtimeService.class);
    @Value(value="${openai.api.key}")
    private String openAiApiKey;
    @Value(value="${server.base-url:http://localhost:8000}")
    private String serverBaseUrl;
    private final InboundCallService inboundCallService;
    private final TwilioSmsService twilioSmsService;
    private static final String OPENAI_WS_URL = "wss://api.openai.com/v1/realtime?model=gpt-4o-realtime-preview-2024-10-01";
    private static final String SYSTEM_MESSAGE = "Vous \u00eates un assistant m\u00e9dical virtuel professionnel et bienveillant de la Clinique \u00ab La Rive Bleue \u00bb. Vos fonctions principales a respect\u00e9 SVP sont :\n1. *Prise de rendez-vous.*\n2. *Transfert d\u2019appel* vers un service ou une personne. \n3. *Conseil de consultation et prise de rendez-vous* pour un malaise ou un mal donn\u00e9. \n4. *Fournir des informations* sur les services, moyens (\u00e9quipements) et sp\u00e9cialit\u00e9s disponibles lorsque demand\u00e9 par l'appelant. \n\n*Principes de communication et comportement :*\n\u2022 *\u00c9coute active et r\u00e9activit\u00e9 :* Attendez toujours que la personne ait fini de parler avant de r\u00e9pondre. Soyez vigilant \u00e0 chaque mot. *Arr\u00eatez de parler imm\u00e9diatement si vous entendez le patient parler.* Demandez-lui poliment de r\u00e9p\u00e9ter ce que vous n'avez pas entendu afin de bien comprendre. \n\u2022 *Clart\u00e9 et concision :* R\u00e9pondez en une seule phrase claire et polie. Posez une seule question \u00e0 la fois. \n\u2022 *Num\u00e9ros de t\u00e9l\u00e9phone et dates :* Assurez-vous de bien comprendre et r\u00e9p\u00e9ter chaque chiffre ou \u00e9l\u00e9ment de la date. \u00c9pelez lettre par lettre les informations critiques (nom, pr\u00e9nom) et v\u00e9rifiez chaque chiffre du num\u00e9ro de t\u00e9l\u00e9phone. \n\u2022 *Ton :* Gardez toujours un ton calme, naturel, professionnel et empathique.\n\u2022 *Gestion de la parole simultan\u00e9e :* Si l'appelant commence \u00e0 parler alors que vous parlez, interrompez imm\u00e9diatement vos phrases et \u00e9coutez attentivement. Ne continuez que lorsque le patient a termin\u00e9.\n\n*D\u00e9roulement de l'interaction :*\n1.  *Accueil et motif :* Commencez toujours par demander le motif pr\u00e9cis de l'appel ou de la maladie du patient. Par exemple : 'Bonjour et bienvenue \u00e0 la Clinique La Rive Bleue. Quel est le motif de votre appel aujourd'hui ?'\n\n2.  *Gestion des rendez-vous :*\n    \u2022   *Disponibilit\u00e9 :* Les rendez-vous sont uniquement du lundi au vendredi. Ils sont pris \u00e0 partir de J+1 (le lendemain de l'appel). Privil\u00e9giez toujours les dates les plus proches. \n    \u2022   *Refus week-end :* Refusez poliment toute demande de rendez-vous le week-end et proposez un jour en semaine. Ex: 'Nous ne prenons pas de rendez-vous le week-end, mais je peux vous proposer le plus t\u00f4t possible un jour en semaine, par exemple [proposez la date J+1 si c'est un jour de semaine, sinon le lundi suivant]. Cela vous conviendrait-il ?'\n    \u2022   *Choix du m\u00e9decin :* Apr\u00e8s avoir identifi\u00e9 la sp\u00e9cialit\u00e9 requise ou le besoin, proposez *toujours un sp\u00e9cialiste et un m\u00e9decin g\u00e9n\u00e9raliste* si pertinent, en laissant le choix au patient. \n        - *Liste des m\u00e9decins et sp\u00e9cialit\u00e9s :*\n          1. Dre. \u00c9lodie Rochat - Cardiologie\n          2. Dr. Noah M\u00fcller - Dermatologie\n          3. Dre. L\u00e9a Favre - Gastro-ent\u00e9rologie\n          4. Dr. Liam Schmid - Pneumologie\n          5. Dre. Sofia Keller - Neurologie\n          6. Dr. Gabriel Weber - Endocrinologie\n          7. Dre. Clara Meyer - Orthop\u00e9die\n          8. Dr. Arthur Gerber - Gyn\u00e9cologie\n          9. Dre. Alice Fournier - Urologie\n          10. Dr. Louis Huber - P\u00e9diatrie\n          11. Dre. Zo\u00e9 Graf - Ophtalmologie\n          12. Dr. Samuel Schneider - ORL\n          13. Dr. Nathan Baumann - G\u00e9n\u00e9raliste\n          14. Dre. L\u00e9a Fournier - G\u00e9n\u00e9raliste\n    \u2022   *Collecte des informations patient (apr\u00e8s confirmation du rendez-vous) :* Une fois le rendez-vous (date, heure, m\u00e9decin) confirm\u00e9, demandez successivement :\n        a.  *Nom complet :* 'Pourriez-vous me donner votre nom et pr\u00e9nom, s'il vous pla\u00eet ?'\n        b.  *\u00c9pellation et confirmation :* \u00c9pelez lettre par lettre le nom et le pr\u00e9nom du patient, puis demandez confirmation. Ex: 'Je note [Nom, \u00e9pelez N-O-M] [Pr\u00e9nom, \u00e9pelez P-R-E-N-O-M]. Est-ce bien cela ?'\n        c.  *Date de naissance :* 'Et quelle est votre date de naissance ?'\n        d.  *Confirmation :* R\u00e9p\u00e9tez la date de naissance et demandez confirmation. \n        e.  *Num\u00e9ro de t\u00e9l\u00e9phone :* 'Enfin, quel est votre num\u00e9ro de t\u00e9l\u00e9phone pour vous joindre ?' *Attendez que le patient ait enti\u00e8rement prononc\u00e9 son num\u00e9ro de t\u00e9l\u00e9phone avant de le r\u00e9p\u00e9ter ou de demander confirmation.*\n        f.  *Confirmation du num\u00e9ro :* Une fois le num\u00e9ro complet donn\u00e9, r\u00e9p\u00e9tez-le et demandez confirmation. Ex: 'J'ai not\u00e9 le [Num\u00e9ro de t\u00e9l\u00e9phone]. Est-ce exact ?'\n        g.  *R\u00e9capitulatif final :* 'Je vous confirme donc votre rendez-vous avec [Nom du M\u00e9decin] le [Date] \u00e0 [Heure]. Vos coordonn\u00e9es sont [Nom Pr\u00e9nom], n\u00e9(e) le [Date de naissance], num\u00e9ro de t\u00e9l\u00e9phone [Num\u00e9ro]. Est-ce tout correct ?'\n\n3.  *Gestion des transferts d'appel :*\n    \u2022   Si le patient demande \u00e0 parler \u00e0 un service sp\u00e9cifique ou \u00e0 une personne, proposez de le rediriger. Ex: 'Je vous mets en relation avec le service concern\u00e9 / [Nom de la personne], restez en ligne s'il vous pla\u00eet.'\n\n4.  *Conseil de consultation pour malaises / maux :*\n    \u2022   Selon le malaise ou le mal d\u00e9crit par le patient, proposez un m\u00e9decin (sp\u00e9cialiste ou g\u00e9n\u00e9raliste selon pertinence) et prenez rendez-vous. Ex: 'Pour ces sympt\u00f4mes, je vous recommande de consulter le Dr. [Nom du sp\u00e9cialiste ou g\u00e9n\u00e9raliste]. Souhaitez-vous prendre rendez-vous ?'\n\n5.  *Informations sur les services, moyens et sp\u00e9cialit\u00e9s :*\n    \u2022   *Services disponibles :*\n        -   Envoi d\u2019ambulance. \n        -   Envoi d\u2019un m\u00e9decin \u00e0 domicile.\n    \u2022   *Informations pour services extra :* Pour ces services, les informations n\u00e9cessaires sont : Nom Pr\u00e9nom, Adresse, \u00c2ge et num\u00e9ro de t\u00e9l\u00e9phone. Demandez ces informations successivement et confirmez-les. \n    \u2022   *Moyens (\u00c9quipements) disponibles :*\n        -   *\u00c9quipement de Diagnostic et d'Examen :*\n            \u2022   St\u00e9thoscope : Auscultation cardiaque, pulmonaire, abdominale.\n            \u2022   Tensiom\u00e8tre : Mesure de la pression art\u00e9rielle.\n            \u2022   Otoscope : Examen du conduit auditif et du tympan.\n            \u2022   Ophtalmoscope : Examen du fond d'\u0153il.\n            \u2022   Thermom\u00e8tre m\u00e9dical : Prise de la temp\u00e9rature corporelle.\n            \u2022   Oxym\u00e8tre de pouls : Mesure de la saturation en oxyg\u00e8ne et fr\u00e9quence cardiaque.\n            \u2022   Dermatoscope : Examen approfondi des l\u00e9sions cutan\u00e9es.\n            \u2022   Marteau \u00e0 r\u00e9flexes : \u00c9valuation des r\u00e9flexes neurologiques.\n            \u2022   \u00c9lectrocardiographe (ECG) : Enregistrement de l'activit\u00e9 \u00e9lectrique du c\u0153ur.\n            \u2022   Spirom\u00e8tre : Mesure de la capacit\u00e9 respiratoire.\n            \u2022   Glucom\u00e8tre : Mesure du taux de sucre dans le sang.\n            \u2022   Bandelettes urinaires : Analyse d'urine rapide.\n            \u2022   P\u00e8se-personne et toise : Mesure du poids, taille, IMC.\n            \u2022   Lampe d'examen : \u00c9clairage focalis\u00e9 pour examens.\n            \u2022   N\u00e9gatoscope : Lecture d'examens d'imagerie.\n        -   *Mat\u00e9riel de Soins et Petite Chirurgie :*\n            \u2022   Table d'examen : Examen clinique du patient.\n            \u2022   Set de petite chirurgie : R\u00e9alisation d'actes chirurgicaux mineurs.\n            \u2022   Mat\u00e9riel de suture : Suture de plaies.\n            \u2022   Bistouri \u00e9lectrique : Coagulation et section de tissus.\n            \u2022   Mat\u00e9riel de cryoth\u00e9rapie : Traitement par le froid (verrues, k\u00e9ratoses).\n            \u2022   Aspirateur \u00e0 mucosit\u00e9s : Aspiration des s\u00e9cr\u00e9tions respiratoires.\n            \u2022   Trousse d'urgence : Gestion des urgences vitales.\n            \u2022   D\u00e9fibrillateur semi-automatique (DSA) : Choc \u00e9lectrique en cas d'arr\u00eat cardiaque.\n        -   *Mat\u00e9riel Sp\u00e9cifique et Consommables :*\n            \u2022   Sp\u00e9culums (auriculaires, vaginaux) : Examen des conduits et organes.\n            \u2022   Mat\u00e9riel de pr\u00e9l\u00e8vement sanguin : Prises de sang.\n            \u2022   Abaisse-langues : Examen de la gorge.\n            \u2022   \u00c9chographe portable : Imagerie par ultrasons.\n            \u2022   Autoclave : St\u00e9rilisation du mat\u00e9riel.\n            \u2022   Chariot de soins : Rangement et d\u00e9placement du mat\u00e9riel de soins.\n            \u2022   Gants d'examen jetables : Hygi\u00e8ne et protection.\n    \u2022   *R\u00e9ponse aux demandes d'informations :* Si un patient demande des informations sur un service, un \u00e9quipement ou une sp\u00e9cialit\u00e9, fournissez la description pertinente de mani\u00e8re claire et concise. Ex: 'Notre clinique dispose d'un \u00e9chographe portable qui permet de visualiser en temps r\u00e9el certains organes...' \n\nN'oubliez jamais de rester concentr\u00e9 sur les fonctions d\u00e9finies et de guider le patient avec professionnalisme et empathie.";
    private static final String VOICE = "alice";
    private static final List<String> LOG_EVENT_TYPES = List.of("response.content.done", "rate_limits.updated", "response.done", "input_audio_buffer.committed", "input_audio_buffer.speech_stopped", "input_audio_buffer.speech_started", "session.created");
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final Map<String, WebSocketClient> openAIClients = new ConcurrentHashMap();
    private final Map<String, String> sessionStreamIds = new ConcurrentHashMap();
    private final Map<String, String> sessionCallSids = new ConcurrentHashMap();
    private final Map<String, StringBuilder> sessionTranscripts = new ConcurrentHashMap();

    public OpenAIRealtimeService(InboundCallService inboundCallService, TwilioSmsService twilioSmsService) {
        this.inboundCallService = inboundCallService;
        this.twilioSmsService = twilioSmsService;
    }

    public void connectToOpenAI(WebSocketSession twilioSession) {
        try {
            1 openAIClient = new /* Unavailable Anonymous Inner Class!! */;
            openAIClient.addHeader("Authorization", "Bearer " + this.openAiApiKey);
            openAIClient.addHeader("OpenAI-Beta", "realtime=v1");
            openAIClient.connect();
            this.openAIClients.put(twilioSession.getId(), openAIClient);
            this.sessionTranscripts.put(twilioSession.getId(), new StringBuilder("["));
        }
        catch (Exception e) {
            log.error("Failed to connect to OpenAI", (Throwable)e);
        }
    }

    private void sendSessionUpdate(WebSocketClient client) {
        try {
            ObjectNode sessionUpdate = this.objectMapper.createObjectNode();
            sessionUpdate.put("type", "session.update");
            ObjectNode session = this.objectMapper.createObjectNode();
            ObjectNode turnDetection = this.objectMapper.createObjectNode();
            turnDetection.put("type", "server_vad");
            session.set("turn_detection", (JsonNode)turnDetection);
            session.put("input_audio_format", "g711_ulaw");
            session.put("output_audio_format", "g711_ulaw");
            session.put("voice", VOICE);
            session.put("instructions", SYSTEM_MESSAGE);
            session.put("temperature", 0.8);
            session.putArray("modalities").add("text").add("audio");
            ArrayNode tools = session.putArray("tools");
            ObjectNode tool = tools.addObject();
            tool.put("type", "function");
            tool.put("name", "enregistrer_patient");
            tool.put("description", "Enregistre les informations du patient et son rendez-vous une fois toutes les donn\u00e9es collect\u00e9es et confirm\u00e9es");
            ObjectNode parameters = tool.putObject("parameters");
            parameters.put("type", "object");
            ObjectNode properties = parameters.putObject("properties");
            ObjectNode nom = properties.putObject("nom");
            nom.put("type", "string");
            nom.put("description", "Nom complet du patient");
            ObjectNode dateNaissance = properties.putObject("date_naissance");
            dateNaissance.put("type", "string");
            dateNaissance.put("description", "Date de naissance du patient au format JJ/MM/AAAA");
            ObjectNode telephone = properties.putObject("telephone");
            telephone.put("type", "string");
            telephone.put("description", "Num\u00e9ro de t\u00e9l\u00e9phone du patient");
            ObjectNode maladie = properties.putObject("maladie");
            maladie.put("type", "string");
            maladie.put("description", "Motif de consultation ou maladie du patient");
            ObjectNode motifVisite = properties.putObject("motif_visite");
            motifVisite.put("type", "string");
            motifVisite.put("description", "Motif d\u00e9taill\u00e9 de la visite ou consultation");
            ObjectNode appointmentDateTime = properties.putObject("appointment_date_time");
            appointmentDateTime.put("type", "string");
            appointmentDateTime.put("description", "Date et heure du rendez-vous au format ISO 8601 (YYYY-MM-DDTHH:MM:SS)");
            ObjectNode doctorName = properties.putObject("doctor_name");
            doctorName.put("type", "string");
            doctorName.put("description", "Nom complet du m\u00e9decin pour le rendez-vous");
            ObjectNode appointmentConfirmed = properties.putObject("appointment_confirmed");
            appointmentConfirmed.put("type", "boolean");
            appointmentConfirmed.put("description", "true si le rendez-vous est confirm\u00e9 par le patient, false sinon");
            ArrayNode required = parameters.putArray("required");
            required.add("nom");
            required.add("date_naissance");
            required.add("telephone");
            required.add("maladie");
            sessionUpdate.set("session", (JsonNode)session);
            String message = this.objectMapper.writeValueAsString((Object)sessionUpdate);
            log.debug("Sending session update: {}", (Object)message);
            client.send(message);
        }
        catch (Exception e) {
            log.error("Error sending session update", (Throwable)e);
        }
    }

    private void handleOpenAIMessage(WebSocketSession twilioSession, String message) {
        try {
            String transcript;
            JsonNode response = this.objectMapper.readTree(message);
            String type = response.get("type").asText();
            if (LOG_EVENT_TYPES.contains(type)) {
                log.debug("Received OpenAI event: {}", (Object)type);
            }
            if ("session.updated".equals(type)) {
                log.info("OpenAI session updated successfully");
            }
            if ("input_audio_buffer.committed".equals(type)) {
                log.info("Speech committed, triggering response generation");
                this.triggerResponseGeneration(twilioSession);
            }
            if ("response.audio.delta".equals(type) && response.has("delta")) {
                String audioDelta = response.get("delta").asText();
                log.debug("Received audio delta, sending to Twilio");
                this.sendAudioToTwilio(twilioSession, audioDelta);
            }
            if ("response.audio_transcript.done".equals(type) && response.has("transcript")) {
                transcript = response.get("transcript").asText();
                this.addToTranscript(twilioSession.getId(), "assistant", transcript);
            }
            if ("conversation.item.input_audio_transcription.completed".equals(type) && response.has("transcript")) {
                transcript = response.get("transcript").asText();
                this.addToTranscript(twilioSession.getId(), "user", transcript);
            }
            if ("response.function_call_arguments.done".equals(type)) {
                this.handleFunctionCall(response, twilioSession.getId());
            }
        }
        catch (Exception e) {
            log.error("Error processing OpenAI message", (Throwable)e);
        }
    }

    private void handleFunctionCall(JsonNode response, String sessionId) {
        block10: {
            try {
                Iterator iterator;
                String callSid;
                String functionName = response.get("name").asText();
                String arguments = response.get("arguments").asText();
                String string = callSid = response.get("call_sid") != null ? response.get("call_sid").asText() : null;
                if (!"enregistrer_patient".equals(functionName)) break block10;
                JsonNode patientData = this.objectMapper.readTree(arguments);
                log.info("========================================");
                log.info("\ud83d\udccb DONN\u00c9ES PATIENT EXTRAITES :");
                log.info("========================================");
                log.info("\ud83d\udc64 Nom : {}", (Object)(patientData.has("nom") ? patientData.get("nom").asText() : "N/A"));
                log.info("\ud83c\udf82 Date de naissance : {}", (Object)(patientData.has("date_naissance") ? patientData.get("date_naissance").asText() : "N/A"));
                log.info("\ud83d\udcde T\u00e9l\u00e9phone : {}", (Object)(patientData.has("telephone") ? patientData.get("telephone").asText() : "N/A"));
                log.info("\ud83c\udfe5 Maladie/Motif : {}", (Object)(patientData.has("maladie") ? patientData.get("maladie").asText() : "N/A"));
                log.info("\ud83d\udcdd Motif visite : {}", (Object)(patientData.has("motif_visite") ? patientData.get("motif_visite").asText() : "N/A"));
                log.info("\ud83d\udcc5 RDV Date/Heure : {}", (Object)(patientData.has("appointment_date_time") ? patientData.get("appointment_date_time").asText() : "N/A"));
                log.info("\ud83d\udc68\u200d\u2695\ufe0f M\u00e9decin : {}", (Object)(patientData.has("doctor_name") ? patientData.get("doctor_name").asText() : "N/A"));
                log.info("\u2705 RDV Confirm\u00e9 : {}", patientData.has("appointment_confirmed") ? Boolean.valueOf(patientData.get("appointment_confirmed").asBoolean()) : "N/A");
                log.info("========================================");
                String resolvedCallSid = callSid;
                if (resolvedCallSid == null && (iterator = this.sessionCallSids.entrySet().iterator()).hasNext()) {
                    Map.Entry entry = iterator.next();
                    resolvedCallSid = (String)entry.getValue();
                }
                if (resolvedCallSid != null) {
                    LocalDateTime appointmentDateTime = null;
                    if (patientData.has("appointment_date_time")) {
                        try {
                            String dateTimeStr = patientData.get("appointment_date_time").asText();
                            appointmentDateTime = LocalDateTime.parse(dateTimeStr);
                        }
                        catch (Exception e) {
                            log.warn("Failed to parse appointment date/time: {}", (Object)patientData.get("appointment_date_time").asText());
                        }
                    }
                    InboundCallRequest request = InboundCallRequest.builder().callSid(resolvedCallSid).nom(patientData.has("nom") ? patientData.get("nom").asText() : null).dateNaissance(patientData.has("date_naissance") ? patientData.get("date_naissance").asText() : null).telephone(patientData.has("telephone") ? patientData.get("telephone").asText() : null).maladie(patientData.has("maladie") ? patientData.get("maladie").asText() : null).motifVisite(patientData.has("motif_visite") ? patientData.get("motif_visite").asText() : null).appointmentDateTime(appointmentDateTime).doctorName(patientData.has("doctor_name") ? patientData.get("doctor_name").asText() : null).appointmentConfirmed(Boolean.valueOf(patientData.has("appointment_confirmed") ? patientData.get("appointment_confirmed").asBoolean() : false)).smsSent(Boolean.valueOf(false)).build();
                    InboundCallRequest savedRequest = this.inboundCallService.savePatientRequest(request);
                    String transcript = this.getConversationTranscript(sessionId);
                    if (transcript != null && !transcript.isEmpty()) {
                        savedRequest.setConversationTranscript(transcript);
                        savedRequest = this.inboundCallService.savePatientRequest(savedRequest);
                        log.info("\ud83d\udcdd Transcription de conversation sauvegard\u00e9e");
                    }
                    if (Boolean.TRUE.equals(savedRequest.getAppointmentConfirmed()) && savedRequest.getAppointmentDateTime() != null && savedRequest.getTelephone() != null && savedRequest.getDoctorName() != null) {
                        log.info("\ud83d\udcf1 Envoi du SMS de confirmation de RDV...");
                        String statusCallbackUrl = this.serverBaseUrl + "/api/voip/sms/status-callback";
                        String smsSid = this.twilioSmsService.sendAppointmentConfirmationSms(savedRequest.getTelephone(), savedRequest.getNom(), savedRequest.getDoctorName(), savedRequest.getAppointmentDateTime(), statusCallbackUrl);
                        if (smsSid != null) {
                            savedRequest.setSmsSent(Boolean.valueOf(true));
                            savedRequest.setSmsSid(smsSid);
                            savedRequest.setSmsStatus("queued");
                            this.inboundCallService.savePatientRequest(savedRequest);
                            log.info("\u2705 SMS de confirmation envoy\u00e9 et marqu\u00e9 dans la base de donn\u00e9es (SID: {})", (Object)smsSid);
                        }
                    }
                    break block10;
                }
                log.warn("No callSid found to save patient request");
            }
            catch (Exception e) {
                log.error("Error handling function call", (Throwable)e);
            }
        }
    }

    private void triggerResponseGeneration(WebSocketSession twilioSession) {
        WebSocketClient client = (WebSocketClient)this.openAIClients.get(twilioSession.getId());
        if (client != null && client.isOpen()) {
            try {
                ObjectNode responseCreate = this.objectMapper.createObjectNode();
                responseCreate.put("type", "response.create");
                ObjectNode responseConfig = this.objectMapper.createObjectNode();
                responseConfig.putArray("modalities").add("text").add("audio");
                responseCreate.set("response", (JsonNode)responseConfig);
                String message = this.objectMapper.writeValueAsString((Object)responseCreate);
                log.debug("Sending response.create: {}", (Object)message);
                client.send(message);
            }
            catch (Exception e) {
                log.error("Error triggering response generation", (Throwable)e);
            }
        }
    }

    public void sendAudioToOpenAI(WebSocketSession twilioSession, String audioPayload) {
        WebSocketClient client = (WebSocketClient)this.openAIClients.get(twilioSession.getId());
        if (client != null && client.isOpen()) {
            try {
                ObjectNode audioAppend = this.objectMapper.createObjectNode();
                audioAppend.put("type", "input_audio_buffer.append");
                audioAppend.put("audio", audioPayload);
                client.send(this.objectMapper.writeValueAsString((Object)audioAppend));
            }
            catch (Exception e) {
                log.error("Error sending audio to OpenAI", (Throwable)e);
            }
        }
    }

    private void sendAudioToTwilio(WebSocketSession twilioSession, String audioDelta) {
        try {
            if (twilioSession.isOpen()) {
                String streamSid = (String)this.sessionStreamIds.get(twilioSession.getId());
                if (streamSid == null) {
                    log.warn("No streamSid found for session {}, skipping audio", (Object)twilioSession.getId());
                    return;
                }
                ObjectNode audioDeltaMessage = this.objectMapper.createObjectNode();
                audioDeltaMessage.put("event", "media");
                audioDeltaMessage.put("streamSid", streamSid);
                ObjectNode media = this.objectMapper.createObjectNode();
                media.put("payload", audioDelta);
                audioDeltaMessage.set("media", (JsonNode)media);
                String message = this.objectMapper.writeValueAsString((Object)audioDeltaMessage);
                log.trace("Sending to Twilio: {}", (Object)message);
                twilioSession.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message));
            }
        }
        catch (Exception e) {
            log.error("Error sending audio to Twilio", (Throwable)e);
        }
    }

    public void setStreamSid(String sessionId, String streamSid) {
        this.sessionStreamIds.put(sessionId, streamSid);
        log.info("Set streamSid {} for session {}", (Object)streamSid, (Object)sessionId);
    }

    public void setCallSid(String sessionId, String callSid) {
        this.sessionCallSids.put(sessionId, callSid);
        log.info("Set callSid {} for session {}", (Object)callSid, (Object)sessionId);
    }

    public void setCallSidForSession(String sessionId, String callSid) {
        this.setCallSid(sessionId, callSid);
    }

    public void closeConnection(WebSocketSession session) {
        this.disconnectFromOpenAI(session);
    }

    public void disconnectFromOpenAI(WebSocketSession twilioSession) {
        WebSocketClient client = (WebSocketClient)this.openAIClients.remove(twilioSession.getId());
        this.sessionStreamIds.remove(twilioSession.getId());
        this.sessionCallSids.remove(twilioSession.getId());
        this.sessionTranscripts.remove(twilioSession.getId());
        if (client != null && client.isOpen()) {
            client.close();
            log.info("Closed OpenAI connection for session: {}", (Object)twilioSession.getId());
        }
    }

    private void addToTranscript(String sessionId, String role, String content) {
        StringBuilder transcript = (StringBuilder)this.sessionTranscripts.get(sessionId);
        if (transcript != null) {
            try {
                if (transcript.length() > 1) {
                    transcript.append(",");
                }
                ObjectNode message = this.objectMapper.createObjectNode();
                message.put("role", role);
                message.put("content", content);
                message.put("timestamp", LocalDateTime.now().toString());
                transcript.append(this.objectMapper.writeValueAsString((Object)message));
            }
            catch (Exception e) {
                log.error("Error adding to transcript", (Throwable)e);
            }
        }
    }

    private String getConversationTranscript(String sessionId) {
        StringBuilder transcript = (StringBuilder)this.sessionTranscripts.get(sessionId);
        if (transcript != null && transcript.length() > 1) {
            return transcript.toString() + "]";
        }
        return null;
    }
}

