/*
 * Decompiled with CFR 0.152.
 */
package com.saas.voip.service;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TelnyxSmsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TelnyxSmsService.class);
    private final RestTemplate restTemplate = new RestTemplate();
    @Value(value="${telnyx.api.key:}")
    private String telnyxApiKey;
    @Value(value="${telnyx.messaging.profile.id:}")
    private String messagingProfileId;
    private static final String TELNYX_SMS_API = "https://api.telnyx.com/v2/messages";

    public String sendAppointmentConfirmationSms(String fromPhoneNumber, String toPhoneNumber, String patientName, String doctorName, LocalDateTime appointmentDateTime, String statusCallbackUrl) {
        try {
            if (appointmentDateTime == null) {
                log.warn("\u26a0\ufe0f Appointment date/time is null, cannot send SMS to {}", (Object)toPhoneNumber);
                return null;
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEEE dd MMMM yyyy '\u00e0' HH'h'mm", Locale.FRENCH);
            String formattedDateTime = appointmentDateTime.format(formatter);
            String messageBody = String.format("\u2705 Confirmation de rendez-vous - Clinique La Rive Bleue\n\nBonjour %s,\n\nVotre rendez-vous avec %s est confirm\u00e9 pour le %s.\n\nMerci de votre confiance.\n\nClinique La Rive Bleue", patientName, doctorName, formattedDateTime);
            return this.sendSms(fromPhoneNumber, toPhoneNumber, messageBody, statusCallbackUrl);
        }
        catch (Exception e) {
            log.error("\u274c Erreur lors de l'envoi du SMS Telnyx \u00e0 {}: {}", new Object[]{toPhoneNumber, e.getMessage(), e});
            return null;
        }
    }

    public boolean sendCustomSms(String fromPhoneNumber, String toPhoneNumber, String messageBody) {
        try {
            String messageSid = this.sendSms(fromPhoneNumber, toPhoneNumber, messageBody, null);
            return messageSid != null;
        }
        catch (Exception e) {
            log.error("\u274c Erreur lors de l'envoi du SMS personnalis\u00e9 Telnyx: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private String sendSms(String fromPhoneNumber, String toPhoneNumber, String text, String webhookUrl) {
        try {
            HashMap<String, String> payload = new HashMap<String, String>();
            payload.put("from", fromPhoneNumber);
            payload.put("to", toPhoneNumber);
            payload.put("text", text);
            if (this.messagingProfileId != null && !this.messagingProfileId.isEmpty()) {
                payload.put("messaging_profile_id", this.messagingProfileId);
            }
            if (webhookUrl != null && !webhookUrl.isEmpty()) {
                payload.put("webhook_url", webhookUrl);
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(this.telnyxApiKey);
            HttpEntity request = new HttpEntity(payload, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(TELNYX_SMS_API, HttpMethod.POST, request, Map.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                Map data = (Map)((Map)response.getBody()).get("data");
                String messageId = data != null ? (String)data.get("id") : null;
                log.info("\ud83d\udce8 SMS Telnyx envoy\u00e9 avec succ\u00e8s ! ID: {} | Destinataire: {}", (Object)messageId, (Object)toPhoneNumber);
                return messageId;
            }
            log.error("\u274c \u00c9chec envoi SMS Telnyx. Status: {}", (Object)response.getStatusCode());
            return null;
        }
        catch (Exception e) {
            log.error("\u274c Erreur lors de l'envoi du SMS Telnyx: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @Generated
    public TelnyxSmsService() {
    }
}

