# 🚀 Quick Start Docker - 3 Minutes

Guide ultra-rapide pour démarrer votre API en 3 minutes avec Docker.

## 📝 Étape 1: Créer le fichier .env (2 min)

```bash
cp .env.example .env
```

Éditez `.env` et remplissez AU MINIMUM ces 3 valeurs:

```bash
# 1. MySQL Password (créez un mot de passe fort)
MYSQL_PASSWORD=VotreMotDePasseMySQL123!

# 2. JWT Secret (générez avec: openssl rand -base64 64)
SESSION_SECRET=votre_secret_jwt_genere_ici

# 3. OpenAI API Key (si vous testez les voicebots)
OPENAI_API_KEY=sk-proj-votre-cle-openai
```

**Les autres variables peuvent rester vides pour un test local.**

## 🐳 Étape 2: Démarrer Docker (1 min)

```bash
docker-compose up -d --build
```

Attendez 60 secondes que tout démarre...

## ✅ Étape 3: Vérifier que ça marche (30 sec)

```bash
# Vérifier le statut
docker-compose ps

# Tester l'API
curl http://localhost:8000/actuator/health

# Accéder à Swagger (dans votre navigateur)
open http://localhost:8000/swagger-ui.html
```

Si vous voyez `{"status":"UP"}`, **félicitations ! 🎉**

## 📊 Voir les logs

```bash
# Logs en temps réel
docker-compose logs -f api

# Logs MySQL
docker-compose logs -f mysql
```

## 🛑 Arrêter

```bash
# Arrêter les conteneurs
docker-compose down

# Arrêter ET supprimer les données (⚠️ efface la DB)
docker-compose down -v
```

## 🆘 Problèmes?

```bash
# Tout reconstruire depuis zéro
docker-compose down -v
docker-compose up -d --build --force-recreate

# Voir les logs détaillés
docker-compose logs
```

---

**C'est tout ! Consultez [DOCKER_README.md](./DOCKER_README.md) pour le guide complet.**
