# Guide de Configuration Ziwo.io

Ce guide vous explique comment configurer **Ziwo.io** comme 3ème provider VoIP dans votre application SaaS Spring Boot, aux côtés de Twilio et Telnyx.

---

## 📋 Prérequis

1. ✅ **Compte Ziwo** : Contactez les ventes Ziwo pour obtenir un compte
2. ✅ **Instance Ziwo** : Nom de votre instance (ex: `your-company`)
3. ✅ **API Key** : Clé API générée dans le dashboard Ziwo
4. ✅ **Numéro de téléphone** : Au moins un numéro attribué dans Ziwo
5. ✅ **AI Agent configuré** : Assistant IA créé dans le workflow builder

---

## 🔧 Étape 1 : Configuration Compte Ziwo

### A. Accéder au Dashboard Ziwo

1. Connectez-vous à : `https://your-company.ziwo.io`
2. Remplacez `your-company` par le nom de votre instance

### B. Générer une API Key

1. Dans le dashboard, allez dans **Settings** → **API Keys**
2. Cliquez sur **Generate New API Key**
3. Copiez la clé générée (format: `ziwo_key_xxxxxxxxxxxxx`)
4. **Important** : Conservez cette clé en sécurité

### C. Obtenir votre Instance Name

Votre instance name est le préfixe de votre URL Ziwo :
- URL: `https://acme-corp.ziwo.io`
- Instance Name: `acme-corp`

---

## 🤖 Étape 2 : Créer un AI Voice Agent

### A. Accéder au Workflow Builder

1. Dans le dashboard, allez dans **IVR/Workflows**
2. Cliquez sur **Create New Workflow**
3. Nommez-le "Medical Appointment Assistant"

### B. Configurer l'AI Agent

**1. Prompt de l'Agent (en français)**

```
Vous êtes un assistant téléphonique de la Clinique La Rive Bleue.
Votre rôle est d'aider les patients à prendre rendez-vous avec nos médecins.

Instructions :
1. Accueillez poliment le patient
2. Demandez son nom complet
3. Demandez son numéro de téléphone
4. Demandez sa date de naissance
5. Demandez la raison de sa visite (maladie/symptômes)
6. Proposez un choix de médecins : Dr. Sophie Martin, Dr. Jean Dupont, Dr. Marie Leblanc
7. Proposez des dates et heures de rendez-vous disponibles
8. Confirmez le rendez-vous avec le patient
9. Remerciez et terminez l'appel

Soyez toujours courtois, professionnel et empathique.
```

**2. Variables à Collecter**

Configurez ces variables dans le workflow :

| Variable | Type | Question |
|----------|------|----------|
| `patient_name` | String | "Quel est votre nom complet ?" |
| `patient_phone` | Phone | "Quel est votre numéro de téléphone ?" |
| `patient_birthdate` | Date | "Quelle est votre date de naissance ?" |
| `illness` | Text | "Quelle est la raison de votre visite ?" |
| `doctor_choice` | Choice | "Quel médecin souhaitez-vous consulter ?" |
| `appointment_date` | Date | "Quelle date vous convient ?" |
| `appointment_time` | Time | "Quelle heure préférez-vous ?" |
| `confirmation` | Boolean | "Confirmez-vous ce rendez-vous ?" |

**3. Options pour doctor_choice**

```
- Dr. Sophie Martin
- Dr. Jean Dupont
- Dr. Marie Leblanc
```

### C. Configurer les Webhooks

**1. Webhook d'Appel Entrant**

- **URL** : `https://your-domain.com/api/voip/ziwo/incoming-call`
- **Méthode** : POST
- **Event** : `call.initiated`

**2. Webhook d'Événements**

- **URL** : `https://your-domain.com/api/voip/ziwo/events`
- **Méthode** : POST
- **Events** :
  - `call.answered`
  - `call.completed`
  - `variables.collected`

**3. Webhook SMS**

- **URL** : `https://your-domain.com/api/voip/ziwo/sms/status-callback`
- **Méthode** : POST
- **Event** : `message.status`

---

## ⚙️ Étape 3 : Configuration dans votre Application

### A. Variables d'Environnement

Créez un fichier `.env` (ou modifiez l'existant) :

```bash
# Ziwo Configuration
ZIWO_INSTANCE_NAME=your-company-name
ZIWO_API_KEY=ziwo_key_xxxxxxxxxxxxx
```

**Remplacez :**
- `your-company-name` par votre instance name
- `ziwo_key_xxxxxxxxxxxxx` par votre vraie API key

### B. Vérifier application.properties

Assurez-vous que ces propriétés sont dans `src/main/resources/application.properties` :

```properties
# Ziwo Configuration
ziwo.instance.name=${ZIWO_INSTANCE_NAME}
ziwo.api.key=${ZIWO_API_KEY}
```

---

## 📞 Étape 4 : Ajouter un Numéro de Téléphone

### A. Acheter/Configurer un Numéro dans Ziwo

1. Dans le dashboard Ziwo, allez dans **Numbers**
2. Achetez un numéro local (ex: +33 pour France)
3. Assignez-le au workflow "Medical Appointment Assistant"

### B. Enregistrer le Numéro dans votre Base de Données

**Via API REST (avec JWT Token)** :

```bash
curl -X POST https://your-domain.com/api/admin/phone-numbers \
  -H "Content-Type: application/json" \
  -H "access_token: YOUR_JWT_TOKEN" \
  -d '{
    "phoneNumber": "+33987654321",
    "provider": "ZIWO",
    "tenantId": 1,
    "label": "Numéro Ziwo Principal",
    "isActive": true
  }'
```

**Via SQL (pour test)** :

```sql
INSERT INTO phone_numbers (phone_number, provider, tenant_id, label, is_active, created_at, updated_at)
VALUES ('+33987654321', 'ZIWO', 1, 'Numéro Ziwo Principal', true, NOW(), NOW());
```

---

## 🧪 Étape 5 : Tester l'Intégration

### A. Démarrer l'Application

```bash
mvn spring-boot:run
```

### B. Tester un Appel Entrant

1. **Appelez votre numéro Ziwo** : Composez le numéro configuré
2. **L'AI Agent répond** : Suivez le scénario de prise de rendez-vous
3. **Vérifier les logs** :

```bash
tail -f logs/application.log | grep Ziwo
```

Vous devriez voir :

```
Received Ziwo incoming call webhook
Set tenant context for Ziwo call: tenant_xxx
Saved Ziwo inbound call data: ziwo_123456
Received Ziwo event webhook: variables.collected
Saved Ziwo inbound call request for callId: ziwo_123456
Sending Ziwo SMS confirmation to: +33612345678
```

### C. Vérifier les Données dans la Base

**Appel entrant** :

```sql
SELECT * FROM inbound_call_data 
WHERE call_sid LIKE 'ziwo_%' 
ORDER BY created_at DESC 
LIMIT 1;
```

**Rendez-vous créé** :

```sql
SELECT * FROM inbound_call_request 
WHERE call_sid LIKE 'ziwo_%' 
ORDER BY created_at DESC 
LIMIT 1;
```

**SMS envoyé** :

```sql
SELECT nom, telephone, doctor_name, appointment_date_time, sms_sent, sms_status
FROM inbound_call_request 
WHERE sms_sent = true 
ORDER BY created_at DESC 
LIMIT 5;
```

---

## 🔍 Étape 6 : Monitoring et Logs

### A. Vérifier les Webhooks dans Ziwo

1. Dashboard Ziwo → **Webhooks**
2. Vérifiez que tous les événements sont bien envoyés
3. Vérifiez les codes de réponse (200 OK = succès)

### B. Logs Applicatifs

**Voir tous les logs Ziwo** :

```bash
grep "Ziwo" logs/application.log
```

**Voir les erreurs Ziwo** :

```bash
grep "ERROR.*Ziwo" logs/application.log
```

### C. Dashboard Ziwo Analytics

Ziwo fournit des dashboards intégrés avec 40+ KPIs :
- Nombre d'appels (total, répondus, manqués)
- Durée moyenne des appels
- Taux de conversion (rendez-vous confirmés)
- Qualité audio
- Transcripts des conversations

---

## 🎯 Comparaison des 3 Providers

| Aspect | Twilio | Telnyx | **Ziwo** |
|--------|--------|--------|----------|
| **AI Setup** | Code complexe | Config webhook | **Dashboard UI** ✅ |
| **Coût estimé** | $0.30/min | $0.012/min | **À confirmer** |
| **Enregistrement** | Via API | Via API | **Auto inclus** ✅ |
| **Transcript** | Manual | API | **Auto inclus** ✅ |
| **Analytics** | Custom code | Custom code | **40+ KPIs natifs** ✅ |
| **Configuration** | Code WebSocket | Config webhook | **Workflow builder** ✅ |

---

## 🐛 Troubleshooting

### Problème 1 : Webhook non reçu

**Symptômes** :
```
No logs in application when calling Ziwo number
```

**Solutions** :
1. ✅ Vérifiez que l'URL webhook est accessible publiquement
2. ✅ Vérifiez que le port est ouvert (ex: ngrok si local)
3. ✅ Dans Ziwo dashboard, testez manuellement le webhook
4. ✅ Vérifiez les logs Ziwo pour voir les erreurs HTTP

### Problème 2 : Tenant non trouvé

**Symptômes** :
```
ERROR: No phone number found for Ziwo number: +33987654321
```

**Solutions** :
1. ✅ Vérifiez que le numéro existe dans `phone_numbers` table
2. ✅ Vérifiez que `provider = 'ZIWO'` (pas 'ziwo' ou 'Ziwo')
3. ✅ Vérifiez que le `tenantId` existe dans `tenants` table

```sql
SELECT * FROM phone_numbers WHERE provider = 'ZIWO';
SELECT * FROM tenants WHERE id = 1;
```

### Problème 3 : Variables non extraites

**Symptômes** :
```
Saved Ziwo inbound call request but all fields are null
```

**Solutions** :
1. ✅ Vérifiez que les variables sont bien configurées dans le workflow Ziwo
2. ✅ Vérifiez que les noms correspondent exactement :
   - `patient_name` (pas `patientName` ou `name`)
   - `patient_phone` (pas `phone` ou `telephone`)
3. ✅ Testez l'appel et vérifiez le payload webhook dans les logs

### Problème 4 : SMS non envoyé

**Symptômes** :
```
ERROR: Failed to send Ziwo SMS confirmation
```

**Solutions** :
1. ✅ Vérifiez que `ZIWO_API_KEY` est configurée
2. ✅ Vérifiez que le numéro émetteur est activé pour SMS dans Ziwo
3. ✅ Vérifiez le format du numéro (international : +33...)
4. ✅ Vérifiez votre crédit Ziwo (téléphonie pay-as-you-go)

---

## 📊 Endpoints API Disponibles

### Webhooks (Public)

| Endpoint | Méthode | Description |
|----------|---------|-------------|
| `/api/voip/ziwo/incoming-call` | POST | Appel entrant |
| `/api/voip/ziwo/events` | POST | Événements AI |
| `/api/voip/ziwo/sms/status-callback` | POST | Status SMS |
| `/api/voip/ziwo/health` | GET | Health check |

### Admin Endpoints (JWT Required)

| Endpoint | Méthode | Description |
|----------|---------|-------------|
| `/api/admin/phone-numbers` | GET | Liste numéros |
| `/api/admin/phone-numbers` | POST | Ajouter numéro |
| `/api/admin/phone-numbers/{id}` | PUT | Modifier numéro |
| `/api/admin/phone-numbers/{id}` | DELETE | Supprimer numéro |

---

## 💡 Bonnes Pratiques

### 1. Sécurité

✅ **Ne jamais exposer l'API Key** dans le code ou les logs  
✅ **Utiliser HTTPS** pour tous les webhooks  
✅ **Valider les webhooks** avec une signature si Ziwo le supporte  
✅ **Limiter les accès** aux endpoints admin avec JWT

### 2. Performance

✅ **Traiter les webhooks rapidement** (< 3 secondes)  
✅ **Utiliser des workers asynchrones** pour les traitements longs  
✅ **Mettre en cache** les lookups de tenant/phone number  
✅ **Logger les erreurs** mais pas les données sensibles

### 3. Multi-Tenant

✅ **Toujours identifier le tenant** via le numéro appelé  
✅ **Utiliser TenantContext** pour switcher de schéma  
✅ **Clear TenantContext** après chaque opération  
✅ **Tester avec plusieurs tenants** pour éviter les fuites

---

## 🚀 Prochaines Étapes

Une fois Ziwo configuré, vous pouvez :

1. ✅ **Comparer les coûts** : Twilio vs Telnyx vs Ziwo
2. ✅ **Tester la qualité AI** : Quel provider a le meilleur voicebot ?
3. ✅ **Analyser les performances** : Dashboards Ziwo vs custom code
4. ✅ **Router intelligemment** : Certains tenants sur Ziwo, d'autres sur Telnyx
5. ✅ **Optimiser** : Choisir le meilleur provider pour production

---

## 📞 Support Ziwo

- **Documentation API** : https://api.ziwo.io/
- **Support 24/7** : Via dashboard Ziwo
- **Email** : support@ziwo.io
- **Status Page** : https://status.ziwo.io/

---

## ✅ Checklist de Configuration

- [ ] Compte Ziwo créé et accès dashboard
- [ ] API Key générée et sauvegardée
- [ ] Instance name noté
- [ ] Workflow "Medical Appointment Assistant" créé
- [ ] AI Agent configuré avec prompt français
- [ ] Variables collectées configurées (8 variables)
- [ ] Webhooks configurés (3 endpoints)
- [ ] Numéro de téléphone acheté dans Ziwo
- [ ] Numéro assigné au workflow
- [ ] Variables d'environnement ajoutées (.env)
- [ ] Numéro enregistré dans la base de données
- [ ] Application démarrée sans erreur
- [ ] Appel test effectué et fonctionnel
- [ ] Données sauvegardées dans DB vérifiées
- [ ] SMS de confirmation reçu
- [ ] Logs vérifiés (pas d'erreurs)
- [ ] Dashboard Ziwo analytics vérifié

---

**Félicitations ! 🎉 Votre intégration Ziwo est maintenant complète et opérationnelle !**
