# 🎯 Guide : Configurer Webhook call.hangup Telnyx

## ❌ ERREUR COMMUNE

Le webhook `call.hangup` ne se configure **PAS** dans un menu "Webhooks" séparé.

Il se configure **dans votre Voice Application** (Programmable Voice).

---

## ✅ Configuration Étape par Étape

### Étape 1 : Accéder à Votre Voice Application

1. Connectez-vous au **Telnyx Mission Control Portal** : https://portal.telnyx.com/
2. Menu de gauche → **Voice** → **Programmable Voice**
3. Vous devriez voir votre **TeXML Application** existante
4. Cliquez sur votre application pour **l'éditer**

---

### Étape 2 : Configurer le Webhook URL

Dans les paramètres de votre Voice Application, cherchez la section **"Webhook"** ou **"Events"**.

Configurez :

```
Webhook URL: https://benedictory-provocative-lauralee.ngrok-free.dev/api/voip/telnyx/call-ended

Webhook API Version: v2 (recommandé)

Webhook Timeout: 25 secondes (optionnel)

Failover URL: (optionnel - laissez vide)
```

**IMPORTANT** : Ce webhook URL recevra **TOUS** les événements de votre Voice Application, incluant :
- `call.initiated`
- `call.answered`
- `call.hangup` ← **Celui qu'on veut !**
- etc.

---

### Étape 3 : Sauvegarder

Cliquez **"Save"** ou **"Update Application"**

---

### Étape 4 : Tester

1. Passez un appel Telnyx test
2. Attendez que l'appel se termine
3. Vérifiez vos logs Spring Boot :

```bash
tail -f logs/spring-boot.log | grep "TELNYX CALL ENDED"
```

**Logs attendus** :
```
╔═══════════════════════════════════════════════════════╗
║     TELNYX CALL ENDED WEBHOOK RECEIVED               ║
╚═══════════════════════════════════════════════════════╝
✅ [TelnyxCostService] Telnyx API Key configured
🔍 [TelnyxCostService] Calling Telnyx Detail Records API
💰 [TelnyxCostService] Cost set: 0.0075 USD
✅ [TelnyxCostService] Telnyx call cost saved to ADMIN database
```

---

## 🔧 Pourquoi `TelnyxCallEndController` Existe

Le code Java a **2 endpoints Telnyx** :

| Endpoint | Déclencheur | Objectif |
|----------|-------------|----------|
| `/api/voip/telnyx/texml-response` | **Appel entrant initial** (configuré sur le numéro) | Générer TeXML pour router l'appel |
| `/api/voip/telnyx/call-ended` | **Webhook `call.hangup`** (configuré dans Voice App) | Récupérer coût via API Detail Records |

**Actuellement** : Seul le premier est configuré ✅  
**Manquant** : Le second (webhook call.hangup) ❌

---

## 🎯 Workflow Complet Après Configuration

```
1. Appel arrive → +18066983980
   ↓
2. Telnyx appelle /api/voip/telnyx/texml-response
   ↓
3. API renvoie TeXML avec <Connect><AIAssistant>
   ↓
4. Conversation avec AI Assistant
   ↓
5. Appel se termine (hangup)
   ↓
6. Telnyx envoie webhook call.hangup → /api/voip/telnyx/call-ended
   ↓
7. TelnyxCallEndController reçoit l'event
   ↓
8. Identifie tenant_id via phone_numbers table
   ↓
9. TelnyxCostService appelle API Detail Records
   ↓
10. Attend 2-5 minutes pour CDR
   ↓
11. Récupère cost, duration, timestamps
   ↓
12. Sauvegarde dans saas_db.call_cost_records
   ↓
13. ✅ TERMINÉ
```

---

## 🧪 Test Manuel (Sans Configurer Webhook)

En attendant de configurer le webhook, testez manuellement :

```bash
# Attendez 2-5 minutes après la fin d'un appel, puis :

curl -X POST http://localhost:7001/api/voip/telnyx/call-ended \
  -H "Content-Type: application/json" \
  -d '{
    "data": {
      "payload": {
        "event_type": "call.hangup",
        "call_session_id": "v3:NZ0QV9MIY6uIBuF6ZGHGcVduQszYE7YsyiRb_psWkb2UOOPZusKd2w",
        "from": "+212661979197",
        "to": "+18066983980",
        "state": "hangup"
      }
    }
  }'
```

**Vérifiez ensuite la base** :
```sql
SELECT * FROM saas_db.call_cost_records 
WHERE provider = 'TELNYX' 
ORDER BY created_at DESC;
```

---

## 📸 Capture d'Écran Approximative

```
┌──────────────────────────────────────────────────────────┐
│ Telnyx Mission Control                                   │
├──────────────────────────────────────────────────────────┤
│ Menu:                                                     │
│   ├─ Numbers                                             │
│   ├─ Voice                                               │
│   │    ├─ Programmable Voice  ← CLIQUEZ ICI             │
│   │    └─ SIP Trunking                                   │
│   └─ Messaging                                           │
└──────────────────────────────────────────────────────────┘

Puis dans Programmable Voice :

┌──────────────────────────────────────────────────────────┐
│ Voice Applications                                        │
├──────────────────────────────────────────────────────────┤
│ Name: "My TeXML App"                                     │
│ Type: TeXML                                              │
│ Status: Active                                           │
│                                                           │
│ [Edit] ← CLIQUEZ POUR ÉDITER                            │
└──────────────────────────────────────────────────────────┘

Dans l'éditeur :

┌──────────────────────────────────────────────────────────┐
│ Edit Voice Application                                   │
├──────────────────────────────────────────────────────────┤
│ Webhook Configuration:                                    │
│                                                           │
│ Webhook URL: [https://votre-ngrok.dev/api/voip/...]     │
│                                                           │
│ Failover URL: [optionnel]                               │
│                                                           │
│ API Version: [ v2 ▼ ]                                    │
│                                                           │
│ Timeout: [ 25 ] seconds                                  │
│                                                           │
│ [Save Changes]                                           │
└──────────────────────────────────────────────────────────┘
```

---

## ✅ Checklist Finale

- [ ] Aller sur Telnyx Portal → Voice → Programmable Voice
- [ ] Éditer votre Voice Application (TeXML)
- [ ] Configurer Webhook URL: `https://votre-ngrok.dev/api/voip/telnyx/call-ended`
- [ ] Sauvegarder
- [ ] Passer un appel test
- [ ] Vérifier logs : `grep "TELNYX CALL ENDED" logs/*.log`
- [ ] Vérifier DB : `SELECT * FROM saas_db.call_cost_records`

---

**Note** : Si votre Voice Application utilise déjà un webhook URL pour autre chose, contactez-moi. On peut faire en sorte que `/api/voip/telnyx/call-ended` gère TOUS les événements et route selon `event_type`. 🚀
