# 🎙️ VoIP Package - Twilio + OpenAI Realtime Voice Bot

## 📋 Description

Ce package implémente un voicebot intelligent utilisant **Twilio** pour la téléphonie et **OpenAI Realtime API** pour les conversations en temps réel avec intelligence artificielle.

## 🏗️ Architecture

```
com.saas.voip/
├── config/
│   └── WebSocketConfig.java          # Configuration WebSocket
├── controller/
│   └── TwilioVoiceController.java    # Endpoints REST pour Twilio
├── handler/
│   └── TwilioMediaStreamHandler.java # Gestion des streams média WebSocket
└── service/
    └── OpenAIRealtimeService.java    # Service OpenAI Realtime API
```

## 🚀 Fonctionnalités

- ✅ **Appels entrants Twilio** : Gestion des appels via TwiML
- ✅ **WebSocket bidirectionnel** : Stream audio en temps réel
- ✅ **OpenAI Realtime API** : IA conversationnelle vocale
- ✅ **Audio G.711 μ-law** : Format compatible Twilio
- ✅ **Assistant médical** : Prise de rendez-vous intelligente
- ✅ **Français natif** : Réponses en français

## 📡 Endpoints

### REST Endpoints

| Method | URL | Description |
|--------|-----|-------------|
| GET/POST | `/api/voip/incoming-call` | Webhook Twilio pour appels entrants |
| GET | `/api/voip/health` | Health check du service VoIP |

### WebSocket Endpoint

| URL | Protocol | Description |
|-----|----------|-------------|
| `/media-stream` | WS/WSS | Stream audio bidirectionnel Twilio ↔ OpenAI |

## ⚙️ Configuration

### 1. Variables d'environnement requises

```bash
# OpenAI
OPENAI_API_KEY=sk-proj-xxxxx

# Twilio (optionnel si vous utilisez l'intégration Replit)
TWILIO_ACCOUNT_SID=ACxxxxx
TWILIO_AUTH_TOKEN=xxxxx
TWILIO_PHONE_NUMBER=+33xxxxxxxxx
```

### 2. Configuration Twilio

1. **Créez un numéro Twilio** : https://console.twilio.com/
2. **Configurez le webhook** :
   - Voice & Fax → Configure
   - A CALL COMES IN → Webhook
   - URL: `https://your-domain.com/api/voip/incoming-call`
   - Method: `HTTP POST`

### 3. Configuration du système

Dans `application.yml`, les paramètres sont déjà configurés :

```yaml
openai:
  api:
    key: ${OPENAI_API_KEY}

twilio:
  account:
    sid: ${TWILIO_ACCOUNT_SID}
  auth:
    token: ${TWILIO_AUTH_TOKEN}
  phone:
    number: ${TWILIO_PHONE_NUMBER}
```

## 🔄 Flux de fonctionnement

```mermaid
sequenceDiagram
    participant Caller
    participant Twilio
    participant TwilioController
    participant MediaStreamHandler
    participant OpenAIService
    participant OpenAI

    Caller->>Twilio: Appel téléphonique
    Twilio->>TwilioController: POST /api/voip/incoming-call
    TwilioController-->>Twilio: TwiML avec <Stream>
    Twilio->>MediaStreamHandler: WebSocket /media-stream
    MediaStreamHandler->>OpenAIService: Établit connexion
    OpenAIService->>OpenAI: WebSocket Realtime API
    
    loop Conversation
        Caller->>Twilio: Audio (G.711 μ-law)
        Twilio->>MediaStreamHandler: Media event
        MediaStreamHandler->>OpenAIService: Audio payload
        OpenAIService->>OpenAI: input_audio_buffer.append
        OpenAI->>OpenAIService: response.audio.delta
        OpenAIService->>MediaStreamHandler: Audio response
        MediaStreamHandler->>Twilio: Media event
        Twilio->>Caller: Audio réponse
    end
```

## 🛠️ Personnalisation

### Modifier l'assistant

Éditez `OpenAIRealtimeService.java` :

```java
private static final String SYSTEM_MESSAGE = 
    "Votre message système personnalisé...";

private static final String VOICE = "alloy"; // ou "echo", "fable", "onyx", "nova", "shimmer"
```

### Voix disponibles OpenAI

- `alloy` - Neutre et équilibré
- `echo` - Masculin chaleureux
- `fable` - Britannique expressif
- `onyx` - Masculin profond
- `nova` - Féminin enthousiaste
- `shimmer` - Féminin doux

### Événements loggés

Modifiez `LOG_EVENT_TYPES` dans `OpenAIRealtimeService.java` pour ajuster les événements tracés.

## 🧪 Test local

1. **Installez ngrok** : `brew install ngrok` (macOS)

2. **Démarrez l'application** :
   ```bash
   mvn spring-boot:run
   ```

3. **Exposez le serveur local** :
   ```bash
   ngrok http 8000
   ```

4. **Configurez Twilio** avec l'URL ngrok :
   ```
   https://xxxx.ngrok.io/api/voip/incoming-call
   ```

5. **Appelez votre numéro Twilio** 📞

## 📚 Dépendances Maven

```xml
<!-- WebSocket -->
<dependency>
    <groupId>org.springframework.boot</groupId>
    <artifactId>spring-boot-starter-websocket</artifactId>
</dependency>

<!-- Java-WebSocket Client -->
<dependency>
    <groupId>org.java-websocket</groupId>
    <artifactId>Java-WebSocket</artifactId>
    <version>1.5.6</version>
</dependency>

<!-- Twilio SDK -->
<dependency>
    <groupId>com.twilio.sdk</groupId>
    <artifactId>twilio</artifactId>
    <version>10.6.3</version>
</dependency>
```

## 🔐 Sécurité

- Les clés API sont stockées dans les variables d'environnement
- Utilisez l'intégration Replit Twilio pour une gestion sécurisée des secrets
- Le WebSocket supporte WSS (WebSocket Secure) en production

## 📊 Monitoring

Les logs incluent :
- Connexions/déconnexions WebSocket
- Événements OpenAI (session, audio, réponses)
- Erreurs de traitement
- Métriques de stream

## 🐛 Troubleshooting

### Erreur "Connection refused"
- Vérifiez que le serveur Spring Boot est démarré
- Vérifiez le port (par défaut 8000)

### Pas d'audio
- Vérifiez la clé API OpenAI
- Vérifiez les logs pour les événements `response.audio.delta`
- Vérifiez que le format audio est `g711_ulaw`

### Twilio ne se connecte pas
- Vérifiez l'URL du webhook (doit être HTTPS en production)
- Vérifiez que `/media-stream` est accessible
- Utilisez ngrok pour tester en local

## 📖 Références

- [Twilio Media Streams](https://www.twilio.com/docs/voice/twiml/stream)
- [OpenAI Realtime API](https://platform.openai.com/docs/api-reference/realtime)
- [Spring WebSocket](https://spring.io/guides/gs/messaging-stomp-websocket/)

## 👤 Auteur

Package créé pour le projet SaaS Multi-Tenant API
