package com.saas.voip.extractor;

import com.saas.tenant.entity.InboundCallData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

import java.time.LocalDateTime;

@Component
@Slf4j
public class CallDataExtractor {

    public InboundCallData extractFromTwilioRequest(MultiValueMap<String, String> formData) {
        try {
            InboundCallData callData = InboundCallData.builder()
                    .callSid(getFirstValue(formData, "CallSid"))
                    .provider("TWILIO")
                    .accountSid(getFirstValue(formData, "AccountSid"))
                    .apiVersion(getFirstValue(formData, "ApiVersion"))
                    .callStatus(getFirstValue(formData, "CallStatus"))
                    .direction(getFirstValue(formData, "Direction"))
                    .fromNumber(getFirstValue(formData, "From"))
                    .fromCity(getFirstValue(formData, "FromCity"))
                    .fromState(getFirstValue(formData, "FromState"))
                    .fromCountry(getFirstValue(formData, "FromCountry"))
                    .fromZip(getFirstValue(formData, "FromZip"))
                    .toNumber(getFirstValue(formData, "To"))
                    .toCity(getFirstValue(formData, "ToCity"))
                    .toState(getFirstValue(formData, "ToState"))
                    .toCountry(getFirstValue(formData, "ToCountry"))
                    .toZip(getFirstValue(formData, "ToZip"))
                    .caller(getFirstValue(formData, "Caller"))
                    .callerCity(getFirstValue(formData, "CallerCity"))
                    .callerState(getFirstValue(formData, "CallerState"))
                    .callerCountry(getFirstValue(formData, "CallerCountry"))
                    .callerZip(getFirstValue(formData, "CallerZip"))
                    .called(getFirstValue(formData, "Called"))
                    .calledCity(getFirstValue(formData, "CalledCity"))
                    .calledState(getFirstValue(formData, "CalledState"))
                    .calledCountry(getFirstValue(formData, "CalledCountry"))
                    .calledZip(getFirstValue(formData, "CalledZip"))
                    .forwardedFrom(getFirstValue(formData, "ForwardedFrom"))
                    .stirVerstat(getFirstValue(formData, "StirVerstat"))
                    .callToken(getFirstValue(formData, "CallToken"))
                    .parentCallSid(getFirstValue(formData, "ParentCallSid"))
                    .startTime(LocalDateTime.now())
                    .build();

            log.debug("📊 Extracted call data from Twilio - CallSid: {}", callData.getCallSid());
            return callData;
            
        } catch (Exception e) {
            log.error("Error extracting call data from Twilio request", e);
            throw e;
        }
    }

    private String getFirstValue(MultiValueMap<String, String> formData, String key) {
        return formData.getFirst(key);
    }
}
