package com.saas.voip.factory;

import com.saas.shared.enums.VoiceAiProviderType;
import com.saas.voip.config.VoiceAiConfig;
import com.saas.voip.handler.AiSessionHandler;
import com.saas.voip.handler.ElevenLabsSessionHandler;
import com.saas.voip.handler.OpenAiSessionHandler;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
@Slf4j
public class VoiceAiSessionFactory {
    
    private final VoiceAiConfig voiceAiConfig;
    private final OpenAiSessionHandler openAiSessionHandler;
    private final ElevenLabsSessionHandler elevenLabsSessionHandler;
    
    public AiSessionHandler createHandler() {
        VoiceAiProviderType provider = voiceAiConfig.getProvider();
        log.info("Creating AI session handler for provider: {}", provider);
        
        switch (provider) {
            case OPENAI:
                return openAiSessionHandler;
            case ELEVENLABS:
                return elevenLabsSessionHandler;
            default:
                log.warn("Unknown provider {}, falling back to OpenAI", provider);
                return openAiSessionHandler;
        }
    }
}
