package com.saas.shared.dto.mapper;

import com.saas.admin.dto.request.CreateUserRequest;
import com.saas.admin.dto.request.UpdateUserRequest;
import com.saas.admin.dto.response.UserResponse;
import com.saas.admin.entity.User;
import com.saas.tenant.dto.request.CreateTenantUserRequest;
import com.saas.tenant.dto.request.UpdateTenantUserRequest;
import com.saas.tenant.dto.response.TenantUserResponse;
import com.saas.tenant.entity.TenantUser;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-10-22T21:40:37+0100",
    comments = "version: 1.6.3, compiler: javac, environment: Java 25 (Homebrew)"
)
@Component
public class UserMapperImpl implements UserMapper {

    @Override
    public UserResponse toResponse(User user) {
        if ( user == null ) {
            return null;
        }

        UserResponse.UserResponseBuilder userResponse = UserResponse.builder();

        userResponse.id( user.getId() );
        userResponse.email( user.getEmail() );
        userResponse.userType( user.getUserType() );
        userResponse.role( user.getRole() );
        userResponse.tenantId( user.getTenantId() );
        userResponse.status( user.getStatus() );
        userResponse.firstName( user.getFirstName() );
        userResponse.lastName( user.getLastName() );
        userResponse.createdAt( user.getCreatedAt() );
        userResponse.updatedAt( user.getUpdatedAt() );

        return userResponse.build();
    }

    @Override
    public List<UserResponse> toResponseList(List<User> users) {
        if ( users == null ) {
            return null;
        }

        List<UserResponse> list = new ArrayList<UserResponse>( users.size() );
        for ( User user : users ) {
            list.add( toResponse( user ) );
        }

        return list;
    }

    @Override
    public User toEntity(CreateUserRequest request) {
        if ( request == null ) {
            return null;
        }

        User user = new User();

        user.setEmail( request.getEmail() );
        user.setUserType( request.getUserType() );
        user.setRole( request.getRole() );
        user.setTenantId( request.getTenantId() );
        user.setFirstName( request.getFirstName() );
        user.setLastName( request.getLastName() );

        return user;
    }

    @Override
    public void updateEntity(UpdateUserRequest request, User user) {
        if ( request == null ) {
            return;
        }

        user.setRole( request.getRole() );
        user.setStatus( request.getStatus() );
        user.setFirstName( request.getFirstName() );
        user.setLastName( request.getLastName() );
    }

    @Override
    public TenantUserResponse toTenantUserResponse(TenantUser user) {
        if ( user == null ) {
            return null;
        }

        TenantUserResponse.TenantUserResponseBuilder tenantUserResponse = TenantUserResponse.builder();

        tenantUserResponse.id( user.getId() );
        tenantUserResponse.email( user.getEmail() );
        tenantUserResponse.firstName( user.getFirstName() );
        tenantUserResponse.lastName( user.getLastName() );
        tenantUserResponse.status( user.getStatus() );
        tenantUserResponse.createdAt( user.getCreatedAt() );
        tenantUserResponse.updatedAt( user.getUpdatedAt() );

        return tenantUserResponse.build();
    }

    @Override
    public List<TenantUserResponse> toTenantUserResponseList(List<TenantUser> users) {
        if ( users == null ) {
            return null;
        }

        List<TenantUserResponse> list = new ArrayList<TenantUserResponse>( users.size() );
        for ( TenantUser tenantUser : users ) {
            list.add( toTenantUserResponse( tenantUser ) );
        }

        return list;
    }

    @Override
    public TenantUser toTenantUserEntity(CreateTenantUserRequest request) {
        if ( request == null ) {
            return null;
        }

        TenantUser tenantUser = new TenantUser();

        tenantUser.setEmail( request.getEmail() );
        tenantUser.setFirstName( request.getFirstName() );
        tenantUser.setLastName( request.getLastName() );

        return tenantUser;
    }

    @Override
    public void updateTenantUserEntity(UpdateTenantUserRequest request, TenantUser user) {
        if ( request == null ) {
            return;
        }

        user.setFirstName( request.getFirstName() );
        user.setLastName( request.getLastName() );
        user.setStatus( request.getStatus() );
    }
}
